/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;

public class VersionUtils {
    private static final Pattern PATTERN_MAJOR_VERSION = Pattern.compile("\\d\\.(\\d{2}).*$");
    private static final Pattern PATTERN_PATCH_VERSION = Pattern.compile("\\d\\.\\d{2}\\.(\\d+).*$");

    public static Integer getMajorVersion(String version) {
        return VersionUtils.asInt(VersionUtils.getFirstGroup(PATTERN_MAJOR_VERSION, VersionUtils.orEmpty(version)));
    }

    public static Integer getPatchVersion(String version) {
        return VersionUtils.asInt(VersionUtils.getFirstGroup(PATTERN_PATCH_VERSION, VersionUtils.orEmpty(version)));
    }

    private static Integer asInt(String string) {
        return string != null ? Integer.valueOf(string) : null;
    }

    private static String getFirstGroup(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        return matcher.matches() ? matcher.group(1) : null;
    }

    private static String orEmpty(String string) {
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{string, ""});
    }
}

