/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.model;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public class IdScheme {
    public static final IdScheme UID = new IdScheme(ObjectProperty.UID);
    public static final IdScheme CODE = new IdScheme(ObjectProperty.CODE);
    private static final Pattern ATTRIBUTE_ID_SCHEME_PATTERN = Pattern.compile("^(ATTRIBUTE|attribute):([a-zA-Z]{1}[a-zA-Z0-9]{10})$");
    private static final Pattern UID_PATTERN = Pattern.compile("^[a-zA-Z]{1}[a-zA-Z0-9]{10}$");
    private final ObjectProperty objectProperty;
    private final String attribute;

    private IdScheme(ObjectProperty objectProperty) {
        this.objectProperty = objectProperty;
        this.attribute = null;
        Validate.notNull((Object)((Object)objectProperty));
    }

    private IdScheme(ObjectProperty objectProperty, String attribute) {
        this.objectProperty = objectProperty;
        this.attribute = attribute;
        Validate.notNull((Object)((Object)objectProperty));
        Validate.notNull((Object)attribute);
    }

    public IdScheme(String idScheme) {
        IdScheme scheme = IdScheme.createIdScheme(idScheme);
        this.objectProperty = scheme.objectProperty;
        this.attribute = scheme.attribute;
        Validate.notNull((Object)((Object)this.objectProperty));
    }

    public static IdScheme createAttributeIdScheme(String attribute) {
        Validate.isTrue((boolean)IdScheme.isValidUid(attribute));
        return new IdScheme(ObjectProperty.ATTRIBUTE, attribute);
    }

    public static IdScheme createIdScheme(String idScheme) {
        if (idScheme == null) {
            return null;
        }
        if (ObjectProperty.UID.name().equalsIgnoreCase(idScheme)) {
            return UID;
        }
        if (ObjectProperty.CODE.name().equalsIgnoreCase(idScheme)) {
            return CODE;
        }
        Matcher attributeMatcher = ATTRIBUTE_ID_SCHEME_PATTERN.matcher(idScheme);
        if (attributeMatcher.matches()) {
            String attribute = attributeMatcher.group(2);
            return new IdScheme(ObjectProperty.ATTRIBUTE, attribute);
        }
        throw new IllegalArgumentException(String.format("ID scheme is invalid: '%s'", idScheme));
    }

    private static boolean isValidUid(String uid) {
        return uid != null && UID_PATTERN.matcher(uid).matches();
    }

    public ObjectProperty getObjectProperty() {
        return this.objectProperty;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.objectProperty, this.attribute});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        IdScheme other = (IdScheme)o;
        return Objects.equals((Object)this.objectProperty, (Object)other.objectProperty) && Objects.equals(this.attribute, other.attribute);
    }

    public String name() {
        return this.toString();
    }

    public String toString() {
        if (ObjectProperty.ATTRIBUTE == this.objectProperty) {
            return "attribute:" + this.attribute;
        }
        return this.objectProperty.name().toLowerCase();
    }

    static enum ObjectProperty {
        UID,
        CODE,
        ATTRIBUTE;

    }
}

