/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.util;

import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DateTimeUtils {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String DATE_FORMAT = "yyyy-MM-dd";

    public static Date getDate(int year, int month, int dayOfMonth) {
        LocalDate localDate = LocalDate.of(year, month, dayOfMonth);
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static String getDateString(Date date) {
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }

    public static LocalDate getLocalDate(String string) {
        return LocalDate.parse(string);
    }

    public static String getLocalDateString(LocalDate date) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(date);
    }

    public static boolean isValidLocalDate(String string) {
        try {
            return string != null && DateTimeUtils.getLocalDate(string) != null;
        }
        catch (DateTimeException ex) {
            return false;
        }
    }

    public static LocalDateTime getLocalDateTime(String string) {
        string = StringUtils.removeEndIgnoreCase((String)string, (String)"z");
        return LocalDateTime.parse(string);
    }

    public static LocalDate getLocalDateTimeAsDate(String string) {
        return DateTimeUtils.getLocalDateTime(string).toLocalDate();
    }

    public static boolean isValidLocalDateTime(String string) {
        try {
            return string != null && DateTimeUtils.getLocalDateTime(string) != null;
        }
        catch (DateTimeException ex) {
            return false;
        }
    }

    public static String getLocalDateTimeString(LocalDateTime dateTime) {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(dateTime);
    }

    public static String getDateTimeString(Date dateTime) {
        return new SimpleDateFormat(DATE_TIME_FORMAT).format(dateTime);
    }

    public static String getUtcDateTimeString(LocalDateTime dateTime) {
        return String.format("%sZ", DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(dateTime));
    }

    public static String getUtcDateTimeString(Date dateTime) {
        return String.format("%sZ", new SimpleDateFormat(DATE_TIME_FORMAT).format(dateTime));
    }
}

