/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.query;

import java.util.ArrayList;
import java.util.List;
import org.hisp.dhis.query.Filter;
import org.hisp.dhis.query.Order;
import org.hisp.dhis.query.Paging;
import org.hisp.dhis.query.RootJunction;

public class Query {
    private final List<Filter> filters = new ArrayList<Filter>();
    private Paging paging;
    private Order order;
    private RootJunction rootJunction;
    private boolean expandAssociations = false;

    private Query() {
    }

    public static Query instance() {
        return new Query();
    }

    public Query addFilter(Filter filter) {
        this.filters.add(filter);
        return this;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public Query setPaging(Integer page, Integer pageSize) {
        this.paging = new Paging(page, pageSize);
        return this;
    }

    public Paging getPaging() {
        return this.paging != null ? this.paging : new Paging(null, null);
    }

    public Query setOrder(Order order) {
        this.order = order;
        return this;
    }

    public Order getOrder() {
        return this.order != null ? this.order : new Order(null, null);
    }

    public RootJunction getRootJunction() {
        return this.rootJunction != null ? this.rootJunction : RootJunction.AND;
    }

    public Query withExpandAssociations() {
        this.expandAssociations = true;
        return this;
    }

    public Query withRootJunction(RootJunction rootJunction) {
        this.rootJunction = rootJunction;
        return this;
    }

    public boolean isExpandAssociations() {
        return this.expandAssociations;
    }
}

