/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.net.URIBuilder;
import org.hisp.dhis.Dhis2Config;
import org.hisp.dhis.auth.Authentication;

public class HttpUtils {
    public static <T extends HttpUriRequestBase> T withAuth(T request, Dhis2Config config) {
        Authentication auth = config.getAuthentication();
        request.setHeader(auth.getHttpHeaderAuthName(), (Object)auth.getHttpHeaderAuthValue());
        return request;
    }

    public static URI build(URIBuilder uriBuilder) {
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String asString(URI uri) {
        try {
            return URLDecoder.decode(uri.toString(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private HttpUtils() {
    }
}

