/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.util;

import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;

public class UidUtils {
    private static final String letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String ALLOWED_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final int NUMBER_OF_CODEPOINTS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length();
    private static final Pattern UID_PATTERN = Pattern.compile("^[a-zA-Z]{1}[a-zA-Z0-9]{10}$");
    private static final int CODESIZE = 11;

    public static String generateUid() {
        return UidUtils.generateCode(11);
    }

    public static boolean isValidUid(String code) {
        return code != null && UID_PATTERN.matcher(code).matches();
    }

    private static String generateCode(int codeSize) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        char[] randomChars = new char[codeSize];
        randomChars[0] = letters.charAt(r.nextInt(letters.length()));
        for (int i = 1; i < codeSize; ++i) {
            randomChars[i] = ALLOWED_CHARS.charAt(r.nextInt(NUMBER_OF_CODEPOINTS));
        }
        return new String(randomChars);
    }

    private UidUtils() {
    }
}

