/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.query;

import org.apache.commons.lang3.Validate;

public class Paging {
    private static final int DEFAULT_PAGE_SIZE = 50;
    private static final int DEFAULT_PAGE = 1;
    private final Integer page;
    private final Integer pageSize;

    public Paging() {
        this.page = 1;
        this.pageSize = 50;
    }

    public Paging(Integer page, Integer pageSize) {
        Validate.isTrue((page == null || page >= 1 ? 1 : 0) != 0, (String)"Page must be greater than zero if specified", (Object[])new Object[0]);
        Validate.isTrue((pageSize == null || pageSize >= 1 ? 1 : 0) != 0, (String)"Page size must be greater than zero if specified", (Object[])new Object[0]);
        this.page = page;
        this.pageSize = pageSize;
    }

    public boolean hasPage() {
        return this.page != null && this.page >= 0;
    }

    public int getPageOrDefault() {
        return this.hasPage() ? this.page : 1;
    }

    public int getPageSizeOrDefault() {
        return this.hasPageSize() ? this.pageSize : 50;
    }

    public boolean hasPageSize() {
        return this.pageSize != null && this.pageSize >= 0;
    }

    public boolean hasPaging() {
        return this.hasPage() || this.hasPageSize();
    }

    public int getOffset() {
        return this.getPageSizeOrDefault() * (this.getPageOrDefault() - 1);
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }
}

