/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hisp.dhis.model.CategoryCombo;
import org.hisp.dhis.model.DataElement;
import org.hisp.dhis.model.NameableObject;
import org.hisp.dhis.model.ProgramStage;
import org.hisp.dhis.model.ProgramTrackedEntityAttribute;
import org.hisp.dhis.model.ProgramType;
import org.hisp.dhis.model.TrackedEntityAttribute;
import org.hisp.dhis.util.CollectionUtils;

public class Program
extends NameableObject {
    @JsonProperty
    private ProgramType programType;
    @JsonProperty
    private CategoryCombo categoryCombo;
    @JsonProperty
    private List<ProgramTrackedEntityAttribute> programTrackedEntityAttributes = new ArrayList<ProgramTrackedEntityAttribute>();
    @JsonProperty
    private List<ProgramStage> programStages = new ArrayList<ProgramStage>();

    public Program(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public List<TrackedEntityAttribute> getTrackedEntityAttributes() {
        return this.programTrackedEntityAttributes.stream().map(ProgramTrackedEntityAttribute::getTrackedEntityAttribute).collect(Collectors.toUnmodifiableList());
    }

    public List<TrackedEntityAttribute> getNonConfidentialTrackedEntityAttributes() {
        return this.programTrackedEntityAttributes.stream().map(ProgramTrackedEntityAttribute::getTrackedEntityAttribute).filter(tea -> tea.getConfidential() == null || tea.getConfidential() == false).collect(Collectors.toUnmodifiableList());
    }

    @JsonIgnore
    public Set<DataElement> getDataElements() {
        return this.programStages.stream().flatMap(ps -> ps.getDataElements().stream()).collect(Collectors.toUnmodifiableSet());
    }

    @JsonIgnore
    public Set<DataElement> getAnalyticsDataElements() {
        return this.programStages.stream().flatMap(ps -> ps.getAnalyticsDataElements().stream()).collect(Collectors.toUnmodifiableSet());
    }

    @JsonIgnore
    public Set<DataElement> getAnalyticsDataElementsWithLegendSet() {
        return this.programStages.stream().flatMap(ps -> ps.getAnalyticsDataElements().stream()).filter(de -> CollectionUtils.notEmpty(de.getLegendSets()) && de.getValueType().isNumeric()).collect(Collectors.toUnmodifiableSet());
    }

    @JsonIgnore
    public boolean hasCategoryCombo() {
        return this.categoryCombo != null;
    }

    public ProgramType getProgramType() {
        return this.programType;
    }

    public CategoryCombo getCategoryCombo() {
        return this.categoryCombo;
    }

    public List<ProgramTrackedEntityAttribute> getProgramTrackedEntityAttributes() {
        return this.programTrackedEntityAttributes;
    }

    public List<ProgramStage> getProgramStages() {
        return this.programStages;
    }

    @JsonProperty
    public void setProgramType(ProgramType programType) {
        this.programType = programType;
    }

    @JsonProperty
    public void setCategoryCombo(CategoryCombo categoryCombo) {
        this.categoryCombo = categoryCombo;
    }

    @JsonProperty
    public void setProgramTrackedEntityAttributes(List<ProgramTrackedEntityAttribute> programTrackedEntityAttributes) {
        this.programTrackedEntityAttributes = programTrackedEntityAttributes;
    }

    @JsonProperty
    public void setProgramStages(List<ProgramStage> programStages) {
        this.programStages = programStages;
    }

    public Program() {
    }
}

