/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.hisp.dhis.BaseDhis2;
import org.hisp.dhis.Dhis2AsyncRequest;
import org.hisp.dhis.Dhis2Config;
import org.hisp.dhis.auth.AccessTokenAuthentication;
import org.hisp.dhis.auth.BasicAuthentication;
import org.hisp.dhis.auth.CookieAuthentication;
import org.hisp.dhis.model.Category;
import org.hisp.dhis.model.CategoryCombo;
import org.hisp.dhis.model.CategoryOption;
import org.hisp.dhis.model.CategoryOptionCombo;
import org.hisp.dhis.model.CategoryOptionGroup;
import org.hisp.dhis.model.CategoryOptionGroupSet;
import org.hisp.dhis.model.Dashboard;
import org.hisp.dhis.model.DataElement;
import org.hisp.dhis.model.DataElementGroup;
import org.hisp.dhis.model.DataElementGroupSet;
import org.hisp.dhis.model.DataSet;
import org.hisp.dhis.model.Dimension;
import org.hisp.dhis.model.ImportStrategy;
import org.hisp.dhis.model.Indicator;
import org.hisp.dhis.model.IndicatorGroup;
import org.hisp.dhis.model.IndicatorGroupSet;
import org.hisp.dhis.model.IndicatorType;
import org.hisp.dhis.model.Me;
import org.hisp.dhis.model.Objects;
import org.hisp.dhis.model.OptionSet;
import org.hisp.dhis.model.OrgUnit;
import org.hisp.dhis.model.OrgUnitGroup;
import org.hisp.dhis.model.OrgUnitGroupSet;
import org.hisp.dhis.model.OrgUnitLevel;
import org.hisp.dhis.model.PeriodType;
import org.hisp.dhis.model.Program;
import org.hisp.dhis.model.ProgramIndicator;
import org.hisp.dhis.model.SystemInfo;
import org.hisp.dhis.model.SystemSettings;
import org.hisp.dhis.model.TableHook;
import org.hisp.dhis.model.datastore.DataStoreEntries;
import org.hisp.dhis.model.datastore.EntryMetadata;
import org.hisp.dhis.model.datavalueset.DataValueSet;
import org.hisp.dhis.model.datavalueset.DataValueSetImportOptions;
import org.hisp.dhis.model.event.Event;
import org.hisp.dhis.model.event.Events;
import org.hisp.dhis.model.event.EventsResult;
import org.hisp.dhis.query.Query;
import org.hisp.dhis.query.analytics.AnalyticsQuery;
import org.hisp.dhis.query.datavalue.DataValueSetQuery;
import org.hisp.dhis.query.event.EventsQuery;
import org.hisp.dhis.request.orgunit.OrgUnitMergeRequest;
import org.hisp.dhis.request.orgunit.OrgUnitSplitRequest;
import org.hisp.dhis.response.Dhis2ClientException;
import org.hisp.dhis.response.HttpStatus;
import org.hisp.dhis.response.Response;
import org.hisp.dhis.response.datavalueset.DataValueSetResponse;
import org.hisp.dhis.response.event.EventResponse;
import org.hisp.dhis.response.job.JobCategory;
import org.hisp.dhis.response.job.JobNotification;
import org.hisp.dhis.response.object.ObjectResponse;
import org.hisp.dhis.response.objects.ObjectsResponse;
import org.hisp.dhis.util.CollectionUtils;
import org.hisp.dhis.util.HttpUtils;

public class Dhis2
extends BaseDhis2 {
    public static final String SUPER_AUTH = "ALL";

    public Dhis2(Dhis2Config config) {
        super(config);
    }

    public static Dhis2 withBasicAuth(String url, String username, String password) {
        return new Dhis2(new Dhis2Config(url, new BasicAuthentication(username, password)));
    }

    public static Dhis2 withAccessTokenAuth(String url, String accessToken) {
        return new Dhis2(new Dhis2Config(url, new AccessTokenAuthentication(accessToken)));
    }

    public static Dhis2 withCookieAuth(String url, String sessionId) {
        return new Dhis2(new Dhis2Config(url, new CookieAuthentication(sessionId)));
    }

    public HttpStatus getStatus() {
        HttpStatus httpStatus;
        block9: {
            URI url = HttpUtils.build(this.config.getResolvedUriBuilder().appendPath("system").appendPath("info"));
            HttpGet request = this.withAuth(new HttpGet(url));
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)request);
            try {
                int statusCode = response.getCode();
                httpStatus = HttpStatus.valueOf(statusCode);
                if (response == null) break block9;
            }
            catch (Throwable statusCode) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            statusCode.addSuppressed(throwable);
                        }
                    }
                    throw statusCode;
                }
                catch (IOException ex) {
                    if (ex instanceof HttpResponseException) {
                        int statusCode2 = ((HttpResponseException)ex).getStatusCode();
                        return HttpStatus.valueOf(statusCode2);
                    }
                    throw new Dhis2ClientException("Failed to get system info", ex);
                }
            }
            response.close();
        }
        return httpStatus;
    }

    public String getDhis2Url() {
        return this.config.getUrl();
    }

    public boolean objectExists(String path) {
        return this.objectExists(this.config.getResolvedUriBuilder().appendPath(path));
    }

    public SystemInfo getSystemInfo() {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("system").appendPath("info"), Query.instance(), SystemInfo.class);
    }

    public List<String> getUserAuthorization() {
        return this.getObject("me/authorization", List.class);
    }

    public Me getMe() {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("me").addParameter("fields", ME_FIELDS), Query.instance(), Me.class);
    }

    public <T> Response saveDataStoreEntry(String namespace, String key, T object) {
        return this.saveObject(this.getDataStorePath(namespace, key), object, Response.class);
    }

    public <T> Response updateDataStoreEntry(String namespace, String key, T object) {
        return this.updateObject(this.getDataStorePath(namespace, key), Map.of(), object, Response.class);
    }

    public List<String> getDataStoreNamespaces() {
        return this.getObject("dataStore", List.class);
    }

    public List<String> getDataStoreKeys(String namespace) {
        return this.getObject(String.format("dataStore/%s", namespace), List.class);
    }

    public <T> T getDataStoreEntry(String namespace, String key, Class<T> type) {
        return this.getObject(this.getDataStorePath(namespace, key), type);
    }

    public List<Map<String, Object>> getDatastoreEntries(String namespace, List<String> fields) {
        Validate.notEmpty(fields);
        String fieldsValue = String.join((CharSequence)",", fields);
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("dataStore").appendPath(namespace).addParameter("fields", fieldsValue), Query.instance().setPaging(1, 100000), DataStoreEntries.class).getEntries();
    }

    public EntryMetadata getDataStoreEntryMetadata(String namespace, String key) {
        String path = String.format("dataStore/%s/%s/metaData", namespace, key);
        return this.getObject(path, EntryMetadata.class);
    }

    public Response removeDataStoreEntry(String namespace, String key) {
        return this.removeObject(this.getDataStorePath(namespace, key), Response.class);
    }

    public Response removeDataStoreNamespace(String namespace) {
        return this.removeObject(String.format("dataStore/%s", namespace), Response.class);
    }

    private String getDataStorePath(String namespace, String key) {
        return String.format("dataStore/%s/%s", namespace, key);
    }

    public ObjectResponse saveOrgUnit(OrgUnit orgUnit) {
        return this.saveMetadataObject("organisationUnits", orgUnit);
    }

    public ObjectsResponse saveOrgUnits(List<OrgUnit> orgUnits) {
        return this.saveMetadataObjects(new Objects().setOrganisationUnits(orgUnits));
    }

    public ObjectResponse updateOrgUnit(OrgUnit orgUnit) {
        return this.updateMetadataObject(String.format("organisationUnits/%s", orgUnit.getId()), orgUnit);
    }

    public ObjectResponse removeOrgUnit(String id) {
        return this.removeMetadataObject(String.format("organisationUnits/%s", id));
    }

    public OrgUnit getOrgUnit(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("organisationUnits").appendPath(id).addParameter("fields", ORG_UNIT_FIELDS), Query.instance(), OrgUnit.class);
    }

    public boolean isOrgUnit(String id) {
        return this.objectExists(this.config.getResolvedUriBuilder().appendPath("organisationUnits").appendPath(id));
    }

    public List<OrgUnit> getOrgUnitSubHierarchy(String id, Integer level, Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("organisationUnits").appendPath(id).addParameter("fields", ORG_UNIT_FIELDS).addParameter("level", String.valueOf(level)), query, Objects.class).getOrganisationUnits();
    }

    public List<OrgUnit> getOrgUnits(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("organisationUnits").addParameter("fields", ORG_UNIT_FIELDS), query, Objects.class).getOrganisationUnits();
    }

    public Response splitOrgUnit(OrgUnitSplitRequest request) {
        URI url = this.config.getResolvedUrl("organisationUnits/split");
        return this.executeJsonPostPutRequest((HttpUriRequestBase)new HttpPost(url), request, Response.class);
    }

    public Response mergeOrgUnits(OrgUnitMergeRequest request) {
        URI url = this.config.getResolvedUrl("organisationUnits/merge");
        return this.executeJsonPostPutRequest((HttpUriRequestBase)new HttpPost(url), request, Response.class);
    }

    public ObjectResponse saveOrgUnitGroup(OrgUnitGroup orgUnitGroup) {
        return this.saveMetadataObject("organisationUnitGroups", orgUnitGroup);
    }

    public ObjectsResponse saveOrgUnitGroups(List<OrgUnitGroup> orgUnitGroups) {
        return this.saveMetadataObjects(new Objects().setOrganisationUnitGroups(orgUnitGroups));
    }

    public ObjectResponse updateOrgUnitGroup(OrgUnitGroup orgUnitGroup) {
        return this.updateMetadataObject(String.format("organisationUnitGroups/%s", orgUnitGroup.getId()), orgUnitGroup);
    }

    public ObjectResponse removeOrgUnitGroup(String id) {
        return this.removeMetadataObject(String.format("organisationUnitGroups/%s", id));
    }

    public OrgUnitGroup getOrgUnitGroup(String id) {
        String fieldsParams = String.format("%1$s,organisationUnits[%2$s]", NAME_FIELDS, ORG_UNIT_FIELDS);
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("organisationUnitGroups").appendPath(id).addParameter("fields", fieldsParams), Query.instance(), OrgUnitGroup.class);
    }

    public List<OrgUnitGroup> getOrgUnitGroups(Query query) {
        String fieldsParams = query.isExpandAssociations() ? String.format("%1$s,organisationUnits[id,code,name]", NAME_FIELDS) : NAME_FIELDS;
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("organisationUnitGroups").addParameter("fields", fieldsParams), query, Objects.class).getOrganisationUnitGroups();
    }

    public Response addOrgUnitToOrgUnitGroup(String orgUnitGroup, String orgUnit) {
        return this.addToCollection("organisationUnitGroups", orgUnitGroup, "organisationUnits", orgUnit);
    }

    public ObjectResponse saveOrgUnitGroupSet(OrgUnitGroupSet orgUnitGroupSet) {
        return this.saveMetadataObject("organisationUnitGroupSets", orgUnitGroupSet);
    }

    public ObjectsResponse saveOrgUnitGroupSets(List<OrgUnitGroupSet> orgUnitGroupSets) {
        return this.saveMetadataObjects(new Objects().setOrganisationUnitGroupSets(orgUnitGroupSets));
    }

    public ObjectResponse updateOrgUnitGroupSet(OrgUnitGroupSet orgUnitGroupSet) {
        return this.updateMetadataObject(String.format("organisationUnitGroupSets/%s", orgUnitGroupSet.getId()), orgUnitGroupSet);
    }

    public ObjectResponse removeOrgUnitGroupSet(String id) {
        return this.removeMetadataObject(String.format("organisationUnitGroupSets/%s", id));
    }

    public OrgUnitGroupSet getOrgUnitGroupSet(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("organisationUnitGroupSets").appendPath(id).addParameter("fields", ORG_UNIT_GROUP_SET_FIELDS), Query.instance(), OrgUnitGroupSet.class);
    }

    public List<OrgUnitGroupSet> getOrgUnitGroupSets(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("organisationUnitGroupSets").addParameter("fields", ORG_UNIT_GROUP_SET_FIELDS), query, Objects.class).getOrganisationUnitGroupSets();
    }

    public OrgUnitLevel getOrgUnitLevel(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("organisationUnitLevels").appendPath(id).addParameter("fields", String.format("%s,level", "id,code,name,created,lastUpdated,attributeValues")), Query.instance(), OrgUnitLevel.class);
    }

    public List<OrgUnitLevel> getOrgUnitLevels(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("organisationUnitLevels").addParameter("fields", String.format("%s,level", "id,code,name,created,lastUpdated,attributeValues")), query, Objects.class).getOrganisationUnitLevels();
    }

    public List<OrgUnitLevel> getFilledOrgUnitLevels() {
        return CollectionUtils.asList(this.getObject(this.config.getResolvedUriBuilder().appendPath("filledOrganisationUnitLevels"), Query.instance(), OrgUnitLevel[].class));
    }

    public ObjectResponse saveCategoryOption(CategoryOption categoryOption) {
        return this.saveMetadataObject("categoryOptions", categoryOption);
    }

    public ObjectsResponse saveCategoryOptions(List<CategoryOption> categoryOptions) {
        return this.saveMetadataObjects(new Objects().setCategoryOptions(categoryOptions));
    }

    public ObjectResponse updateCategoryOption(CategoryOption categoryOption) {
        return this.updateMetadataObject(String.format("categoryOptions/%s", categoryOption.getId()), categoryOption);
    }

    public ObjectResponse removeCategoryOption(String id) {
        return this.removeMetadataObject(String.format("categoryOptions/%s", id));
    }

    public CategoryOption getCategoryOption(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("categoryOptions").appendPath(id).addParameter("fields", CATEGORY_OPTION_FIELDS), Query.instance(), CategoryOption.class);
    }

    public List<CategoryOption> getCategoryOptions(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("categoryOptions").addParameter("fields", CATEGORY_OPTION_FIELDS), query, Objects.class).getCategoryOptions();
    }

    public ObjectResponse saveCategory(Category category) {
        return this.saveMetadataObject("categories", category);
    }

    public ObjectsResponse saveCategories(List<Category> categories) {
        return this.saveMetadataObjects(new Objects().setCategories(categories));
    }

    public ObjectResponse updateCategory(Category category) {
        return this.updateMetadataObject(String.format("categories/%s", category.getId()), category);
    }

    public ObjectResponse removeCategory(String id) {
        return this.removeMetadataObject(String.format("categories/%s", id));
    }

    public Category getCategory(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("categories").appendPath(id).addParameter("fields", CATEGORY_FIELDS), Query.instance(), Category.class);
    }

    public boolean isCategory(String id) {
        return this.objectExists(this.config.getResolvedUriBuilder().appendPath("categories").appendPath(id));
    }

    public List<Category> getCategories(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("categories").addParameter("fields", CATEGORY_FIELDS), query, Objects.class).getCategories();
    }

    public CategoryCombo getCategoryCombo(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("categoryCombos").appendPath(id).addParameter("fields", CATEGORY_COMBO_FIELDS), Query.instance(), CategoryCombo.class);
    }

    public List<CategoryCombo> getCategoryCombos(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("categoryCombos").addParameter("fields", CATEGORY_COMBO_FIELDS), query, Objects.class).getCategoryCombos();
    }

    public CategoryOptionCombo getCategoryOptionCombo(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("categoryOptionCombos").appendPath(id).addParameter("fields", CATEGORY_OPTION_COMBO_FIELDS), Query.instance(), CategoryOptionCombo.class);
    }

    public List<CategoryOptionCombo> getCategoryOptionCombos(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("categoryOptionCombos").addParameter("fields", CATEGORY_OPTION_COMBO_FIELDS), query, Objects.class).getCategoryOptionCombos();
    }

    public ObjectResponse saveDataElement(DataElement dataElement) {
        return this.saveMetadataObject("dataElements", dataElement);
    }

    public ObjectsResponse saveDataElements(List<DataElement> dataElements) {
        return this.saveMetadataObjects(new Objects().setDataElements(dataElements));
    }

    public ObjectResponse updateDataElement(DataElement dataElement) {
        return this.updateMetadataObject(String.format("dataElements/%s", dataElement.getId()), dataElement);
    }

    public ObjectResponse removeDataElement(String id) {
        return this.removeMetadataObject(String.format("dataElements/%s", id));
    }

    public DataElement getDataElement(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("dataElements").appendPath(id).addParameter("fields", DATA_ELEMENT_FIELDS), Query.instance(), DataElement.class);
    }

    public boolean isDataElement(String id) {
        return this.objectExists(this.config.getResolvedUriBuilder().appendPath("dataElements").appendPath(id));
    }

    public List<DataElement> getDataElements(Query query) {
        String fieldsParam = query.isExpandAssociations() ? String.format("%1$s,dataElementGroups[id,code,name,groupSets[id,code,name]],dataSetElements[dataSet[id,name,periodType,workflow[id,name]]]", DATA_ELEMENT_FIELDS) : DATA_ELEMENT_FIELDS;
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("dataElements").addParameter("fields", fieldsParam), query, Objects.class).getDataElements();
    }

    public ObjectResponse saveDataElementGroup(DataElementGroup dataElementGroup) {
        return this.saveMetadataObject("dataElementGroups", dataElementGroup);
    }

    public ObjectsResponse saveDataElementGroups(List<DataElementGroup> dataElementGroups) {
        return this.saveMetadataObjects(new Objects().setDataElementGroups(dataElementGroups));
    }

    public ObjectResponse updateDataElementGroup(DataElementGroup dataElementGroup) {
        return this.updateMetadataObject(String.format("dataElementGroups/%s", dataElementGroup.getId()), dataElementGroup);
    }

    public ObjectResponse removeDataElementGroup(String id) {
        return this.removeMetadataObject(String.format("dataElementGroups/%s", id));
    }

    public DataElementGroup getDataElementGroup(String id) {
        String fieldsParams = String.format("%1$s,dataElements[%2$s]", NAME_FIELDS, DATA_ELEMENT_FIELDS);
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("dataElementGroups").appendPath(id).addParameter("fields", fieldsParams), Query.instance(), DataElementGroup.class);
    }

    public List<DataElementGroup> getDataElementGroups(Query query) {
        String fieldsParams = query.isExpandAssociations() ? String.format("%1$s,dataElements[%2$s]", NAME_FIELDS, DATA_ELEMENT_FIELDS) : NAME_FIELDS;
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("dataElementGroups").addParameter("fields", fieldsParams), query, Objects.class).getDataElementGroups();
    }

    public DataElementGroupSet getDataElementGroupSet(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("dataElementGroupSets").appendPath(id).addParameter("fields", DATA_ELEMENT_GROUP_SET_FIELDS), Query.instance(), DataElementGroupSet.class);
    }

    public List<DataElementGroupSet> getDataElementGroupSets(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("dataElementGroupSets").addParameter("fields", DATA_ELEMENT_GROUP_SET_FIELDS), query, Objects.class).getDataElementGroupSets();
    }

    public Indicator getIndicator(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("indicators").appendPath(id).addParameter("fields", INDICATOR_FIELDS), Query.instance(), Indicator.class);
    }

    public List<Indicator> getIndicators(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("indicators").addParameter("fields", INDICATOR_FIELDS), query, Objects.class).getIndicators();
    }

    public IndicatorGroup getIndicatorGroup(String id) {
        String fieldsParams = String.format("%1$s,indicators[%2$s]", NAME_FIELDS, INDICATOR_FIELDS);
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("indicatorGroups").appendPath(id).addParameter("fields", fieldsParams), Query.instance(), IndicatorGroup.class);
    }

    public List<IndicatorGroup> getIndicatorGroups(Query query) {
        String fieldsParams = query.isExpandAssociations() ? String.format("%1$s,indicators[%2$s]", NAME_FIELDS, INDICATOR_FIELDS) : NAME_FIELDS;
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("indicatorGroups").addParameter("fields", fieldsParams), query, Objects.class).getIndicatorGroups();
    }

    public IndicatorGroupSet getIndicatorGroupSet(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("indicatorGroupSets").appendPath(id).addParameter("fields", INDICATOR_GROUP_SET_FIELDS), Query.instance(), IndicatorGroupSet.class);
    }

    public List<IndicatorGroupSet> getIndicatorGroupSets(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("indicatorGroupSets").addParameter("fields", INDICATOR_GROUP_SET_FIELDS), query, Objects.class).getIndicatorGroupSets();
    }

    public IndicatorType getIndicatorType(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("indicatorTypes").appendPath(id).addParameter("fields", INDICATOR_TYPE_FIELDS), Query.instance(), IndicatorType.class);
    }

    public List<IndicatorType> getIndicatorTypes(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("indicators").addParameter("fields", INDICATOR_FIELDS), query, Objects.class).getIndicatorTypes();
    }

    public DataSet getDataSet(String id) {
        String fieldsParam = String.format("%1$s,organisationUnits[%2$s],workflow[%2$s],indicators[%2$s],sections[%2$s],legendSets[%2$s]", DATA_SET_FIELDS, NAME_FIELDS);
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("dataSets").appendPath(id).addParameter("fields", fieldsParam), Query.instance(), DataSet.class);
    }

    public List<DataSet> getDataSets(Query query) {
        String fieldsParam = query.isExpandAssociations() ? String.format("%1$s,organisationUnits[%2$s],workflow[%2$s],indicators[%2$s],sections[%2$s],legendSets[%2$s]", DATA_SET_FIELDS, NAME_FIELDS) : DATA_SET_FIELDS;
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("dataSets").addParameter("fields", fieldsParam), query, Objects.class).getDataSets();
    }

    public Program getProgram(String id) {
        String fieldsParam = String.format("%1$s,programType,categoryCombo[%1$s,categories[%2$s]],programStages[%1$s,programStageDataElements[%3$s]],programTrackedEntityAttributes[id,code,name,trackedEntityAttribute[%4$s]]", NAME_FIELDS, CATEGORY_FIELDS, PROGRAM_STAGE_DATA_ELEMENT_FIELDS, TE_ATTRIBUTE_FIELDS);
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("programs").appendPath(id).addParameter("fields", fieldsParam), Query.instance(), Program.class);
    }

    public boolean isProgram(String id) {
        return this.objectExists(this.config.getResolvedUriBuilder().appendPath("programs").appendPath(id));
    }

    public List<Program> getPrograms(Query query) {
        String fieldsParam = query.isExpandAssociations() ? String.format("%1$s,programType,categoryCombo[%1$s,categories[%2$s]],programStages[%1$s,programStageDataElements[%3$s]],programTrackedEntityAttributes[id,code,name,trackedEntityAttribute[%4$s]]", NAME_FIELDS, CATEGORY_FIELDS, PROGRAM_STAGE_DATA_ELEMENT_FIELDS, TE_ATTRIBUTE_FIELDS) : String.format("%1$s,programType,categoryCombo[%1$s],programStages[%1$s],programTrackedEntityAttributes[%1$s]", NAME_FIELDS);
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("programs").addParameter("fields", fieldsParam), query, Objects.class).getPrograms();
    }

    public Response addOrgUnitToProgram(String program, String orgUnit) {
        return this.addToCollection("programs", program, "organisationUnits", orgUnit);
    }

    public ProgramIndicator getProgramIndicator(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("programIndicators").appendPath(id).addParameter("fields", NAME_FIELDS), Query.instance(), ProgramIndicator.class);
    }

    public List<ProgramIndicator> getProgramIndicators(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("programIndicators").addParameter("fields", NAME_FIELDS), query, Objects.class).getProgramIndicators();
    }

    public CategoryOptionGroup getCategoryOptionGroup(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("categoryOptionGroups").appendPath(id).addParameter("fields", CATEGORY_OPTION_GROUP_FIELDS), Query.instance(), CategoryOptionGroup.class);
    }

    public List<CategoryOptionGroup> getCategoryOptionGroups(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("categoryOptionGroups").addParameter("fields", CATEGORY_OPTION_GROUP_FIELDS), query, Objects.class).getCategoryOptionGroups();
    }

    public CategoryOptionGroupSet getCategoryOptionGroupSet(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("categoryOptionGroupSets").appendPath(id).addParameter("fields", CATEGORY_OPTION_GROUP_SET_FIELDS), Query.instance(), CategoryOptionGroupSet.class);
    }

    public List<CategoryOptionGroupSet> getCategoryOptionGroupSets(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("categoryOptionGroupSets").addParameter("fields", CATEGORY_OPTION_GROUP_SET_FIELDS), query, Objects.class).getCategoryOptionGroupSets();
    }

    public OptionSet getOptionSet(String id) {
        String fieldsParam = String.format("%1$s,options[%2$s]", OPTION_SET_FIELDS, NAME_FIELDS);
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("optionSets").appendPath(id).addParameter("fields", fieldsParam), Query.instance(), OptionSet.class);
    }

    public List<OptionSet> getOptionSets(Query query) {
        String fieldsParam = query.isExpandAssociations() ? String.format("%1$s,options[%2$s]", OPTION_SET_FIELDS, NAME_FIELDS) : OPTION_SET_FIELDS;
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("optionSets").addParameter("fields", fieldsParam), query, Objects.class).getOptionSets();
    }

    public ObjectResponse saveTableHook(TableHook tableHook) {
        return this.saveMetadataObject("analyticsTableHooks", tableHook);
    }

    public ObjectsResponse saveTableHooks(List<TableHook> tableHooks) {
        return this.saveMetadataObjects(new Objects().setAnalyticsTableHooks(tableHooks));
    }

    public ObjectResponse updateTableHook(TableHook tableHook) {
        return this.updateMetadataObject(String.format("analyticsTableHooks/%s", tableHook.getId()), tableHook);
    }

    public ObjectResponse removeTableHook(String id) {
        return this.removeMetadataObject(String.format("analyticsTableHooks/%s", id));
    }

    public TableHook getTableHook(String id) {
        return this.getObject("analyticsTableHooks", id, TableHook.class);
    }

    public List<TableHook> getTableHooks(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("analyticsTableHooks").addParameter("fields", "id,code,name,created,lastUpdated,attributeValues"), query, Objects.class).getAnalyticsTableHooks();
    }

    public Dashboard getDashboard(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("dashboards").appendPath(id).addParameter("fields", NAME_FIELDS), Query.instance(), Dashboard.class);
    }

    public List<Dashboard> getDashboards(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("dashboards").addParameter("fields", NAME_FIELDS), query, Objects.class).getDashboards();
    }

    public Dimension getDimension(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("dimensions").appendPath(id).addParameter("fields", String.format("%s,dimensionType", "id,code,name,created,lastUpdated,attributeValues")), Query.instance(), Dimension.class);
    }

    public List<Dimension> getDimensions(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("dimensions").addParameter("fields", String.format("%s,dimensionType", "id,code,name,created,lastUpdated,attributeValues")), query, Objects.class).getDimensions();
    }

    public List<PeriodType> getPeriodTypes(Query query) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("periodTypes").addParameter("fields", "frequencyOrder,name,isoDuration,isoFormat"), query, Objects.class).getPeriodTypes();
    }

    public SystemSettings getSystemSettings() {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("systemSettings"), Query.instance(), SystemSettings.class);
    }

    public DataValueSetResponse saveDataValueSet(DataValueSet dataValueSet, DataValueSetImportOptions options) {
        URI url = this.getDataValueSetImportQuery(this.config.getResolvedUriBuilder().appendPath("dataValueSets"), options);
        HttpPost request = this.getPostRequest(url, (HttpEntity)new StringEntity(this.toJsonString(dataValueSet), StandardCharsets.UTF_8));
        Dhis2AsyncRequest asyncRequest = new Dhis2AsyncRequest(this.config, this.httpClient, this.objectMapper);
        return asyncRequest.post(request, DataValueSetResponse.class);
    }

    public DataValueSetResponse saveDataValueSet(File file, DataValueSetImportOptions options) {
        URI url = this.getDataValueSetImportQuery(this.config.getResolvedUriBuilder().appendPath("dataValueSets"), options);
        HttpPost request = this.getPostRequest(url, (HttpEntity)new FileEntity(file, ContentType.APPLICATION_JSON));
        Dhis2AsyncRequest asyncRequest = new Dhis2AsyncRequest(this.config, this.httpClient, this.objectMapper);
        return asyncRequest.post(request, DataValueSetResponse.class);
    }

    public DataValueSetResponse saveDataValueSet(InputStream inputStream, DataValueSetImportOptions options) {
        URI url = this.getDataValueSetImportQuery(this.config.getResolvedUriBuilder().appendPath("dataValueSets"), options);
        HttpPost request = this.getPostRequest(url, (HttpEntity)new InputStreamEntity(inputStream, ContentType.APPLICATION_JSON));
        Dhis2AsyncRequest asyncRequest = new Dhis2AsyncRequest(this.config, this.httpClient, this.objectMapper);
        return asyncRequest.post(request, DataValueSetResponse.class);
    }

    public DataValueSet getDataValueSet(DataValueSetQuery query) {
        return this.getDataValueSetResponse(this.config.getResolvedUriBuilder().appendPath("dataValueSets.json"), query, DataValueSet.class);
    }

    public DataValueSet getAnalyticsDataValueSet(AnalyticsQuery query) {
        return this.getAnalyticsResponse(this.config.getResolvedUriBuilder().appendPath("analytics").appendPath("dataValueSet.json"), query, DataValueSet.class);
    }

    public void writeAnalyticsDataValueSet(AnalyticsQuery query, File file) {
        URI url = this.getAnalyticsQuery(this.config.getResolvedUriBuilder().appendPath("analytics").appendPath("dataValueSet.json"), query);
        CloseableHttpResponse response = this.getJsonHttpResponse(url);
        this.writeToFile(response, file);
    }

    public EventResponse saveEvents(Events events) {
        return this.saveObject(this.config.getResolvedUriBuilder().appendPath("tracker").setParameter("async", "false").setParameter("importStrategy", ImportStrategy.CREATE_AND_UPDATE.name()), (Object)events, EventResponse.class);
    }

    public Event getEvent(String id) {
        return this.getObject(this.config.getResolvedUriBuilder().appendPath("tracker").appendPath("events").appendPath(id), Query.instance(), Event.class);
    }

    public EventsResult getEvents(EventsQuery query) {
        return this.getEventsResponse(this.config.getResolvedUriBuilder().appendPath("tracker").appendPath("events"), query);
    }

    public EventResponse removeEvents(Events events) {
        return this.saveObject(this.config.getResolvedUriBuilder().appendPath("tracker").setParameter("async", "false").setParameter("importStrategy", ImportStrategy.DELETE.name()), (Object)events, EventResponse.class);
    }

    public EventResponse removeEvent(Event event) {
        Validate.notNull((Object)event.getId(), (String)"Event identifier must be specified", (Object[])new Object[0]);
        Events events = new Events(CollectionUtils.list(event));
        return this.saveObject(this.config.getResolvedUriBuilder().appendPath("tracker").setParameter("async", "false").setParameter("importStrategy", "DELETE"), (Object)events, EventResponse.class);
    }

    public List<JobNotification> getJobNotifications(JobCategory category, String id) {
        JobNotification[] response = this.getObject(this.config.getResolvedUriBuilder().appendPath("system").appendPath("tasks").appendPath(category.name()).appendPath(id), Query.instance(), JobNotification[].class);
        return new ArrayList<JobNotification>(Arrays.asList(response));
    }
}

