/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.model;

import java.util.Set;

public enum ValueType {
    TEXT,
    LONG_TEXT,
    MULTI_TEXT,
    LETTER,
    PHONE_NUMBER,
    EMAIL,
    BOOLEAN,
    TRUE_ONLY,
    DATE,
    DATETIME,
    TIME,
    NUMBER,
    UNIT_INTERVAL,
    PERCENTAGE,
    INTEGER,
    INTEGER_POSITIVE,
    INTEGER_NEGATIVE,
    INTEGER_ZERO_OR_POSITIVE,
    TRACKER_ASSOCIATE,
    USERNAME,
    COORDINATE,
    ORGANISATION_UNIT,
    REFERENCE,
    AGE,
    URL,
    FILE_RESOURCE,
    IMAGE,
    GEOJSON;

    public static final Set<ValueType> INTEGER_TYPES;
    public static final Set<ValueType> DECIMAL_TYPES;
    public static final Set<ValueType> BOOLEAN_TYPES;
    public static final Set<ValueType> TEXT_TYPES;
    public static final Set<ValueType> DATE_TYPES;
    public static final Set<ValueType> FILE_TYPES;
    public static final Set<ValueType> GEO_TYPES;
    public static final Set<ValueType> NUMERIC_TYPES;

    public boolean isInteger() {
        return INTEGER_TYPES.contains((Object)this);
    }

    public boolean isDecimal() {
        return DECIMAL_TYPES.contains((Object)this);
    }

    public boolean isBoolean() {
        return BOOLEAN_TYPES.contains((Object)this);
    }

    public boolean isText() {
        return TEXT_TYPES.contains((Object)this);
    }

    public boolean isDate() {
        return DATE_TYPES.contains((Object)this);
    }

    public boolean isFile() {
        return FILE_TYPES.contains((Object)this);
    }

    public boolean isGeo() {
        return GEO_TYPES.contains((Object)this);
    }

    public boolean isOrganisationUnit() {
        return ORGANISATION_UNIT == this;
    }

    public boolean isNumeric() {
        return NUMERIC_TYPES.contains((Object)this);
    }

    static {
        INTEGER_TYPES = Set.of(INTEGER, INTEGER_POSITIVE, INTEGER_NEGATIVE, INTEGER_ZERO_OR_POSITIVE);
        DECIMAL_TYPES = Set.of(NUMBER, UNIT_INTERVAL, PERCENTAGE);
        BOOLEAN_TYPES = Set.of(BOOLEAN, TRUE_ONLY);
        TEXT_TYPES = Set.of(TEXT, LONG_TEXT, LETTER, TIME, USERNAME, EMAIL, PHONE_NUMBER, URL);
        DATE_TYPES = Set.of(DATE, DATETIME, AGE);
        FILE_TYPES = Set.of(FILE_RESOURCE, IMAGE);
        GEO_TYPES = Set.of(COORDINATE);
        NUMERIC_TYPES = Set.of(INTEGER, INTEGER_POSITIVE, INTEGER_NEGATIVE, INTEGER_ZERO_OR_POSITIVE, NUMBER, UNIT_INTERVAL, PERCENTAGE);
    }
}

