/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.model.event;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.hisp.dhis.util.DateTimeUtils;

public class EventDataValue
implements Serializable {
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    @JsonProperty
    private String dataElement;
    @JsonProperty
    private String value;
    @JsonProperty
    private Boolean providedElsewhere;
    @JsonProperty
    private Date createdAt;
    @JsonProperty
    private Date updatedAt;
    @JsonProperty
    private String storedBy;

    public EventDataValue(String dataElement, String value) {
        this.dataElement = dataElement;
        this.value = value;
    }

    @JsonIgnore
    public boolean hasValue() {
        return StringUtils.isNotEmpty((CharSequence)this.value);
    }

    @JsonIgnore
    public boolean isBoolean() {
        return VALUE_TRUE.equalsIgnoreCase(this.value) || VALUE_FALSE.equalsIgnoreCase(this.value);
    }

    @JsonIgnore
    public Boolean getBooleanValue() {
        return this.isBoolean() ? Boolean.valueOf(this.value) : null;
    }

    @JsonIgnore
    public boolean isDouble() {
        return NumberUtils.isCreatable((String)this.value);
    }

    @JsonIgnore
    public Double getDoubleValue() {
        return this.isDouble() ? Double.valueOf(this.value) : null;
    }

    @JsonIgnore
    public boolean isInteger() {
        return StringUtils.isNumeric((CharSequence)this.value);
    }

    @JsonIgnore
    public Integer getIntegerValue() {
        return this.isInteger() ? Integer.valueOf(this.value) : null;
    }

    @JsonIgnore
    public boolean isLocalDate() {
        return DateTimeUtils.isValidLocalDate(this.value);
    }

    @JsonIgnore
    public LocalDate getLocalDateValue() {
        if (DateTimeUtils.isValidLocalDate(this.value)) {
            return DateTimeUtils.getLocalDate(this.value);
        }
        return DateTimeUtils.isValidLocalDateTime(this.value) ? DateTimeUtils.getLocalDateTimeAsDate(this.value) : null;
    }

    @JsonIgnore
    public boolean isLocalDateTime() {
        return DateTimeUtils.isValidLocalDateTime(this.value);
    }

    @JsonIgnore
    public LocalDateTime getLocalDateTimeValue() {
        return DateTimeUtils.isValidLocalDateTime(this.value) ? DateTimeUtils.getLocalDateTime(this.value) : null;
    }

    public String getDataElement() {
        return this.dataElement;
    }

    public String getValue() {
        return this.value;
    }

    public Boolean getProvidedElsewhere() {
        return this.providedElsewhere;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getStoredBy() {
        return this.storedBy;
    }

    @JsonProperty
    public void setDataElement(String dataElement) {
        this.dataElement = dataElement;
    }

    @JsonProperty
    public void setValue(String value) {
        this.value = value;
    }

    @JsonProperty
    public void setProvidedElsewhere(Boolean providedElsewhere) {
        this.providedElsewhere = providedElsewhere;
    }

    @JsonProperty
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public EventDataValue() {
    }

    public String toString() {
        return "EventDataValue(dataElement=" + this.getDataElement() + ", value=" + this.getValue() + ")";
    }
}

