/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketAdapter;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.Handshakedata;
import org.java_websocket.server.CustomSSLWebSocketServerFactory;
import org.java_websocket.server.DefaultWebSocketServerFactory;
import org.junit.Assert;
import org.junit.Test;

public class CustomSSLWebSocketServerFactoryTest {
    final String[] emptyArray = new String[0];

    @Test
    public void testConstructor() throws NoSuchAlgorithmException {
        try {
            new CustomSSLWebSocketServerFactory(null, null, null);
            Assert.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new CustomSSLWebSocketServerFactory(null, null, null, null);
            Assert.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new CustomSSLWebSocketServerFactory(SSLContext.getDefault(), null, null, null);
            Assert.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new CustomSSLWebSocketServerFactory(SSLContext.getDefault(), null, null);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"IllegalArgumentException should not be thrown");
        }
        try {
            new CustomSSLWebSocketServerFactory(SSLContext.getDefault(), Executors.newCachedThreadPool(), null, null);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"IllegalArgumentException should not be thrown");
        }
        try {
            new CustomSSLWebSocketServerFactory(SSLContext.getDefault(), Executors.newCachedThreadPool(), this.emptyArray, null);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"IllegalArgumentException should not be thrown");
        }
        try {
            new CustomSSLWebSocketServerFactory(SSLContext.getDefault(), Executors.newCachedThreadPool(), null, this.emptyArray);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"IllegalArgumentException should not be thrown");
        }
        try {
            new CustomSSLWebSocketServerFactory(SSLContext.getDefault(), Executors.newCachedThreadPool(), this.emptyArray, this.emptyArray);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"IllegalArgumentException should not be thrown");
        }
    }

    @Test
    public void testCreateWebSocket() throws NoSuchAlgorithmException {
        CustomSSLWebSocketServerFactory webSocketServerFactory = new CustomSSLWebSocketServerFactory(SSLContext.getDefault(), null, null);
        CustomWebSocketAdapter webSocketAdapter = new CustomWebSocketAdapter();
        WebSocketImpl webSocketImpl = webSocketServerFactory.createWebSocket((WebSocketAdapter)webSocketAdapter, (Draft)new Draft_6455());
        Assert.assertNotNull((String)"webSocketImpl != null", (Object)webSocketImpl);
        webSocketImpl = webSocketServerFactory.createWebSocket((WebSocketAdapter)webSocketAdapter, Collections.singletonList(new Draft_6455()));
        Assert.assertNotNull((String)"webSocketImpl != null", (Object)webSocketImpl);
    }

    @Test
    public void testWrapChannel() throws IOException, NoSuchAlgorithmException {
        ByteChannel byteChannel;
        CustomSSLWebSocketServerFactory webSocketServerFactory = new CustomSSLWebSocketServerFactory(SSLContext.getDefault(), null, null);
        SocketChannel channel = SocketChannel.open();
        try {
            byteChannel = webSocketServerFactory.wrapChannel(channel, null);
        }
        catch (NotYetConnectedException notYetConnectedException) {
            // empty catch block
        }
        channel.close();
        webSocketServerFactory = new CustomSSLWebSocketServerFactory(SSLContext.getDefault(), new String[]{"TLSv1.2"}, new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA"});
        channel = SocketChannel.open();
        try {
            byteChannel = webSocketServerFactory.wrapChannel(channel, null);
        }
        catch (NotYetConnectedException notYetConnectedException) {
            // empty catch block
        }
        channel.close();
    }

    @Test
    public void testClose() {
        DefaultWebSocketServerFactory webSocketServerFactory = new DefaultWebSocketServerFactory();
        webSocketServerFactory.close();
    }

    private static class CustomWebSocketAdapter
    extends WebSocketAdapter {
        private CustomWebSocketAdapter() {
        }

        public void onWebsocketMessage(WebSocket conn, String message) {
        }

        public void onWebsocketMessage(WebSocket conn, ByteBuffer blob) {
        }

        public void onWebsocketOpen(WebSocket conn, Handshakedata d) {
        }

        public void onWebsocketClose(WebSocket ws, int code, String reason, boolean remote) {
        }

        public void onWebsocketClosing(WebSocket ws, int code, String reason, boolean remote) {
        }

        public void onWebsocketCloseInitiated(WebSocket ws, int code, String reason) {
        }

        public void onWebsocketError(WebSocket conn, Exception ex) {
        }

        public void onWriteDemand(WebSocket conn) {
        }

        public InetSocketAddress getLocalSocketAddress(WebSocket conn) {
            return null;
        }

        public InetSocketAddress getRemoteSocketAddress(WebSocket conn) {
            return null;
        }
    }
}

