/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.util;

import java.nio.ByteBuffer;
import org.java_websocket.util.ByteBufferUtils;
import org.junit.Assert;
import org.junit.Test;

public class ByteBufferUtilsTest {
    private static byte[] smallArray = new byte[]{0, -1, -2, -3, -4};
    private static byte[] bigArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};

    @Test
    public void testEmptyByteBufferCapacity() {
        ByteBuffer byteBuffer = ByteBufferUtils.getEmptyByteBuffer();
        Assert.assertEquals((String)"capacity must be 0", (long)0L, (long)byteBuffer.capacity());
    }

    @Test
    public void testEmptyByteBufferNewObject() {
        ByteBuffer byteBuffer1;
        ByteBuffer byteBuffer0 = ByteBufferUtils.getEmptyByteBuffer();
        Assert.assertTrue((String)"Allocated new object", (byteBuffer0 != (byteBuffer1 = ByteBufferUtils.getEmptyByteBuffer()) ? 1 : 0) != 0);
    }

    @Test
    public void testTransferByteBufferSmallToEmpty() {
        ByteBuffer small = ByteBuffer.wrap(smallArray);
        ByteBuffer empty = ByteBufferUtils.getEmptyByteBuffer();
        ByteBufferUtils.transferByteBuffer((ByteBuffer)small, (ByteBuffer)empty);
        Assert.assertArrayEquals((String)"Small bytebuffer should not change", (byte[])smallArray, (byte[])small.array());
        Assert.assertEquals((String)"Capacity of the empty bytebuffer should still be 0", (long)0L, (long)empty.capacity());
    }

    @Test
    public void testTransferByteBufferSmallToBig() {
        ByteBuffer small = ByteBuffer.wrap(smallArray);
        ByteBuffer big = ByteBuffer.wrap(bigArray);
        ByteBufferUtils.transferByteBuffer((ByteBuffer)small, (ByteBuffer)big);
        Assert.assertArrayEquals((String)"Small bytebuffer should not change", (byte[])smallArray, (byte[])small.array());
        Assert.assertEquals((String)"Big bytebuffer not same to source 0", (long)smallArray[0], (long)big.get(0));
        Assert.assertEquals((String)"Big bytebuffer not same to source 1", (long)smallArray[1], (long)big.get(1));
        Assert.assertEquals((String)"Big bytebuffer not same to source 2", (long)smallArray[2], (long)big.get(2));
        Assert.assertEquals((String)"Big bytebuffer not same to source 3", (long)smallArray[3], (long)big.get(3));
        Assert.assertEquals((String)"Big bytebuffer not same to source 4", (long)smallArray[4], (long)big.get(4));
        Assert.assertEquals((String)"Big bytebuffer not same to source 5", (long)bigArray[5], (long)big.get(5));
        Assert.assertEquals((String)"Big bytebuffer not same to source 6", (long)bigArray[6], (long)big.get(6));
        Assert.assertEquals((String)"Big bytebuffer not same to source 7", (long)bigArray[7], (long)big.get(7));
        Assert.assertEquals((String)"Big bytebuffer not same to source 8", (long)bigArray[8], (long)big.get(8));
    }

    @Test
    public void testTransferByteBufferBigToSmall() {
        ByteBuffer small = ByteBuffer.wrap(smallArray);
        ByteBuffer big = ByteBuffer.wrap(bigArray);
        ByteBufferUtils.transferByteBuffer((ByteBuffer)big, (ByteBuffer)small);
        Assert.assertArrayEquals((String)"Big bytebuffer should not change", (byte[])bigArray, (byte[])big.array());
        Assert.assertEquals((String)"Small bytebuffer not same to source 0", (long)bigArray[0], (long)small.get(0));
        Assert.assertEquals((String)"Small bytebuffer not same to source 1", (long)bigArray[1], (long)small.get(1));
        Assert.assertEquals((String)"Small bytebuffer not same to source 2", (long)bigArray[2], (long)small.get(2));
        Assert.assertEquals((String)"Small bytebuffer not same to source 3", (long)bigArray[3], (long)small.get(3));
        Assert.assertEquals((String)"Small bytebuffer not same to source 4", (long)bigArray[4], (long)small.get(4));
    }

    @Test
    public void testTransferByteBufferCheckNullDest() {
        ByteBuffer source = ByteBuffer.wrap(smallArray);
        try {
            ByteBufferUtils.transferByteBuffer((ByteBuffer)source, null);
            Assert.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTransferByteBufferCheckNullSource() {
        ByteBuffer dest = ByteBuffer.wrap(smallArray);
        try {
            ByteBufferUtils.transferByteBuffer(null, (ByteBuffer)dest);
            Assert.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTransferByteBufferCheckNullBoth() {
        try {
            ByteBufferUtils.transferByteBuffer(null, null);
            Assert.fail((String)"IllegalArgumentException should be thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

