/*
 * Decompiled with CFR 0.152.
 */
package org.kgrid.adapter.javascript;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashMap;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.kgrid.adapter.api.Adapter;
import org.kgrid.adapter.api.AdapterException;
import org.kgrid.adapter.api.AdapterSupport;
import org.kgrid.adapter.api.Executor;
import org.kgrid.shelf.repository.CompoundDigitalObjectStore;

public class JavascriptAdapter
implements Adapter,
AdapterSupport {
    ScriptEngine engine;
    CompoundDigitalObjectStore cdoStore;

    public String getType() {
        return "javascript".toUpperCase();
    }

    public void initialize() {
        this.engine = new ScriptEngineManager().getEngineByName("JavaScript");
    }

    public Executor activate(Path resourcePath, final String endpointName) {
        SimpleScriptContext context = new SimpleScriptContext();
        context.setBindings(this.engine.createBindings(), 100);
        Path scriptPath = resourcePath.resolve(endpointName + ".js");
        byte[] binary = this.cdoStore.getBinary(scriptPath);
        if (binary == null) {
            throw new AdapterException("Can't find endpoint " + endpointName + " in path " + scriptPath, null);
        }
        try {
            CompiledScript script = ((Compilable)((Object)this.engine)).compile(new String(binary, Charset.defaultCharset()));
            script.eval(context);
        }
        catch (ScriptException e) {
            throw new AdapterException("unable to compile script " + scriptPath + " : " + e.getMessage(), (Throwable)e);
        }
        final ScriptObjectMirror mirror = (ScriptObjectMirror)context.getBindings(100);
        return new Executor(){
            String endpoint;
            {
                this.endpoint = endpointName;
            }

            public Object execute(Object input) {
                Object output = mirror.callMember(this.endpoint, new Object[]{input});
                HashMap errors = new HashMap();
                return output;
            }
        };
    }

    public String status() {
        if (this.engine == null) {
            return "DOWN";
        }
        if (this.cdoStore == null) {
            return "DOWN";
        }
        return "UP";
    }

    public void setCdoStore(CompoundDigitalObjectStore cdoStore) {
        this.cdoStore = cdoStore;
    }
}

