/*
 * Decompiled with CFR 0.152.
 */
package org.kgrid.adapter.javascript;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.kgrid.adapter.api.ActivationContext;
import org.kgrid.adapter.api.Adapter;
import org.kgrid.adapter.api.AdapterException;
import org.kgrid.adapter.api.Executor;
import org.kgrid.shelf.ShelfResourceNotFound;
import org.kgrid.shelf.repository.CompoundDigitalObjectStore;

public class JavascriptAdapter
implements Adapter {
    Map<String, Object> endpoints;
    ScriptEngine engine;
    CompoundDigitalObjectStore cdoStore;
    private ActivationContext activationContext;

    public String getType() {
        return "javascript".toUpperCase();
    }

    public void initialize(ActivationContext context) {
        this.activationContext = context;
        this.engine = new ScriptEngineManager().getEngineByName("JavaScript");
        this.engine.getBindings(200).put("context", (Object)this.activationContext);
    }

    public Executor activate(final Path artifact, final String entry) {
        final CompiledScript script = this.getCompiledScript(artifact.toString(), entry);
        final SimpleScriptContext context = new SimpleScriptContext();
        context.setBindings(this.engine.createBindings(), 100);
        final Bindings bindings = context.getBindings(100);
        return new Executor(){

            public synchronized Object execute(Object input) {
                try {
                    script.eval(context);
                }
                catch (ScriptException ex) {
                    throw new AdapterException("unable to reset script context " + artifact.toString() + " : " + ex.getMessage(), (Throwable)ex);
                }
                Object output = ((ScriptObjectMirror)bindings).callMember(entry, new Object[]{input});
                return output;
            }
        };
    }

    private CompiledScript getCompiledScript(String artifact, String entry) {
        CompiledScript script;
        byte[] binary;
        try {
            binary = this.activationContext.getBinary(artifact);
        }
        catch (ShelfResourceNotFound e) {
            throw new AdapterException(e.getMessage(), (Throwable)e);
        }
        if (binary == null) {
            throw new AdapterException(String.format("Can't find endpoint %s in path %s", entry, artifact));
        }
        try {
            script = ((Compilable)((Object)this.engine)).compile(new String(binary, Charset.defaultCharset()));
        }
        catch (ScriptException e) {
            throw new AdapterException("unable to compile script " + artifact + " : " + e.getMessage(), (Throwable)e);
        }
        return script;
    }

    public String status() {
        if (this.engine == null) {
            return "DOWN";
        }
        if (this.activationContext == null) {
            return "DOWN";
        }
        return "UP";
    }
}

