/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.util.ArrayList;
import org.mapstruct.ap.shaded.freemarker.core.BooleanLiteral;
import org.mapstruct.ap.shaded.freemarker.core.BuiltIn;
import org.mapstruct.ap.shaded.freemarker.core.Dot;
import org.mapstruct.ap.shaded.freemarker.core.DynamicKeyName;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.ExistsExpression;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.HashLiteral;
import org.mapstruct.ap.shaded.freemarker.core.Identifier;
import org.mapstruct.ap.shaded.freemarker.core.ListLiteral;
import org.mapstruct.ap.shaded.freemarker.core.Macro;
import org.mapstruct.ap.shaded.freemarker.core.MethodCall;
import org.mapstruct.ap.shaded.freemarker.core.NumberLiteral;
import org.mapstruct.ap.shaded.freemarker.core.ParentheticalExpression;
import org.mapstruct.ap.shaded.freemarker.core.StringLiteral;
import org.mapstruct.ap.shaded.freemarker.core.TemplateDateFormat;
import org.mapstruct.ap.shaded.freemarker.core.TemplateNumberFormat;
import org.mapstruct.ap.shaded.freemarker.core.TemplateValueFormatException;
import org.mapstruct.ap.shaded.freemarker.core.UnknownDateTypeFormattingUnsupportedException;
import org.mapstruct.ap.shaded.freemarker.core._DelayedAOrAn;
import org.mapstruct.ap.shaded.freemarker.core._DelayedFTLTypeDescription;
import org.mapstruct.ap.shaded.freemarker.core._DelayedJQuote;
import org.mapstruct.ap.shaded.freemarker.core._DelayedShortClassName;
import org.mapstruct.ap.shaded.freemarker.core._ErrorDescriptionBuilder;
import org.mapstruct.ap.shaded.freemarker.core._MiscTemplateException;
import org.mapstruct.ap.shaded.freemarker.core._TemplateModelException;
import org.mapstruct.ap.shaded.freemarker.template.Template;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateHashModelEx;
import org.mapstruct.ap.shaded.freemarker.template.TemplateHashModelEx2;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModelException;
import org.mapstruct.ap.shaded.freemarker.template.utility.StringUtil;

public class _MessageUtil {
    static final String UNKNOWN_DATE_TO_STRING_ERROR_MESSAGE = "Can't convert the date-like value to string because it isn't known if it's a date (no time part), time or date-time value.";
    static final String UNKNOWN_DATE_PARSING_ERROR_MESSAGE = "Can't parse the string to date-like value because it isn't known if it's desired result should be a date (no time part), a time, or a date-time value.";
    static final String UNKNOWN_DATE_TYPE_ERROR_TIP = "Use ?date, ?time, or ?datetime to tell FreeMarker the exact type.";
    static final Object[] UNKNOWN_DATE_TO_STRING_TIPS = new Object[]{"Use ?date, ?time, or ?datetime to tell FreeMarker the exact type.", "If you need a particular format only once, use ?string(pattern), like ?string('dd.MM.yyyy HH:mm:ss'), to specify which fields to display. "};
    static final String EMBEDDED_MESSAGE_BEGIN = "---begin-message---\n";
    static final String EMBEDDED_MESSAGE_END = "\n---end-message---";

    private _MessageUtil() {
    }

    static String formatLocationForSimpleParsingError(Template template, int line, int column) {
        return _MessageUtil.formatLocation("in", template, line, column);
    }

    static String formatLocationForSimpleParsingError(String templateSourceName, int line, int column) {
        return _MessageUtil.formatLocation("in", templateSourceName, line, column);
    }

    static String formatLocationForDependentParsingError(Template template, int line, int column) {
        return _MessageUtil.formatLocation("on", template, line, column);
    }

    static String formatLocationForDependentParsingError(String templateSourceName, int line, int column) {
        return _MessageUtil.formatLocation("on", templateSourceName, line, column);
    }

    static String formatLocationForEvaluationError(Template template, int line, int column) {
        return _MessageUtil.formatLocation("at", template, line, column);
    }

    static String formatLocationForEvaluationError(Macro macro, int line, int column) {
        Template t = macro.getTemplate();
        return _MessageUtil.formatLocation("at", t != null ? t.getSourceName() : null, macro.getName(), macro.isFunction(), line, column);
    }

    static String formatLocationForEvaluationError(String templateSourceName, int line, int column) {
        return _MessageUtil.formatLocation("at", templateSourceName, line, column);
    }

    private static String formatLocation(String preposition, Template template, int line, int column) {
        return _MessageUtil.formatLocation(preposition, template != null ? template.getSourceName() : null, line, column);
    }

    private static String formatLocation(String preposition, String templateSourceName, int line, int column) {
        return _MessageUtil.formatLocation(preposition, templateSourceName, null, false, line, column);
    }

    private static String formatLocation(String preposition, String templateSourceName, String macroOrFuncName, boolean isFunction, int line, int column) {
        String templateDesc;
        if (line < 0) {
            templateDesc = "?eval-ed string";
            macroOrFuncName = null;
        } else {
            templateDesc = templateSourceName != null ? "template " + StringUtil.jQuoteNoXSS(templateSourceName) : "nameless template";
        }
        return "in " + templateDesc + (macroOrFuncName != null ? " in " + (isFunction ? "function " : "macro ") + StringUtil.jQuote(macroOrFuncName) : "") + " " + preposition + " " + _MessageUtil.formatPosition(line, column);
    }

    static String formatPosition(int line, int column) {
        return "line " + (line >= 0 ? line : line - -1000000001) + ", column " + column;
    }

    public static String shorten(String s, int maxLength) {
        if (maxLength < 5) {
            maxLength = 5;
        }
        boolean isTruncated = false;
        int brIdx = s.indexOf(10);
        if (brIdx != -1) {
            s = s.substring(0, brIdx);
            isTruncated = true;
        }
        if ((brIdx = s.indexOf(13)) != -1) {
            s = s.substring(0, brIdx);
            isTruncated = true;
        }
        if (s.length() > maxLength) {
            s = s.substring(0, maxLength - 3);
            isTruncated = true;
        }
        if (!isTruncated) {
            return s;
        }
        if (s.endsWith(".")) {
            if (s.endsWith("..")) {
                if (s.endsWith("...")) {
                    return s;
                }
                return s + ".";
            }
            return s + "..";
        }
        return s + "...";
    }

    public static StringBuilder appendExpressionAsUntearable(StringBuilder sb, Expression argExp) {
        boolean needParen;
        boolean bl = needParen = !(argExp instanceof NumberLiteral) && !(argExp instanceof StringLiteral) && !(argExp instanceof BooleanLiteral) && !(argExp instanceof ListLiteral) && !(argExp instanceof HashLiteral) && !(argExp instanceof Identifier) && !(argExp instanceof Dot) && !(argExp instanceof DynamicKeyName) && !(argExp instanceof MethodCall) && !(argExp instanceof BuiltIn) && !(argExp instanceof ExistsExpression) && !(argExp instanceof ParentheticalExpression);
        if (needParen) {
            sb.append('(');
        }
        sb.append(argExp.getCanonicalForm());
        if (needParen) {
            sb.append(')');
        }
        return sb;
    }

    public static TemplateModelException newArgCntError(String methodName, int argCnt, int expectedCnt) {
        return _MessageUtil.newArgCntError(methodName, argCnt, expectedCnt, expectedCnt);
    }

    public static TemplateModelException newArgCntError(String methodName, int argCnt, int minCnt, int maxCnt) {
        ArrayList<Object> desc = new ArrayList<Object>(20);
        desc.add(methodName);
        desc.add("(");
        if (maxCnt != 0) {
            desc.add("...");
        }
        desc.add(") expects ");
        if (minCnt == maxCnt) {
            if (maxCnt == 0) {
                desc.add("no");
            } else {
                desc.add(maxCnt);
            }
        } else if (maxCnt - minCnt == 1) {
            desc.add(minCnt);
            desc.add(" or ");
            desc.add(maxCnt);
        } else {
            desc.add(minCnt);
            if (maxCnt != Integer.MAX_VALUE) {
                desc.add(" to ");
                desc.add(maxCnt);
            } else {
                desc.add(" or more (unlimited)");
            }
        }
        desc.add(" argument");
        if (maxCnt > 1) {
            desc.add("s");
        }
        desc.add(" but has received ");
        if (argCnt == 0) {
            desc.add("none");
        } else {
            desc.add(argCnt);
        }
        desc.add(".");
        return new _TemplateModelException(desc.toArray());
    }

    public static TemplateModelException newMethodArgMustBeStringException(String methodName, int argIdx, TemplateModel arg) {
        return _MessageUtil.newMethodArgUnexpectedTypeException(methodName, argIdx, "string", arg);
    }

    public static TemplateModelException newMethodArgMustBeNumberException(String methodName, int argIdx, TemplateModel arg) {
        return _MessageUtil.newMethodArgUnexpectedTypeException(methodName, argIdx, "number", arg);
    }

    public static TemplateModelException newMethodArgMustBeBooleanException(String methodName, int argIdx, TemplateModel arg) {
        return _MessageUtil.newMethodArgUnexpectedTypeException(methodName, argIdx, "boolean", arg);
    }

    public static TemplateModelException newMethodArgMustBeExtendedHashException(String methodName, int argIdx, TemplateModel arg) {
        return _MessageUtil.newMethodArgUnexpectedTypeException(methodName, argIdx, "extended hash", arg);
    }

    public static TemplateModelException newMethodArgMustBeExtendedHashOrSequnceException(String methodName, int argIdx, TemplateModel arg) {
        return _MessageUtil.newMethodArgUnexpectedTypeException(methodName, argIdx, "extended hash or sequence", arg);
    }

    public static TemplateModelException newMethodArgMustBeSequenceException(String methodName, int argIdx, TemplateModel arg) {
        return _MessageUtil.newMethodArgUnexpectedTypeException(methodName, argIdx, "sequence", arg);
    }

    public static TemplateModelException newMethodArgMustBeSequenceOrCollectionException(String methodName, int argIdx, TemplateModel arg) {
        return _MessageUtil.newMethodArgUnexpectedTypeException(methodName, argIdx, "sequence or collection", arg);
    }

    public static TemplateModelException newMethodArgMustBeStringOrMarkupOutputException(String methodName, int argIdx, TemplateModel arg) {
        return _MessageUtil.newMethodArgUnexpectedTypeException(methodName, argIdx, "string or markup output", arg);
    }

    public static TemplateModelException newMethodArgUnexpectedTypeException(String methodName, int argIdx, String expectedType, TemplateModel arg) {
        return new _TemplateModelException(methodName, "(...) expects ", new _DelayedAOrAn(expectedType), " as argument #", argIdx + 1, ", but received ", new _DelayedAOrAn(new _DelayedFTLTypeDescription(arg)), ".");
    }

    public static TemplateModelException newMethodArgInvalidValueException(String methodName, int argIdx, Object ... details) {
        return new _TemplateModelException(methodName, "(...) argument #", argIdx + 1, " had invalid value: ", details);
    }

    public static TemplateModelException newMethodArgsInvalidValueException(String methodName, Object ... details) {
        return new _TemplateModelException(methodName, "(...) arguments have invalid value: ", details);
    }

    public static TemplateException newInstantiatingClassNotAllowedException(String className, Environment env) {
        return new _MiscTemplateException(env, "Instantiating ", className, " is not allowed in the template for security reasons.");
    }

    public static _TemplateModelException newCantFormatUnknownTypeDateException(Expression dateSourceExpr, UnknownDateTypeFormattingUnsupportedException cause) {
        return new _TemplateModelException((Throwable)cause, null, new _ErrorDescriptionBuilder(UNKNOWN_DATE_TO_STRING_ERROR_MESSAGE).blame(dateSourceExpr).tips(UNKNOWN_DATE_TO_STRING_TIPS));
    }

    public static TemplateException newCantFormatDateException(TemplateDateFormat format, Expression dataSrcExp, TemplateValueFormatException e, boolean useTempModelExc) {
        _ErrorDescriptionBuilder desc = new _ErrorDescriptionBuilder("Failed to format date/time/datetime with format ", new _DelayedJQuote(format.getDescription()), ": ", e.getMessage()).blame(dataSrcExp);
        return useTempModelExc ? new _TemplateModelException((Throwable)e, null, desc) : new _MiscTemplateException((Throwable)e, null, desc);
    }

    public static TemplateException newCantFormatNumberException(TemplateNumberFormat format, Expression dataSrcExp, TemplateValueFormatException e, boolean useTempModelExc) {
        _ErrorDescriptionBuilder desc = new _ErrorDescriptionBuilder("Failed to format number with format ", new _DelayedJQuote(format.getDescription()), ": ", e.getMessage()).blame(dataSrcExp);
        return useTempModelExc ? new _TemplateModelException((Throwable)e, null, desc) : new _MiscTemplateException((Throwable)e, null, desc);
    }

    public static TemplateModelException newKeyValuePairListingNonStringKeyExceptionMessage(TemplateModel key, TemplateHashModelEx listedHashEx) {
        return new _TemplateModelException(new _ErrorDescriptionBuilder("When listing key-value pairs of traditional hash implementations, all keys must be strings, but one of them was ", new _DelayedAOrAn(new _DelayedFTLTypeDescription(key)), ".").tip("The listed value's TemplateModel class was ", new _DelayedShortClassName(listedHashEx.getClass()), ", which doesn't implement ", new _DelayedShortClassName(TemplateHashModelEx2.class), ", which leads to this restriction."));
    }

    public static TemplateException newLazilyGeneratedCollectionMustBeSequenceException(Expression blamed) {
        return new _MiscTemplateException(blamed, "The result is a listable value with lazy transformation(s) applied on it, but it's not an FTL sequence (it's not a List-like value, but an Iterator-like value). The place doesn't support such values due to technical limitations. So either pass it to a construct that supports such values (like ", "<#list transformedListable as x>", "), or, if you know that you don't have too many elements, use transformedListable?sequence to allow it to be treated as an FTL sequence.");
    }

    public static String getAOrAn(String s) {
        char sc;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "";
        }
        char fc = Character.toLowerCase(s.charAt(0));
        if (fc == 'a' || fc == 'e' || fc == 'i') {
            return "an";
        }
        if (fc == 'h') {
            String ls = s.toLowerCase();
            if (ls.startsWith("has") || ls.startsWith("hi")) {
                return "a";
            }
            if (ls.startsWith("ht")) {
                return "an";
            }
            return "a(n)";
        }
        if (fc == 'u' || fc == 'o') {
            return "a(n)";
        }
        char c = sc = s.length() > 1 ? s.charAt(1) : (char)'\u0000';
        if (fc == 'x' && sc != 'a' && sc != 'e' && sc != 'i' && sc != 'a' && sc != 'o' && sc != 'u') {
            return "an";
        }
        return "a";
    }
}

