/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.ConnectionReadTimeoutHandler;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.async.pool.ExtendedChannelPool;
import org.neo4j.driver.internal.handlers.ChannelReleasingResetResponseHandler;
import org.neo4j.driver.internal.handlers.ResetResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.request.ResetMessage;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.metrics.MetricsListener;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.ServerVersion;

public class NetworkConnection
implements Connection {
    private final Logger log;
    private final Channel channel;
    private final InboundMessageDispatcher messageDispatcher;
    private final String serverAgent;
    private final BoltServerAddress serverAddress;
    private final ServerVersion serverVersion;
    private final BoltProtocol protocol;
    private final ExtendedChannelPool channelPool;
    private final CompletableFuture<Void> releaseFuture;
    private final Clock clock;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.OPEN);
    private final MetricsListener metricsListener;
    private final ListenerEvent inUseEvent;
    private final Long connectionReadTimeout;
    private ChannelHandler connectionReadTimeoutHandler;

    public NetworkConnection(Channel channel, ExtendedChannelPool channelPool, Clock clock, MetricsListener metricsListener, Logging logging) {
        this.log = logging.getLog(this.getClass());
        this.channel = channel;
        this.messageDispatcher = ChannelAttributes.messageDispatcher(channel);
        this.serverAgent = ChannelAttributes.serverAgent(channel);
        this.serverAddress = ChannelAttributes.serverAddress(channel);
        this.serverVersion = ChannelAttributes.serverVersion(channel);
        this.protocol = BoltProtocol.forChannel(channel);
        this.channelPool = channelPool;
        this.releaseFuture = new CompletableFuture();
        this.clock = clock;
        this.metricsListener = metricsListener;
        this.inUseEvent = metricsListener.createListenerEvent();
        this.connectionReadTimeout = ChannelAttributes.connectionReadTimeout(channel).orElse(null);
        metricsListener.afterConnectionCreated(ChannelAttributes.poolId(this.channel), this.inUseEvent);
    }

    @Override
    public boolean isOpen() {
        return this.status.get() == Status.OPEN;
    }

    @Override
    public void enableAutoRead() {
        if (this.isOpen()) {
            this.setAutoRead(true);
        }
    }

    @Override
    public void disableAutoRead() {
        if (this.isOpen()) {
            this.setAutoRead(false);
        }
    }

    @Override
    public void flush() {
        if (this.verifyOpen(null, null)) {
            this.flushInEventLoop();
        }
    }

    @Override
    public void write(Message message, ResponseHandler handler) {
        if (this.verifyOpen(handler, null)) {
            this.writeMessageInEventLoop(message, handler, false);
        }
    }

    @Override
    public void write(Message message1, ResponseHandler handler1, Message message2, ResponseHandler handler2) {
        if (this.verifyOpen(handler1, handler2)) {
            this.writeMessagesInEventLoop(message1, handler1, message2, handler2, false);
        }
    }

    @Override
    public void writeAndFlush(Message message, ResponseHandler handler) {
        if (this.verifyOpen(handler, null)) {
            this.writeMessageInEventLoop(message, handler, true);
        }
    }

    @Override
    public void writeAndFlush(Message message1, ResponseHandler handler1, Message message2, ResponseHandler handler2) {
        if (this.verifyOpen(handler1, handler2)) {
            this.writeMessagesInEventLoop(message1, handler1, message2, handler2, true);
        }
    }

    @Override
    public CompletionStage<Void> reset() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ResetResponseHandler handler = new ResetResponseHandler(this.messageDispatcher, result);
        this.writeResetMessageIfNeeded(handler, true);
        return result;
    }

    @Override
    public CompletionStage<Void> release() {
        if (this.status.compareAndSet(Status.OPEN, Status.RELEASED)) {
            ChannelReleasingResetResponseHandler handler = new ChannelReleasingResetResponseHandler(this.channel, this.channelPool, this.messageDispatcher, this.clock, this.releaseFuture);
            this.writeResetMessageIfNeeded(handler, false);
            this.metricsListener.afterConnectionReleased(ChannelAttributes.poolId(this.channel), this.inUseEvent);
        }
        return this.releaseFuture;
    }

    @Override
    public void terminateAndRelease(String reason) {
        if (this.status.compareAndSet(Status.OPEN, Status.TERMINATED)) {
            ChannelAttributes.setTerminationReason(this.channel, reason);
            Futures.asCompletionStage(this.channel.close()).exceptionally(throwable -> null).thenCompose(ignored -> this.channelPool.release(this.channel)).whenComplete((ignored, throwable) -> {
                this.releaseFuture.complete(null);
                this.metricsListener.afterConnectionReleased(ChannelAttributes.poolId(this.channel), this.inUseEvent);
            });
        }
    }

    @Override
    public String serverAgent() {
        return this.serverAgent;
    }

    @Override
    public BoltServerAddress serverAddress() {
        return this.serverAddress;
    }

    @Override
    public ServerVersion serverVersion() {
        return this.serverVersion;
    }

    @Override
    public BoltProtocol protocol() {
        return this.protocol;
    }

    private void writeResetMessageIfNeeded(ResponseHandler resetHandler, boolean isSessionReset) {
        this.channel.eventLoop().execute(() -> {
            if (isSessionReset && !this.isOpen()) {
                resetHandler.onSuccess(Collections.emptyMap());
            } else {
                this.setAutoRead(true);
                this.messageDispatcher.enqueue(resetHandler);
                this.channel.writeAndFlush((Object)ResetMessage.RESET).addListener(future -> this.registerConnectionReadTimeout(this.channel));
            }
        });
    }

    private void flushInEventLoop() {
        this.channel.eventLoop().execute(() -> {
            this.channel.flush();
            this.registerConnectionReadTimeout(this.channel);
        });
    }

    private void writeMessageInEventLoop(Message message, ResponseHandler handler, boolean flush) {
        this.channel.eventLoop().execute(() -> {
            this.messageDispatcher.enqueue(handler);
            if (flush) {
                this.channel.writeAndFlush((Object)message).addListener(future -> this.registerConnectionReadTimeout(this.channel));
            } else {
                this.channel.write((Object)message, this.channel.voidPromise());
            }
        });
    }

    private void writeMessagesInEventLoop(Message message1, ResponseHandler handler1, Message message2, ResponseHandler handler2, boolean flush) {
        this.channel.eventLoop().execute(() -> {
            this.messageDispatcher.enqueue(handler1);
            this.messageDispatcher.enqueue(handler2);
            this.channel.write((Object)message1, this.channel.voidPromise());
            if (flush) {
                this.channel.writeAndFlush((Object)message2).addListener(future -> this.registerConnectionReadTimeout(this.channel));
            } else {
                this.channel.write((Object)message2, this.channel.voidPromise());
            }
        });
    }

    private void setAutoRead(boolean value) {
        this.channel.config().setAutoRead(value);
    }

    private boolean verifyOpen(ResponseHandler handler1, ResponseHandler handler2) {
        Status connectionStatus = this.status.get();
        switch (connectionStatus) {
            case OPEN: {
                return true;
            }
            case RELEASED: {
                IllegalStateException error = new IllegalStateException("Connection has been released to the pool and can't be used");
                if (handler1 != null) {
                    handler1.onFailure(error);
                }
                if (handler2 != null) {
                    handler2.onFailure(error);
                }
                return false;
            }
            case TERMINATED: {
                IllegalStateException terminatedError = new IllegalStateException("Connection has been terminated and can't be used");
                if (handler1 != null) {
                    handler1.onFailure(terminatedError);
                }
                if (handler2 != null) {
                    handler2.onFailure(terminatedError);
                }
                return false;
            }
        }
        throw new IllegalStateException("Unknown status: " + (Object)((Object)connectionStatus));
    }

    private void registerConnectionReadTimeout(Channel channel) {
        if (!channel.eventLoop().inEventLoop()) {
            throw new IllegalStateException("This method may only be called in the EventLoop");
        }
        if (this.connectionReadTimeout != null && this.connectionReadTimeoutHandler == null) {
            this.connectionReadTimeoutHandler = new ConnectionReadTimeoutHandler(this.connectionReadTimeout, TimeUnit.SECONDS);
            channel.pipeline().addFirst(new ChannelHandler[]{this.connectionReadTimeoutHandler});
            this.log.debug("Added ConnectionReadTimeoutHandler", new Object[0]);
            this.messageDispatcher.setBeforeLastHandlerHook(messageType -> {
                channel.pipeline().remove(this.connectionReadTimeoutHandler);
                this.connectionReadTimeoutHandler = null;
                this.messageDispatcher.setBeforeLastHandlerHook(null);
                this.log.debug("Removed ConnectionReadTimeoutHandler", new Object[0]);
            });
        }
    }

    private static enum Status {
        OPEN,
        RELEASED,
        TERMINATED;

    }
}

