/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.util.Collections;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Record;
import org.neo4j.driver.Session;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.DefaultBookmarkHolder;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.InternalSession;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.ValueFactory;

class ParametersTest {
    ParametersTest() {
    }

    static Stream<Arguments> addressesToParse() {
        return Stream.of(Arguments.of((Object[])new Object[]{ValueFactory.emptyNodeValue(), "Nodes can't be used as parameters."}), Arguments.of((Object[])new Object[]{ValueFactory.emptyNodeValue().asNode(), "Nodes can't be used as parameters."}), Arguments.of((Object[])new Object[]{ValueFactory.emptyRelationshipValue(), "Relationships can't be used as parameters."}), Arguments.of((Object[])new Object[]{ValueFactory.emptyRelationshipValue().asRelationship(), "Relationships can't be used as parameters."}), Arguments.of((Object[])new Object[]{ValueFactory.filledPathValue(), "Paths can't be used as parameters."}), Arguments.of((Object[])new Object[]{ValueFactory.filledPathValue().asPath(), "Paths can't be used as parameters."}));
    }

    @ParameterizedTest
    @MethodSource(value={"addressesToParse"})
    void shouldGiveHelpfulMessageOnMisalignedInput(Object obj, String expectedMsg) {
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> Values.parameters((Object[])new Object[]{"1", obj, "2"}));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Parameters function requires an even number of arguments, alternating key and value."));
    }

    @ParameterizedTest
    @MethodSource(value={"addressesToParse"})
    void shouldNotBePossibleToUseInvalidParameterTypesViaParameters(Object obj, String expectedMsg) {
        Session session = this.mockedSession();
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> session.run("RETURN {a}", Values.parameters((Object[])new Object[]{"a", obj})));
        Assertions.assertEquals((Object)expectedMsg, (Object)e.getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"addressesToParse"})
    void shouldNotBePossibleToUseInvalidParametersViaMap(Object obj, String expectedMsg) {
        Session session = this.mockedSession();
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> session.run("RETURN {a}", Collections.singletonMap("a", obj)));
        Assertions.assertEquals((Object)expectedMsg, (Object)e.getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"addressesToParse"})
    void shouldNotBePossibleToUseInvalidParametersViaRecord(Object obj, String expectedMsg) {
        Assumptions.assumeTrue((boolean)(obj instanceof Value));
        InternalRecord record = new InternalRecord(Collections.singletonList("a"), new Value[]{(Value)obj});
        Session session = this.mockedSession();
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> ParametersTest.lambda$shouldNotBePossibleToUseInvalidParametersViaRecord$3(session, (Record)record));
        Assertions.assertEquals((Object)expectedMsg, (Object)e.getMessage());
    }

    private Session mockedSession() {
        ConnectionProvider provider = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        RetryLogic retryLogic = (RetryLogic)Mockito.mock(RetryLogic.class);
        NetworkSession session = new NetworkSession(provider, retryLogic, DatabaseNameUtil.defaultDatabase(), AccessMode.WRITE, (BookmarkHolder)new DefaultBookmarkHolder(), null, -1L, DevNullLogging.DEV_NULL_LOGGING);
        return new InternalSession(session);
    }

    private static /* synthetic */ void lambda$shouldNotBePossibleToUseInvalidParametersViaRecord$3(Session session, Record record) throws Throwable {
        session.run("RETURN {a}", record);
    }
}

