/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Logging;
import org.neo4j.driver.net.ServerAddress;
import org.neo4j.driver.net.ServerAddressResolver;

class ResolverIT {
    ResolverIT() {
    }

    @Test
    void shouldFailInitialDiscoveryWhenConfiguredResolverThrows() {
        ServerAddressResolver resolver = (ServerAddressResolver)Mockito.mock(ServerAddressResolver.class);
        Mockito.when((Object)resolver.resolve((ServerAddress)ArgumentMatchers.any(ServerAddress.class))).thenThrow(new Throwable[]{new RuntimeException("Resolution failure!")});
        Config config = Config.builder().withoutEncryption().withLogging(Logging.none()).withResolver(resolver).build();
        Driver driver = GraphDatabase.driver((String)"neo4j://my.server.com:9001", (Config)config);
        RuntimeException error = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ((Driver)driver).verifyConnectivity());
        Assertions.assertEquals((Object)"Resolution failure!", (Object)error.getMessage());
        ((ServerAddressResolver)Mockito.verify((Object)resolver)).resolve(ServerAddress.of((String)"my.server.com", (int)9001));
    }
}

