/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.AsyncTransactionWork;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.internal.async.connection.EventLoopGroupFactory;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.TestUtil;

@ParallelizableIT
class SessionMixIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();
    private AsyncSession asyncSession;
    private Session session;

    SessionMixIT() {
    }

    @BeforeEach
    void setUp() {
        this.asyncSession = this.newAsyncSession();
        this.session = this.newSession();
    }

    @AfterEach
    void tearDown() {
        TestUtil.await(this.asyncSession.closeAsync());
        this.session.close();
    }

    private AsyncSession newAsyncSession() {
        return neo4j.driver().asyncSession();
    }

    private Session newSession() {
        return neo4j.driver().session();
    }

    @Test
    void shouldFailToExecuteBlockingRunChainedWithAsyncTransaction() {
        CompletionStage<Void> result = this.asyncSession.beginTransactionAsync(TransactionConfig.empty()).thenApply(tx -> {
            if (EventLoopGroupFactory.isEventLoopThread((Thread)Thread.currentThread())) {
                IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.session.run("CREATE ()"));
                MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is(org.neo4j.driver.internal.util.Matchers.blockingOperationInEventLoopError()));
            }
            return null;
        });
        Assertions.assertNull(TestUtil.await(result));
    }

    @Test
    void shouldAllowUsingBlockingApiInCommonPoolWhenChaining() {
        CompletionStage<AsyncTransaction> txStage = this.asyncSession.beginTransactionAsync().thenApplyAsync(tx -> {
            this.session.run("UNWIND [1,1,2] AS x CREATE (:Node {id: x})").consume();
            this.session.run("CREATE (:Node {id: 42})").consume();
            tx.commitAsync();
            return tx;
        });
        TestUtil.await(txStage);
        Assertions.assertEquals((int)2, (int)this.countNodes(1));
        Assertions.assertEquals((int)1, (int)this.countNodes(2));
        Assertions.assertEquals((int)1, (int)this.countNodes(42));
    }

    @Test
    void shouldFailToExecuteBlockingRunInAsyncTransactionFunction() {
        AsyncTransactionWork completionStageTransactionWork = tx -> {
            if (EventLoopGroupFactory.isEventLoopThread((Thread)Thread.currentThread())) {
                IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.session.run("UNWIND range(1, 10000) AS x CREATE (n:AsyncNode {x: x}) RETURN n"));
                MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is(org.neo4j.driver.internal.util.Matchers.blockingOperationInEventLoopError()));
            }
            return CompletableFuture.completedFuture(null);
        };
        CompletionStage result = this.asyncSession.readTransactionAsync(completionStageTransactionWork);
        Assertions.assertNull(TestUtil.await(result));
    }

    @Test
    void shouldFailToExecuteBlockingRunChainedWithAsyncRun() {
        CompletionStage<Void> result = this.asyncSession.runAsync("RETURN 1").thenCompose(ResultCursor::singleAsync).thenApply(record -> {
            if (EventLoopGroupFactory.isEventLoopThread((Thread)Thread.currentThread())) {
                IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.session.run("RETURN $x", Values.parameters((Object[])new Object[]{"x", record.get(0).asInt()})));
                MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is(org.neo4j.driver.internal.util.Matchers.blockingOperationInEventLoopError()));
            }
            return null;
        });
        Assertions.assertNull(TestUtil.await(result));
    }

    @Test
    void shouldAllowBlockingOperationInCommonPoolWhenChaining() {
        CompletionStage<Node> nodeStage = this.asyncSession.runAsync("RETURN 42 AS value").thenCompose(ResultCursor::singleAsync).thenApplyAsync(record -> this.session.run("CREATE (n:Node {value: $value}) RETURN n", record)).thenApply(Result::single).thenApply(record -> record.get(0).asNode());
        Node node = (Node)TestUtil.await(nodeStage);
        Assertions.assertEquals((int)42, (int)node.get("value").asInt());
        Assertions.assertEquals((long)1L, (long)this.countNodesByLabel("Node"));
    }

    private void runNestedQueries(ResultCursor inputCursor, List<CompletionStage<Record>> stages, CompletableFuture<List<CompletionStage<Record>>> resultFuture) {
        CompletionStage recordResponse = inputCursor.nextAsync();
        stages.add(recordResponse);
        recordResponse.whenComplete((record, error) -> {
            if (error != null) {
                resultFuture.completeExceptionally((Throwable)error);
            } else if (record != null) {
                this.runNestedQuery(inputCursor, (Record)record, stages, resultFuture);
            } else {
                resultFuture.complete(stages);
            }
        });
    }

    private void runNestedQuery(ResultCursor inputCursor, Record record, List<CompletionStage<Record>> stages, CompletableFuture<List<CompletionStage<Record>>> resultFuture) {
        Node node = record.get(0).asNode();
        long id = node.get("id").asLong();
        long age = id * 10L;
        CompletionStage response = this.asyncSession.runAsync("MATCH (p:Person {id: $id}) SET p.age = $age RETURN p", Values.parameters((Object[])new Object[]{"id", id, "age", age}));
        response.whenComplete((cursor, error) -> {
            if (error != null) {
                resultFuture.completeExceptionally(Futures.completionExceptionCause((Throwable)error));
            } else {
                stages.add(cursor.nextAsync());
                this.runNestedQueries(inputCursor, stages, resultFuture);
            }
        });
    }

    private long countNodesByLabel(String label) {
        CompletionStage<Long> countStage = this.asyncSession.runAsync("MATCH (n:" + label + ") RETURN count(n)").thenCompose(ResultCursor::singleAsync).thenApply(record -> record.get(0).asLong());
        return (Long)TestUtil.await(countStage);
    }

    private int countNodes(Object id) {
        Query query = new Query("MATCH (n:Node {id: $id}) RETURN count(n)", Values.parameters((Object[])new Object[]{"id", id}));
        Record record = this.session.run(query).single();
        return record.get(0).asInt();
    }
}

