/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.integration;

import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.util.concurrent.CompletionStage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.internal.security.SecurityPlanImpl;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.io.ChannelTrackingDriverFactory;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.TestUtil;

@ParallelizableIT
class UnmanagedTransactionIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();
    private NetworkSession session;

    UnmanagedTransactionIT() {
    }

    @BeforeEach
    void setUp() {
        this.session = ((InternalDriver)neo4j.driver()).newSession(SessionConfig.defaultConfig());
    }

    @AfterEach
    void tearDown() {
        this.session.closeAsync();
    }

    private UnmanagedTransaction beginTransaction() {
        return this.beginTransaction(this.session);
    }

    private UnmanagedTransaction beginTransaction(NetworkSession session) {
        return (UnmanagedTransaction)TestUtil.await(session.beginTransactionAsync(TransactionConfig.empty()));
    }

    private ResultCursor sessionRun(NetworkSession session, Query query) {
        return (ResultCursor)TestUtil.await(session.runAsync(query, TransactionConfig.empty()));
    }

    private ResultCursor txRun(UnmanagedTransaction tx, String query) {
        return (ResultCursor)TestUtil.await(tx.runAsync(new Query(query)));
    }

    @Test
    void shouldDoNothingWhenCommittedSecondTime() {
        UnmanagedTransaction tx = this.beginTransaction();
        Assertions.assertNull(TestUtil.await(tx.commitAsync()));
        Assertions.assertTrue((boolean)tx.commitAsync().toCompletableFuture().isDone());
        Assertions.assertFalse((boolean)tx.isOpen());
    }

    @Test
    void shouldFailToCommitAfterRollback() {
        UnmanagedTransaction tx = this.beginTransaction();
        Assertions.assertNull(TestUtil.await(tx.rollbackAsync()));
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> TestUtil.await(tx.commitAsync()));
        Assertions.assertEquals((Object)"Can't commit, transaction has been rolled back", (Object)e.getMessage());
        Assertions.assertFalse((boolean)tx.isOpen());
    }

    @Test
    void shouldFailToCommitAfterTermination() {
        UnmanagedTransaction tx = this.beginTransaction();
        tx.markTerminated(null);
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> TestUtil.await(tx.commitAsync()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Transaction can't be committed"));
    }

    @Test
    void shouldDoNothingWhenRolledBackSecondTime() {
        UnmanagedTransaction tx = this.beginTransaction();
        Assertions.assertNull(TestUtil.await(tx.rollbackAsync()));
        Assertions.assertTrue((boolean)tx.rollbackAsync().toCompletableFuture().isDone());
        Assertions.assertFalse((boolean)tx.isOpen());
    }

    @Test
    void shouldFailToRollbackAfterCommit() {
        UnmanagedTransaction tx = this.beginTransaction();
        Assertions.assertNull(TestUtil.await(tx.commitAsync()));
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> TestUtil.await(tx.rollbackAsync()));
        Assertions.assertEquals((Object)"Can't rollback, transaction has been committed", (Object)e.getMessage());
        Assertions.assertFalse((boolean)tx.isOpen());
    }

    @Test
    void shouldRollbackAfterTermination() {
        UnmanagedTransaction tx = this.beginTransaction();
        tx.markTerminated(null);
        Assertions.assertNull(TestUtil.await(tx.rollbackAsync()));
        Assertions.assertFalse((boolean)tx.isOpen());
    }

    @Test
    void shouldFailToRunQueryWhenTerminated() {
        UnmanagedTransaction tx = this.beginTransaction();
        this.txRun(tx, "CREATE (:MyLabel)");
        tx.markTerminated(null);
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> this.txRun(tx, "CREATE (:MyOtherLabel)"));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Cannot run more queries in this transaction"));
    }

    @Test
    void shouldBePossibleToRunMoreTransactionsAfterOneIsTerminated() {
        UnmanagedTransaction tx1 = this.beginTransaction();
        tx1.markTerminated(null);
        ClientException e = (ClientException)Assertions.assertThrows(ClientException.class, () -> TestUtil.await(tx1.commitAsync()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Transaction can't be committed"));
        TestUtil.await(this.session.beginTransactionAsync(TransactionConfig.empty()).thenCompose(tx -> tx.runAsync(new Query("CREATE (:Node {id: 42})")).thenCompose(ResultCursor::consumeAsync).thenApply(ignore -> tx)).thenCompose(UnmanagedTransaction::commitAsync));
        Assertions.assertEquals((int)1, (int)this.countNodes(42));
    }

    @Test
    void shouldPropagateCommitFailureAfterFatalError() {
        this.testCommitAndRollbackFailurePropagation(true);
    }

    @Test
    void shouldPropagateRollbackFailureAfterFatalError() {
        this.testCommitAndRollbackFailurePropagation(false);
    }

    private int countNodes(Object id) {
        Query query = new Query("MATCH (n:Node {id: $id}) RETURN count(n)", Values.parameters((Object[])new Object[]{"id", id}));
        ResultCursor cursor = this.sessionRun(this.session, query);
        return ((Record)TestUtil.await(cursor.singleAsync())).get(0).asInt();
    }

    private void testCommitAndRollbackFailurePropagation(boolean commit) {
        ChannelTrackingDriverFactory driverFactory = new ChannelTrackingDriverFactory(1, Clock.SYSTEM);
        Config config = Config.builder().withLogging(DevNullLogging.DEV_NULL_LOGGING).build();
        try (Driver driver = driverFactory.newInstance(neo4j.uri(), neo4j.authToken(), RoutingSettings.DEFAULT, RetrySettings.DEFAULT, config, SecurityPlanImpl.insecure());){
            NetworkSession session = ((InternalDriver)driver).newSession(SessionConfig.defaultConfig());
            UnmanagedTransaction tx = this.beginTransaction(session);
            this.txRun(tx, "UNWIND range(0, 10000) AS x RETURN x + 1");
            IOException ioError = new IOException("Connection reset by peer");
            for (Channel channel : driverFactory.channels()) {
                Future future = channel.eventLoop().submit(() -> channel.pipeline().fireExceptionCaught((Throwable)ioError));
                TestUtil.await(future);
            }
            CompletionStage commitOrRollback = commit ? tx.commitAsync() : tx.rollbackAsync();
            ServiceUnavailableException e = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> TestUtil.await(commitOrRollback));
            Assertions.assertEquals((Object)ioError, (Object)e.getCause());
        }
    }
}

