/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import io.netty.bootstrap.Bootstrap;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.ConnectionPool;

class CustomSecurityPlanTest {
    CustomSecurityPlanTest() {
    }

    @Test
    void testCustomSecurityPlanUsed() {
        SecurityPlanCapturingDriverFactory driverFactory = new SecurityPlanCapturingDriverFactory();
        SecurityPlan securityPlan = (SecurityPlan)Mockito.mock(SecurityPlan.class);
        driverFactory.newInstance(URI.create("neo4j://somewhere:1234"), AuthTokens.none(), RoutingSettings.DEFAULT, RetrySettings.DEFAULT, Config.defaultConfig(), null, securityPlan);
        Assertions.assertFalse((boolean)driverFactory.capturedSecurityPlans.isEmpty());
        Assertions.assertTrue((boolean)driverFactory.capturedSecurityPlans.stream().allMatch(capturePlan -> capturePlan == securityPlan));
    }

    private static class SecurityPlanCapturingDriverFactory
    extends DriverFactory {
        List<SecurityPlan> capturedSecurityPlans = new ArrayList<SecurityPlan>();

        private SecurityPlanCapturingDriverFactory() {
        }

        protected InternalDriver createDriver(SecurityPlan securityPlan, SessionFactory sessionFactory, MetricsProvider metricsProvider, Config config) {
            this.capturedSecurityPlans.add(securityPlan);
            return super.createDriver(securityPlan, sessionFactory, metricsProvider, config);
        }

        protected ConnectionPool createConnectionPool(AuthToken authToken, SecurityPlan securityPlan, Bootstrap bootstrap, MetricsProvider metricsProvider, Config config, boolean ownsEventLoopGroup, RoutingContext routingContext) {
            this.capturedSecurityPlans.add(securityPlan);
            return super.createConnectionPool(authToken, securityPlan, bootstrap, metricsProvider, config, ownsEventLoopGroup, routingContext);
        }
    }
}

