/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalPair;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.InternalRelationship;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.util.Pair;

class ExtractTest {
    ExtractTest() {
    }

    @Test
    void extractEmptyArrayShouldNotBeModifiable() {
        List list = Extract.list((Value[])new Value[0]);
        MatcherAssert.assertThat((Object)list, (Matcher)Matchers.empty());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.add(null));
    }

    @Test
    void extractSingletonShouldNotBeModifiable() {
        List list = Extract.list((Value[])new Value[]{Values.value((int)42)});
        MatcherAssert.assertThat((Object)list, (Matcher)CoreMatchers.equalTo(Collections.singletonList(Values.value((int)42))));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.add(null));
    }

    @Test
    void extractMultipleShouldNotBeModifiable() {
        List list = Extract.list((Value[])new Value[]{Values.value((int)42), Values.value((int)43)});
        MatcherAssert.assertThat((Object)list, (Matcher)CoreMatchers.equalTo(Arrays.asList(Values.value((int)42), Values.value((int)43))));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.add(null));
    }

    @Test
    void testMapOverList() {
        List mapped = Extract.list((Value[])new Value[]{Values.value((int)42), Values.value((int)43)}, Value::asInt);
        MatcherAssert.assertThat((Object)mapped, (Matcher)CoreMatchers.equalTo(Arrays.asList(42, 43)));
    }

    @Test
    void testMapValues() {
        HashMap<String, Value> map = new HashMap<String, Value>();
        map.put("k1", Values.value((int)43));
        map.put("k2", Values.value((int)42));
        Map mappedMap = Extract.map(map, Value::asInt);
        Collection values = mappedMap.values();
        MatcherAssert.assertThat(values, (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{43, 42}));
    }

    @Test
    void testShouldPreserveMapOrderMapValues() {
        LinkedHashMap map = Iterables.newLinkedHashMapWithSize((int)2);
        map.put("k2", Values.value((int)43));
        map.put("k1", Values.value((int)42));
        Map mappedMap = Extract.map((Map)map, Value::asInt);
        Collection values = mappedMap.values();
        MatcherAssert.assertThat(values, (Matcher)Matchers.contains((Object[])new Integer[]{43, 42}));
    }

    @Test
    void testProperties() {
        HashMap<String, Value> props = new HashMap<String, Value>();
        props.put("k1", Values.value((int)43));
        props.put("k2", Values.value((int)42));
        InternalNode node = new InternalNode(42L, Collections.singletonList("L"), props);
        Iterable properties = Extract.properties((MapAccessor)node, Value::asInt);
        Iterator iterator = properties.iterator();
        MatcherAssert.assertThat((Object)((Pair)iterator.next()), (Matcher)CoreMatchers.equalTo((Object)InternalPair.of((Object)"k1", (Object)43)));
        MatcherAssert.assertThat((Object)((Pair)iterator.next()), (Matcher)CoreMatchers.equalTo((Object)InternalPair.of((Object)"k2", (Object)42)));
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void testFields() {
        InternalRecord record = new InternalRecord(Arrays.asList("k1"), new Value[]{Values.value((int)42)});
        List fields = Extract.fields((Record)record, Value::asInt);
        MatcherAssert.assertThat((Object)fields, (Matcher)CoreMatchers.equalTo(Collections.singletonList(InternalPair.of((Object)"k1", (Object)42))));
    }

    @Test
    void shouldExtractMapOfValuesFromNullOrEmptyMap() {
        Assertions.assertEquals(Collections.emptyMap(), (Object)Extract.mapOfValues(null));
        Assertions.assertEquals(Collections.emptyMap(), (Object)Extract.mapOfValues(Collections.emptyMap()));
    }

    @Test
    void shouldExtractMapOfValues() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key1", "value1");
        map.put("key2", 42L);
        map.put("key3", LocalDate.now());
        map.put("key4", new byte[]{1, 2, 3});
        Map mapOfValues = Extract.mapOfValues(map);
        Assertions.assertEquals((int)4, (int)map.size());
        Assertions.assertEquals((Object)Values.value((String)"value1"), mapOfValues.get("key1"));
        Assertions.assertEquals((Object)Values.value((long)42L), mapOfValues.get("key2"));
        Assertions.assertEquals((Object)Values.value((LocalDate)LocalDate.now()), mapOfValues.get("key3"));
        Assertions.assertEquals((Object)Values.value((byte[])new byte[]{1, 2, 3}), mapOfValues.get("key4"));
    }

    @Test
    void shouldFailToExtractMapOfValuesFromUnsupportedValues() {
        Assertions.assertThrows(ClientException.class, () -> Extract.mapOfValues(Collections.singletonMap("key", new InternalNode(1L))));
        Assertions.assertThrows(ClientException.class, () -> Extract.mapOfValues(Collections.singletonMap("key", new InternalRelationship(1L, 1L, 1L, "HI"))));
        Assertions.assertThrows(ClientException.class, () -> Extract.mapOfValues(Collections.singletonMap("key", new InternalPath(new Entity[]{new InternalNode(1L)}))));
    }
}

