/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.util.TestUtil;

class InternalBookmarkTest {
    InternalBookmarkTest() {
    }

    @Test
    void isEmptyForEmptyBookmark() {
        Bookmark bookmark = InternalBookmark.empty();
        Assertions.assertTrue((boolean)bookmark.isEmpty());
        Assertions.assertEquals(Collections.emptySet(), (Object)bookmark.values());
    }

    @Test
    void shouldSetToEmptyForNullBookmark() throws Throwable {
        Bookmark bookmark = InternalBookmark.from(null);
        Assertions.assertEquals((Object)InternalBookmark.empty(), (Object)bookmark);
    }

    @Test
    void shouldSetToEmptyForEmptyBookmarkIterator() throws Throwable {
        Bookmark bookmark = InternalBookmark.from(Collections.emptyList());
        Assertions.assertEquals((Object)InternalBookmark.empty(), (Object)bookmark);
    }

    @Test
    void shouldSetToEmptyForNullBookmarkList() throws Throwable {
        Bookmark bookmark = InternalBookmark.from(Collections.singletonList(null));
        Assertions.assertEquals((Object)InternalBookmark.empty(), (Object)bookmark);
    }

    @Test
    void shouldIgnoreNullAndEmptyInBookmarkList() throws Throwable {
        Bookmark bookmark = InternalBookmark.from(Arrays.asList(InternalBookmark.empty(), null, null));
        Assertions.assertEquals((Object)InternalBookmark.empty(), (Object)bookmark);
    }

    @Test
    void shouldReserveBookmarkValuesCorrectly() throws Throwable {
        Bookmark one = InternalBookmark.parse((String)"one");
        Bookmark two = InternalBookmark.parse((String)"two");
        Bookmark empty = InternalBookmark.empty();
        Bookmark bookmark = InternalBookmark.from(Arrays.asList(one, two, null, empty));
        InternalBookmarkTest.verifyValues(bookmark, "one", "two");
    }

    @Test
    void isNotEmptyForNonEmptyBookmark() {
        Bookmark bookmark = InternalBookmark.parse((String)"SomeBookmark");
        Assertions.assertFalse((boolean)bookmark.isEmpty());
    }

    @Test
    void asBeginTransactionParametersForNonEmptyBookmark() {
        Bookmark bookmark = InternalBookmark.parse((String)"SomeBookmark");
        InternalBookmarkTest.verifyValues(bookmark, "SomeBookmark");
    }

    @Test
    void bookmarkFromString() {
        Bookmark bookmark = InternalBookmark.parse((String)"Cat");
        Assertions.assertEquals(Collections.singleton("Cat"), (Object)bookmark.values());
        InternalBookmarkTest.verifyValues(bookmark, "Cat");
    }

    @Test
    void bookmarkFromNullString() {
        Bookmark bookmark = InternalBookmark.parse((String)null);
        Assertions.assertTrue((boolean)bookmark.isEmpty());
    }

    @Test
    void bookmarkFromSet() {
        Set<String> input = TestUtil.asSet("neo4j:bookmark:v1:tx42", "neo4j:bookmark:v1:tx10", "neo4j:bookmark:v1:tx12");
        Bookmark bookmark = InternalBookmark.parse(input);
        InternalBookmarkTest.verifyValues(bookmark, "neo4j:bookmark:v1:tx42", "neo4j:bookmark:v1:tx10", "neo4j:bookmark:v1:tx12");
    }

    @Test
    void bookmarkFromNullIterable() {
        Bookmark bookmark = InternalBookmark.parse((Set)null);
        Assertions.assertTrue((boolean)bookmark.isEmpty());
    }

    @Test
    void bookmarkFromEmptyIterable() {
        Bookmark bookmark = InternalBookmark.parse(Collections.emptySet());
        Assertions.assertTrue((boolean)bookmark.isEmpty());
    }

    @Test
    void asBeginTransactionParametersForBookmarkWithInvalidValue() {
        Bookmark bookmark = InternalBookmark.parse(TestUtil.asSet("neo4j:bookmark:v1:tx1", "neo4j:bookmark:v1:txcat", "neo4j:bookmark:v1:tx3"));
        InternalBookmarkTest.verifyValues(bookmark, "neo4j:bookmark:v1:tx1", "neo4j:bookmark:v1:txcat", "neo4j:bookmark:v1:tx3");
    }

    @Test
    void shouldReturnAllBookmarks() {
        Assertions.assertIterableEquals(Collections.emptyList(), (Iterable)InternalBookmark.empty().values());
        Assertions.assertIterableEquals(Collections.singleton("neo4j:bookmark:v1:tx42"), (Iterable)InternalBookmark.parse((String)"neo4j:bookmark:v1:tx42").values());
        Set<String> bookmarks = TestUtil.asSet("neo4j:bookmark:v1:tx1", "neo4j:bookmark:v1:tx2", "neo4j:bookmark:v1:tx3");
        Assertions.assertIterableEquals(bookmarks, (Iterable)InternalBookmark.parse(bookmarks).values());
    }

    @Test
    void valueShouldBeReadOnly() throws Throwable {
        Bookmark bookmark = InternalBookmark.parse(TestUtil.asSet("first", "second"));
        Set values = bookmark.values();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> values.add("third"));
    }

    private static void verifyValues(Bookmark bookmark, String ... expectedValues) {
        Assert.assertThat((Object)bookmark.values().size(), (Matcher)CoreMatchers.equalTo((Object)expectedValues.length));
        Assert.assertThat((Object)bookmark.values(), (Matcher)CoreMatchers.hasItems((Object[])expectedValues));
    }
}

