/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.InternalRelationship;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Relationship;

class InternalPathTest {
    InternalPathTest() {
    }

    private InternalPath testPath() {
        return new InternalPath(new Entity[]{new InternalNode(1L), new InternalRelationship(-1L, 1L, 2L, "KNOWS"), new InternalNode(2L), new InternalRelationship(-2L, 3L, 2L, "KNOWS"), new InternalNode(3L), new InternalRelationship(-3L, 3L, 4L, "KNOWS"), new InternalNode(4L)});
    }

    @Test
    void pathSizeShouldReturnNumberOfRelationships() {
        InternalPath path = this.testPath();
        org.hamcrest.junit.MatcherAssert.assertThat((Object)path.length(), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    void shouldBeAbleToCreatePathWithSingleNode() {
        InternalPath path = new InternalPath(new Entity[]{new InternalNode(1L)});
        org.hamcrest.junit.MatcherAssert.assertThat((Object)path.length(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    void shouldBeAbleToIterateOverPathAsSegments() {
        InternalPath path = this.testPath();
        List segments = Iterables.asList((Iterable)path);
        MatcherAssert.assertThat((Object)segments, (Matcher)CoreMatchers.equalTo(Arrays.asList(new InternalPath.SelfContainedSegment((Node)new InternalNode(1L), (Relationship)new InternalRelationship(-1L, 1L, 2L, "KNOWS"), (Node)new InternalNode(2L)), new InternalPath.SelfContainedSegment((Node)new InternalNode(2L), (Relationship)new InternalRelationship(-2L, 3L, 2L, "KNOWS"), (Node)new InternalNode(3L)), new InternalPath.SelfContainedSegment((Node)new InternalNode(3L), (Relationship)new InternalRelationship(-3L, 3L, 4L, "KNOWS"), (Node)new InternalNode(4L)))));
    }

    @Test
    void shouldBeAbleToIterateOverPathNodes() {
        InternalPath path = this.testPath();
        List segments = Iterables.asList((Iterable)path.nodes());
        org.hamcrest.junit.MatcherAssert.assertThat((Object)segments, (Matcher)CoreMatchers.equalTo(Arrays.asList(new InternalNode(1L), new InternalNode(2L), new InternalNode(3L), new InternalNode(4L))));
    }

    @Test
    void shouldBeAbleToIterateOverPathRelationships() {
        InternalPath path = this.testPath();
        List segments = Iterables.asList((Iterable)path.relationships());
        org.hamcrest.junit.MatcherAssert.assertThat((Object)segments, (Matcher)CoreMatchers.equalTo(Arrays.asList(new InternalRelationship(-1L, 1L, 2L, "KNOWS"), new InternalRelationship(-2L, 3L, 2L, "KNOWS"), new InternalRelationship(-3L, 3L, 4L, "KNOWS"))));
    }

    @Test
    void shouldNotBeAbleToCreatePathWithNoEntities() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new InternalPath(new Entity[0]));
    }

    @Test
    void shouldNotBeAbleToCreatePathWithEvenNumberOfEntities() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new InternalPath(new Entity[]{new InternalNode(1L), new InternalRelationship(2L, 3L, 4L, "KNOWS")}));
    }

    @Test
    void shouldNotBeAbleToCreatePathWithNullEntities() {
        InternalNode nullNode = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> new InternalPath(new Entity[]{nullNode}));
    }

    @Test
    void shouldNotBeAbleToCreatePathWithNodeThatDoesNotConnect() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new InternalPath(new Entity[]{new InternalNode(1L), new InternalRelationship(2L, 1L, 3L, "KNOWS"), new InternalNode(4L)}));
    }

    @Test
    void shouldNotBeAbleToCreatePathWithRelationshipThatDoesNotConnect() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new InternalPath(new Entity[]{new InternalNode(1L), new InternalRelationship(2L, 3L, 4L, "KNOWS"), new InternalNode(3L)}));
    }
}

