/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.value.NullValue;

class InternalRecordTest {
    InternalRecordTest() {
    }

    @Test
    void accessingUnknownKeyShouldBeNull() {
        InternalRecord record = this.createRecord();
        MatcherAssert.assertThat((Object)record.get("k1"), (Matcher)CoreMatchers.equalTo((Object)Values.value((int)0)));
        MatcherAssert.assertThat((Object)record.get("k2"), (Matcher)CoreMatchers.equalTo((Object)Values.value((int)1)));
        MatcherAssert.assertThat((Object)record.get("k3"), (Matcher)CoreMatchers.equalTo((Object)NullValue.NULL));
    }

    @Test
    void shouldHaveCorrectSize() {
        InternalRecord record = this.createRecord();
        MatcherAssert.assertThat((Object)record.size(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    void shouldHaveCorrectFieldIndices() {
        InternalRecord record = this.createRecord();
        MatcherAssert.assertThat((Object)record.index("k1"), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)record.index("k2"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    void shouldThrowWhenAskingForIndexOfUnknownField() {
        InternalRecord record = this.createRecord();
        Assertions.assertThrows(NoSuchElementException.class, () -> record.index("BATMAN"));
    }

    @Test
    void accessingOutOfBoundsShouldBeNull() {
        InternalRecord record = this.createRecord();
        MatcherAssert.assertThat((Object)record.get(0), (Matcher)CoreMatchers.equalTo((Object)Values.value((int)0)));
        MatcherAssert.assertThat((Object)record.get(1), (Matcher)CoreMatchers.equalTo((Object)Values.value((int)1)));
        MatcherAssert.assertThat((Object)record.get(2), (Matcher)CoreMatchers.equalTo((Object)NullValue.NULL));
        MatcherAssert.assertThat((Object)record.get(-37), (Matcher)CoreMatchers.equalTo((Object)NullValue.NULL));
    }

    @Test
    void testContainsKey() {
        InternalRecord record = this.createRecord();
        Assertions.assertTrue((boolean)record.containsKey("k1"));
        Assertions.assertTrue((boolean)record.containsKey("k2"));
        Assertions.assertFalse((boolean)record.containsKey("k3"));
    }

    @Test
    void testIndex() {
        InternalRecord record = this.createRecord();
        MatcherAssert.assertThat((Object)record.index("k1"), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)record.index("k2"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    void testAsMap() {
        InternalRecord record = this.createRecord();
        Map map = record.asMap();
        MatcherAssert.assertThat(map.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"k1", "k2"}));
        MatcherAssert.assertThat(map.get("k1"), (Matcher)CoreMatchers.equalTo((Object)0L));
        MatcherAssert.assertThat(map.get("k2"), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    void testMapExtraction() {
        InternalRecord record = this.createRecord();
        Function<Value, Integer> addOne = value -> value.asInt() + 1;
        Map map = Extract.map((Record)record, addOne);
        MatcherAssert.assertThat(map.keySet(), (Matcher)Matchers.contains((Object[])new String[]{"k1", "k2"}));
        MatcherAssert.assertThat((Object)((Integer)map.get("k1")), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Integer)map.get("k2")), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    void mapExtractionShouldPreserveIterationOrder() {
        List<String> keys = Arrays.asList("k2", "k1");
        InternalRecord record = new InternalRecord(keys, new Value[]{Values.value((int)0), Values.value((int)1)});
        Function<Value, Integer> addOne = value -> value.asInt() + 1;
        Map map = Extract.map((Record)record, addOne);
        MatcherAssert.assertThat(map.keySet(), (Matcher)Matchers.contains((Object[])new String[]{"k2", "k1"}));
        Iterator values = map.values().iterator();
        MatcherAssert.assertThat((Object)((Integer)values.next()), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Integer)values.next()), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    void testToString() {
        InternalRecord record = this.createRecord();
        MatcherAssert.assertThat((Object)record.toString(), (Matcher)CoreMatchers.equalTo((Object)"Record<{k1: 0, k2: 1}>"));
    }

    @Test
    void shouldHaveMethodToGetKeys() {
        List<String> keys = Arrays.asList("k2", "k1");
        InternalRecord record = new InternalRecord(keys, new Value[]{Values.value((int)0), Values.value((int)1)});
        List appendedKeys = record.keys();
        MatcherAssert.assertThat((Object)appendedKeys, (Matcher)CoreMatchers.equalTo(keys));
    }

    @Test
    void emptyKeysShouldGiveEmptyList() {
        List keys = Collections.emptyList();
        InternalRecord record = new InternalRecord(keys, new Value[0]);
        List appendedKeys = record.keys();
        MatcherAssert.assertThat((Object)appendedKeys, (Matcher)CoreMatchers.equalTo(keys));
    }

    @Test
    void shouldHaveMethodToGetValues() {
        List<String> keys = Arrays.asList("k2", "k1");
        Value[] values = new Value[]{Values.value((int)0), Values.value((int)1)};
        InternalRecord record = new InternalRecord(keys, values);
        List appendedValues = record.values();
        MatcherAssert.assertThat((Object)appendedValues, (Matcher)CoreMatchers.equalTo(Arrays.asList(values)));
    }

    @Test
    void emptyValuesShouldGiveEmptyList() {
        List keys = Collections.emptyList();
        Value[] values = new Value[]{};
        InternalRecord record = new InternalRecord(keys, values);
        List appendedValues = record.values();
        MatcherAssert.assertThat((Object)appendedValues, (Matcher)CoreMatchers.equalTo(Arrays.asList(values)));
    }

    private InternalRecord createRecord() {
        List<String> keys = Arrays.asList("k1", "k2");
        return new InternalRecord(keys, new Value[]{Values.value((int)0), Values.value((int)1)});
    }
}

