/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Config;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.SessionFactoryImpl;
import org.neo4j.driver.internal.async.LeakLoggingNetworkSession;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.FixedRetryLogic;

class SessionFactoryImplTest {
    SessionFactoryImplTest() {
    }

    @Test
    void createsNetworkSessions() {
        Config config = Config.builder().withLogging(DevNullLogging.DEV_NULL_LOGGING).build();
        SessionFactory factory = SessionFactoryImplTest.newSessionFactory(config);
        NetworkSession readSession = factory.newInstance(SessionConfig.builder().withDefaultAccessMode(AccessMode.READ).build());
        MatcherAssert.assertThat((Object)readSession, (Matcher)Matchers.instanceOf(NetworkSession.class));
        NetworkSession writeSession = factory.newInstance(SessionConfig.builder().withDefaultAccessMode(AccessMode.WRITE).build());
        MatcherAssert.assertThat((Object)writeSession, (Matcher)Matchers.instanceOf(NetworkSession.class));
    }

    @Test
    void createsLeakLoggingNetworkSessions() {
        Config config = Config.builder().withLogging(DevNullLogging.DEV_NULL_LOGGING).withLeakedSessionsLogging().build();
        SessionFactory factory = SessionFactoryImplTest.newSessionFactory(config);
        NetworkSession readSession = factory.newInstance(SessionConfig.builder().withDefaultAccessMode(AccessMode.READ).build());
        MatcherAssert.assertThat((Object)readSession, (Matcher)Matchers.instanceOf(LeakLoggingNetworkSession.class));
        NetworkSession writeSession = factory.newInstance(SessionConfig.builder().withDefaultAccessMode(AccessMode.WRITE).build());
        MatcherAssert.assertThat((Object)writeSession, (Matcher)Matchers.instanceOf(LeakLoggingNetworkSession.class));
    }

    private static SessionFactory newSessionFactory(Config config) {
        return new SessionFactoryImpl((ConnectionProvider)Mockito.mock(ConnectionProvider.class), (RetryLogic)new FixedRetryLogic(0), config);
    }
}

