/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.connection.AuthorizationStateListener;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.util.ServerVersion;

class ChannelAttributesTest {
    private final EmbeddedChannel channel = new EmbeddedChannel();

    ChannelAttributesTest() {
    }

    @Test
    void shouldSetAndGetConnectionId() {
        ChannelAttributes.setConnectionId((Channel)this.channel, (String)"bolt-42");
        Assertions.assertEquals((Object)"bolt-42", (Object)ChannelAttributes.connectionId((Channel)this.channel));
    }

    @Test
    void shouldFailToSetConnectionIdTwice() {
        ChannelAttributes.setConnectionId((Channel)this.channel, (String)"bolt-42");
        Assertions.assertThrows(IllegalStateException.class, () -> ChannelAttributes.setConnectionId((Channel)this.channel, (String)"bolt-4242"));
    }

    @Test
    void shouldSetAndGetProtocolVersion() {
        ChannelAttributes.setProtocolVersion((Channel)this.channel, (BoltProtocolVersion)new BoltProtocolVersion(42, 0));
        Assertions.assertEquals((Object)new BoltProtocolVersion(42, 0), (Object)ChannelAttributes.protocolVersion((Channel)this.channel));
    }

    @Test
    void shouldFailToSetProtocolVersionTwice() {
        ChannelAttributes.setProtocolVersion((Channel)this.channel, (BoltProtocolVersion)new BoltProtocolVersion(42, 0));
        Assertions.assertThrows(IllegalStateException.class, () -> ChannelAttributes.setProtocolVersion((Channel)this.channel, (BoltProtocolVersion)new BoltProtocolVersion(43, 0)));
    }

    @Test
    void shouldSetAndGetServerAgent() {
        String agent = "Neo4j/4.2.5";
        ChannelAttributes.setServerAgent((Channel)this.channel, (String)agent);
        Assertions.assertEquals((Object)agent, (Object)ChannelAttributes.serverAgent((Channel)this.channel));
    }

    @Test
    void shouldFailToSetServerAgentTwice() {
        String agent = "Neo4j/4.2.5";
        ChannelAttributes.setServerAgent((Channel)this.channel, (String)agent);
        Assertions.assertThrows(IllegalStateException.class, () -> ChannelAttributes.setServerAgent((Channel)this.channel, (String)agent));
    }

    @Test
    void shouldSetAndGetAddress() {
        BoltServerAddress address = new BoltServerAddress("local:42");
        ChannelAttributes.setServerAddress((Channel)this.channel, (BoltServerAddress)address);
        Assertions.assertEquals((Object)address, (Object)ChannelAttributes.serverAddress((Channel)this.channel));
    }

    @Test
    void shouldFailToSetAddressTwice() {
        ChannelAttributes.setServerAddress((Channel)this.channel, (BoltServerAddress)BoltServerAddress.LOCAL_DEFAULT);
        Assertions.assertThrows(IllegalStateException.class, () -> ChannelAttributes.setServerAddress((Channel)this.channel, (BoltServerAddress)BoltServerAddress.LOCAL_DEFAULT));
    }

    @Test
    void shouldSetAndGetCreationTimestamp() {
        ChannelAttributes.setCreationTimestamp((Channel)this.channel, (long)42L);
        Assertions.assertEquals((long)42L, (long)ChannelAttributes.creationTimestamp((Channel)this.channel));
    }

    @Test
    void shouldFailToSetCreationTimestampTwice() {
        ChannelAttributes.setCreationTimestamp((Channel)this.channel, (long)42L);
        Assertions.assertThrows(IllegalStateException.class, () -> ChannelAttributes.setCreationTimestamp((Channel)this.channel, (long)42L));
    }

    @Test
    void shouldSetAndGetLastUsedTimestamp() {
        Assertions.assertNull((Object)ChannelAttributes.lastUsedTimestamp((Channel)this.channel));
        ChannelAttributes.setLastUsedTimestamp((Channel)this.channel, (long)42L);
        Assertions.assertEquals((long)42L, (long)ChannelAttributes.lastUsedTimestamp((Channel)this.channel));
    }

    @Test
    void shouldAllowSettingLastUsedTimestampMultipleTimes() {
        ChannelAttributes.setLastUsedTimestamp((Channel)this.channel, (long)42L);
        ChannelAttributes.setLastUsedTimestamp((Channel)this.channel, (long)4242L);
        ChannelAttributes.setLastUsedTimestamp((Channel)this.channel, (long)424242L);
        Assertions.assertEquals((long)424242L, (long)ChannelAttributes.lastUsedTimestamp((Channel)this.channel));
    }

    @Test
    void shouldSetAndGetMessageDispatcher() {
        InboundMessageDispatcher dispatcher = (InboundMessageDispatcher)Mockito.mock(InboundMessageDispatcher.class);
        ChannelAttributes.setMessageDispatcher((Channel)this.channel, (InboundMessageDispatcher)dispatcher);
        Assertions.assertEquals((Object)dispatcher, (Object)ChannelAttributes.messageDispatcher((Channel)this.channel));
    }

    @Test
    void shouldFailToSetMessageDispatcherTwice() {
        ChannelAttributes.setMessageDispatcher((Channel)this.channel, (InboundMessageDispatcher)((InboundMessageDispatcher)Mockito.mock(InboundMessageDispatcher.class)));
        Assertions.assertThrows(IllegalStateException.class, () -> ChannelAttributes.setMessageDispatcher((Channel)this.channel, (InboundMessageDispatcher)((InboundMessageDispatcher)Mockito.mock(InboundMessageDispatcher.class))));
    }

    @Test
    void shouldSetAndGetServerVersion() {
        ServerVersion version = ServerVersion.version((String)"Neo4j/3.2.1");
        ChannelAttributes.setServerVersion((Channel)this.channel, (ServerVersion)version);
        Assertions.assertEquals((Object)version, (Object)ChannelAttributes.serverVersion((Channel)this.channel));
    }

    @Test
    void shouldFailToSetServerVersionTwice() {
        ChannelAttributes.setServerVersion((Channel)this.channel, (ServerVersion)ServerVersion.version((String)"Neo4j/3.2.2"));
        Assertions.assertThrows(IllegalStateException.class, () -> ChannelAttributes.setServerVersion((Channel)this.channel, (ServerVersion)ServerVersion.version((String)"Neo4j/3.2.3")));
    }

    @Test
    void shouldSetAndGetTerminationReason() {
        String reason = "This channel has been terminated";
        ChannelAttributes.setTerminationReason((Channel)this.channel, (String)reason);
        Assertions.assertEquals((Object)reason, (Object)ChannelAttributes.terminationReason((Channel)this.channel));
    }

    @Test
    void shouldFailToSetTerminationReasonTwice() {
        ChannelAttributes.setTerminationReason((Channel)this.channel, (String)"Reason 1");
        Assertions.assertThrows(IllegalStateException.class, () -> ChannelAttributes.setTerminationReason((Channel)this.channel, (String)"Reason 2"));
    }

    @Test
    void shouldSetAndGetAuthorizationStateListener() {
        AuthorizationStateListener listener = (AuthorizationStateListener)Mockito.mock(AuthorizationStateListener.class);
        ChannelAttributes.setAuthorizationStateListener((Channel)this.channel, (AuthorizationStateListener)listener);
        Assertions.assertEquals((Object)listener, (Object)ChannelAttributes.authorizationStateListener((Channel)this.channel));
    }

    @Test
    void shouldAllowOverridingAuthorizationStateListener() {
        AuthorizationStateListener listener = (AuthorizationStateListener)Mockito.mock(AuthorizationStateListener.class);
        ChannelAttributes.setAuthorizationStateListener((Channel)this.channel, (AuthorizationStateListener)listener);
        Assertions.assertEquals((Object)listener, (Object)ChannelAttributes.authorizationStateListener((Channel)this.channel));
        AuthorizationStateListener newListener = (AuthorizationStateListener)Mockito.mock(AuthorizationStateListener.class);
        ChannelAttributes.setAuthorizationStateListener((Channel)this.channel, (AuthorizationStateListener)newListener);
        Assertions.assertEquals((Object)newListener, (Object)ChannelAttributes.authorizationStateListener((Channel)this.channel));
    }

    @Test
    void shouldSetAndGetConnectionReadTimeout() {
        long timeout = 15L;
        ChannelAttributes.setConnectionReadTimeout((Channel)this.channel, (Long)timeout);
        Assertions.assertEquals((long)timeout, (Long)ChannelAttributes.connectionReadTimeout((Channel)this.channel).orElse(null));
    }

    @Test
    void shouldFailToSetConnectionReadTimeoutTwice() {
        long timeout = 15L;
        ChannelAttributes.setConnectionReadTimeout((Channel)this.channel, (Long)timeout);
        Assertions.assertThrows(IllegalStateException.class, () -> ChannelAttributes.setConnectionReadTimeout((Channel)this.channel, (Long)timeout));
    }
}

