/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderException;
import java.io.IOException;
import java.util.stream.Stream;
import javax.net.ssl.SSLHandshakeException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.Logging;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.async.connection.BoltProtocolUtil;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilder;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilderImpl;
import org.neo4j.driver.internal.async.connection.HandshakeHandler;
import org.neo4j.driver.internal.async.inbound.ChunkDecoder;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.async.inbound.InboundMessageHandler;
import org.neo4j.driver.internal.async.inbound.MessageDecoder;
import org.neo4j.driver.internal.async.outbound.OutboundMessageHandler;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v3.MessageFormatV3;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.messaging.v4.MessageFormatV4;
import org.neo4j.driver.internal.messaging.v41.BoltProtocolV41;
import org.neo4j.driver.internal.messaging.v42.BoltProtocolV42;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.util.TestUtil;

class HandshakeHandlerTest {
    private final EmbeddedChannel channel = new EmbeddedChannel();

    HandshakeHandlerTest() {
    }

    @BeforeEach
    void setUp() {
        ChannelAttributes.setMessageDispatcher((Channel)this.channel, (InboundMessageDispatcher)new InboundMessageDispatcher((Channel)this.channel, DevNullLogging.DEV_NULL_LOGGING));
    }

    @AfterEach
    void tearDown() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    void shouldFailGivenPromiseWhenExceptionCaught() {
        ChannelPromise handshakeCompletedPromise = this.channel.newPromise();
        HandshakeHandler handler = HandshakeHandlerTest.newHandler(handshakeCompletedPromise);
        this.channel.pipeline().addLast(new ChannelHandler[]{handler});
        RuntimeException cause = new RuntimeException("Error!");
        this.channel.pipeline().fireExceptionCaught((Throwable)cause);
        ServiceUnavailableException error = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> TestUtil.await(handshakeCompletedPromise));
        Assertions.assertEquals((Object)cause, (Object)error.getCause());
        Assertions.assertNull(TestUtil.await(this.channel.closeFuture()));
    }

    @Test
    void shouldFailGivenPromiseWhenServiceUnavailableExceptionCaught() {
        ChannelPromise handshakeCompletedPromise = this.channel.newPromise();
        HandshakeHandler handler = HandshakeHandlerTest.newHandler(handshakeCompletedPromise);
        this.channel.pipeline().addLast(new ChannelHandler[]{handler});
        ServiceUnavailableException error = new ServiceUnavailableException("Bad error");
        this.channel.pipeline().fireExceptionCaught((Throwable)error);
        ServiceUnavailableException e = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> TestUtil.await(handshakeCompletedPromise));
        Assertions.assertEquals((Object)error, (Object)e);
        Assertions.assertNull(TestUtil.await(this.channel.closeFuture()));
    }

    @Test
    void shouldFailGivenPromiseWhenMultipleExceptionsCaught() {
        ChannelPromise handshakeCompletedPromise = this.channel.newPromise();
        HandshakeHandler handler = HandshakeHandlerTest.newHandler(handshakeCompletedPromise);
        this.channel.pipeline().addLast(new ChannelHandler[]{handler});
        RuntimeException error1 = new RuntimeException("Error 1");
        RuntimeException error2 = new RuntimeException("Error 2");
        this.channel.pipeline().fireExceptionCaught((Throwable)error1);
        this.channel.pipeline().fireExceptionCaught((Throwable)error2);
        ServiceUnavailableException e1 = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> TestUtil.await(handshakeCompletedPromise));
        Assertions.assertEquals((Object)error1, (Object)e1.getCause());
        Assertions.assertNull(TestUtil.await(this.channel.closeFuture()));
        RuntimeException e2 = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ((EmbeddedChannel)this.channel).checkException());
        Assertions.assertEquals((Object)error2, (Object)e2);
    }

    @Test
    void shouldUnwrapDecoderException() {
        ChannelPromise handshakeCompletedPromise = this.channel.newPromise();
        HandshakeHandler handler = HandshakeHandlerTest.newHandler(handshakeCompletedPromise);
        this.channel.pipeline().addLast(new ChannelHandler[]{handler});
        IOException cause = new IOException("Error!");
        this.channel.pipeline().fireExceptionCaught((Throwable)new DecoderException((Throwable)cause));
        ServiceUnavailableException error = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> TestUtil.await(handshakeCompletedPromise));
        Assertions.assertEquals((Object)cause, (Object)error.getCause());
        Assertions.assertNull(TestUtil.await(this.channel.closeFuture()));
    }

    @Test
    void shouldHandleDecoderExceptionWithoutCause() {
        ChannelPromise handshakeCompletedPromise = this.channel.newPromise();
        HandshakeHandler handler = HandshakeHandlerTest.newHandler(handshakeCompletedPromise);
        this.channel.pipeline().addLast(new ChannelHandler[]{handler});
        DecoderException decoderException = new DecoderException("Unable to decode a message");
        this.channel.pipeline().fireExceptionCaught((Throwable)decoderException);
        ServiceUnavailableException error = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> TestUtil.await(handshakeCompletedPromise));
        Assertions.assertEquals((Object)decoderException, (Object)error.getCause());
        Assertions.assertNull(TestUtil.await(this.channel.closeFuture()));
    }

    @Test
    void shouldTranslateSSLHandshakeException() {
        ChannelPromise handshakeCompletedPromise = this.channel.newPromise();
        HandshakeHandler handler = HandshakeHandlerTest.newHandler(handshakeCompletedPromise);
        this.channel.pipeline().addLast(new ChannelHandler[]{handler});
        SSLHandshakeException error = new SSLHandshakeException("Invalid certificate");
        this.channel.pipeline().fireExceptionCaught((Throwable)error);
        SecurityException e = (SecurityException)Assertions.assertThrows(SecurityException.class, () -> TestUtil.await(handshakeCompletedPromise));
        Assertions.assertEquals((Object)error, (Object)e.getCause());
        Assertions.assertNull(TestUtil.await(this.channel.closeFuture()));
    }

    @ParameterizedTest
    @MethodSource(value={"protocolVersions"})
    public void testProtocolSelection(BoltProtocolVersion protocolVersion, Class<? extends MessageFormat> expectedMessageFormatClass) {
        ChannelPromise handshakeCompletedPromise = this.channel.newPromise();
        MemorizingChannelPipelineBuilder pipelineBuilder = new MemorizingChannelPipelineBuilder();
        HandshakeHandler handler = HandshakeHandlerTest.newHandler((ChannelPipelineBuilder)pipelineBuilder, handshakeCompletedPromise);
        this.channel.pipeline().addLast(new ChannelHandler[]{handler});
        this.channel.pipeline().fireChannelRead((Object)Unpooled.copyInt((int)protocolVersion.toInt()));
        MatcherAssert.assertThat((Object)pipelineBuilder.usedMessageFormat, (Matcher)Matchers.instanceOf(expectedMessageFormatClass));
        Assertions.assertNull((Object)this.channel.pipeline().get(HandshakeHandler.class));
        Assertions.assertNotNull((Object)this.channel.pipeline().get(ChunkDecoder.class));
        Assertions.assertNotNull((Object)this.channel.pipeline().get(MessageDecoder.class));
        Assertions.assertNotNull((Object)this.channel.pipeline().get(InboundMessageHandler.class));
        Assertions.assertNotNull((Object)this.channel.pipeline().get(OutboundMessageHandler.class));
        Assertions.assertNull(TestUtil.await(handshakeCompletedPromise));
    }

    @Test
    void shouldFailGivenPromiseWhenServerSuggestsNoProtocol() {
        this.testFailure(BoltProtocolUtil.NO_PROTOCOL_VERSION, "The server does not support any of the protocol versions");
    }

    @Test
    void shouldFailGivenPromiseWhenServerSuggestsHttp() {
        this.testFailure(new BoltProtocolVersion(80, 84), "Server responded HTTP");
    }

    @Test
    void shouldFailGivenPromiseWhenServerSuggestsUnknownProtocol() {
        this.testFailure(new BoltProtocolVersion(42, 0), "Protocol error");
    }

    @Test
    void shouldFailGivenPromiseWhenChannelInactive() {
        ChannelPromise handshakeCompletedPromise = this.channel.newPromise();
        HandshakeHandler handler = HandshakeHandlerTest.newHandler(handshakeCompletedPromise);
        this.channel.pipeline().addLast(new ChannelHandler[]{handler});
        this.channel.pipeline().fireChannelInactive();
        ServiceUnavailableException error = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> TestUtil.await(handshakeCompletedPromise));
        Assertions.assertEquals((Object)ErrorUtil.newConnectionTerminatedError().getMessage(), (Object)error.getMessage());
        Assertions.assertNull(TestUtil.await(this.channel.closeFuture()));
    }

    private void testFailure(BoltProtocolVersion serverSuggestedVersion, String expectedMessagePrefix) {
        ChannelPromise handshakeCompletedPromise = this.channel.newPromise();
        HandshakeHandler handler = HandshakeHandlerTest.newHandler(handshakeCompletedPromise);
        this.channel.pipeline().addLast(new ChannelHandler[]{handler});
        this.channel.pipeline().fireChannelRead((Object)Unpooled.copyInt((int)serverSuggestedVersion.toInt()));
        Assertions.assertNull((Object)this.channel.pipeline().get(HandshakeHandler.class));
        Exception error = (Exception)Assertions.assertThrows(Exception.class, () -> TestUtil.await(handshakeCompletedPromise));
        MatcherAssert.assertThat((Object)error, (Matcher)Matchers.instanceOf(ClientException.class));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.startsWith((String)expectedMessagePrefix));
        Assertions.assertNull(TestUtil.await(this.channel.closeFuture()));
    }

    private static Stream<Arguments> protocolVersions() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{BoltProtocolV3.VERSION, MessageFormatV3.class}), Arguments.arguments((Object[])new Object[]{BoltProtocolV4.VERSION, MessageFormatV4.class}), Arguments.arguments((Object[])new Object[]{BoltProtocolV41.VERSION, MessageFormatV4.class}), Arguments.arguments((Object[])new Object[]{BoltProtocolV42.VERSION, MessageFormatV4.class}));
    }

    private static HandshakeHandler newHandler(ChannelPromise handshakeCompletedPromise) {
        return HandshakeHandlerTest.newHandler((ChannelPipelineBuilder)new ChannelPipelineBuilderImpl(), handshakeCompletedPromise);
    }

    private static HandshakeHandler newHandler(ChannelPipelineBuilder pipelineBuilder, ChannelPromise handshakeCompletedPromise) {
        return new HandshakeHandler(pipelineBuilder, handshakeCompletedPromise, DevNullLogging.DEV_NULL_LOGGING);
    }

    private static class MemorizingChannelPipelineBuilder
    extends ChannelPipelineBuilderImpl {
        MessageFormat usedMessageFormat;

        private MemorizingChannelPipelineBuilder() {
        }

        public void build(MessageFormat messageFormat, ChannelPipeline pipeline, Logging logging) {
            this.usedMessageFormat = messageFormat;
            super.build(messageFormat, pipeline, logging);
        }
    }
}

