/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.async.connection.RoutingConnection;
import org.neo4j.driver.internal.handlers.RoutingResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.request.DiscardAllMessage;
import org.neo4j.driver.internal.messaging.request.PullAllMessage;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;

class RoutingConnectionTest {
    RoutingConnectionTest() {
    }

    @Test
    void shouldWrapHandlersWhenWritingSingleMessage() {
        RoutingConnectionTest.testHandlersWrappingWithSingleMessage(false);
    }

    @Test
    void shouldWrapHandlersWhenWritingAndFlushingSingleMessage() {
        RoutingConnectionTest.testHandlersWrappingWithSingleMessage(true);
    }

    @Test
    void shouldWrapHandlersWhenWritingMultipleMessages() {
        RoutingConnectionTest.testHandlersWrappingWithMultipleMessages(false);
    }

    @Test
    void shouldWrapHandlersWhenWritingAndFlushingMultipleMessages() {
        RoutingConnectionTest.testHandlersWrappingWithMultipleMessages(true);
    }

    @Test
    void shouldReturnServerAgent() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RoutingErrorHandler errorHandler = (RoutingErrorHandler)Mockito.mock(RoutingErrorHandler.class);
        RoutingConnection routingConnection = new RoutingConnection(connection, DatabaseNameUtil.defaultDatabase(), AccessMode.READ, null, errorHandler);
        String agent = "Neo4j/4.2.5";
        BDDMockito.given((Object)connection.serverAgent()).willReturn((Object)agent);
        String actualAgent = routingConnection.serverAgent();
        Assertions.assertEquals((Object)agent, (Object)actualAgent);
        ((Connection)BDDMockito.then((Object)connection).should()).serverAgent();
    }

    private static void testHandlersWrappingWithSingleMessage(boolean flush) {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RoutingErrorHandler errorHandler = (RoutingErrorHandler)Mockito.mock(RoutingErrorHandler.class);
        RoutingConnection routingConnection = new RoutingConnection(connection, DatabaseNameUtil.defaultDatabase(), AccessMode.READ, null, errorHandler);
        if (flush) {
            routingConnection.writeAndFlush((Message)PullAllMessage.PULL_ALL, (ResponseHandler)Mockito.mock(ResponseHandler.class));
        } else {
            routingConnection.write((Message)PullAllMessage.PULL_ALL, (ResponseHandler)Mockito.mock(ResponseHandler.class));
        }
        ArgumentCaptor handlerCaptor = ArgumentCaptor.forClass(ResponseHandler.class);
        if (flush) {
            ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)Mockito.eq((Object)PullAllMessage.PULL_ALL), (ResponseHandler)handlerCaptor.capture());
        } else {
            ((Connection)Mockito.verify((Object)connection)).write((Message)Mockito.eq((Object)PullAllMessage.PULL_ALL), (ResponseHandler)handlerCaptor.capture());
        }
        MatcherAssert.assertThat((Object)((ResponseHandler)handlerCaptor.getValue()), (Matcher)Matchers.instanceOf(RoutingResponseHandler.class));
    }

    private static void testHandlersWrappingWithMultipleMessages(boolean flush) {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        RoutingErrorHandler errorHandler = (RoutingErrorHandler)Mockito.mock(RoutingErrorHandler.class);
        RoutingConnection routingConnection = new RoutingConnection(connection, DatabaseNameUtil.defaultDatabase(), AccessMode.READ, null, errorHandler);
        if (flush) {
            routingConnection.writeAndFlush((Message)PullAllMessage.PULL_ALL, (ResponseHandler)Mockito.mock(ResponseHandler.class), (Message)DiscardAllMessage.DISCARD_ALL, (ResponseHandler)Mockito.mock(ResponseHandler.class));
        } else {
            routingConnection.write((Message)PullAllMessage.PULL_ALL, (ResponseHandler)Mockito.mock(ResponseHandler.class), (Message)DiscardAllMessage.DISCARD_ALL, (ResponseHandler)Mockito.mock(ResponseHandler.class));
        }
        ArgumentCaptor handlerCaptor1 = ArgumentCaptor.forClass(ResponseHandler.class);
        ArgumentCaptor handlerCaptor2 = ArgumentCaptor.forClass(ResponseHandler.class);
        if (flush) {
            ((Connection)Mockito.verify((Object)connection)).writeAndFlush((Message)Mockito.eq((Object)PullAllMessage.PULL_ALL), (ResponseHandler)handlerCaptor1.capture(), (Message)Mockito.eq((Object)DiscardAllMessage.DISCARD_ALL), (ResponseHandler)handlerCaptor2.capture());
        } else {
            ((Connection)Mockito.verify((Object)connection)).write((Message)Mockito.eq((Object)PullAllMessage.PULL_ALL), (ResponseHandler)handlerCaptor1.capture(), (Message)Mockito.eq((Object)DiscardAllMessage.DISCARD_ALL), (ResponseHandler)handlerCaptor2.capture());
        }
        MatcherAssert.assertThat((Object)((ResponseHandler)handlerCaptor1.getValue()), (Matcher)Matchers.instanceOf(RoutingResponseHandler.class));
        MatcherAssert.assertThat((Object)((ResponseHandler)handlerCaptor2.getValue()), (Matcher)Matchers.instanceOf(RoutingResponseHandler.class));
    }
}

