/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.neo4j.driver.exceptions.ConnectionReadTimeoutException;
import org.neo4j.driver.internal.async.inbound.ConnectionReadTimeoutHandler;

public class ConnectionReadTimeoutHandlerTest {
    ConnectionReadTimeoutHandler handler = new ConnectionReadTimeoutHandler(15L, TimeUnit.SECONDS);
    ChannelHandlerContext context = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);

    @Test
    void shouldFireConnectionReadTimeoutExceptionAndCloseChannelOnReadTimeOutOnce() {
        IntStream.range(0, 10).forEach(i -> this.handler.readTimedOut(this.context));
        ((ChannelHandlerContext)BDDMockito.then((Object)this.context).should(BDDMockito.times((int)1))).fireExceptionCaught((Throwable)BDDMockito.any(ConnectionReadTimeoutException.class));
        ((ChannelHandlerContext)BDDMockito.then((Object)this.context).should(BDDMockito.times((int)1))).close();
    }
}

