/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import io.netty.bootstrap.Bootstrap;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.ConnectionSettings;
import org.neo4j.driver.internal.DefaultDomainNameResolver;
import org.neo4j.driver.internal.DomainNameResolver;
import org.neo4j.driver.internal.async.connection.BootstrapFactory;
import org.neo4j.driver.internal.async.connection.ChannelConnector;
import org.neo4j.driver.internal.async.connection.ChannelConnectorImpl;
import org.neo4j.driver.internal.async.pool.ConnectionPoolImpl;
import org.neo4j.driver.internal.async.pool.ExtendedChannelPool;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.metrics.DevNullMetricsListener;
import org.neo4j.driver.internal.metrics.MetricsListener;
import org.neo4j.driver.internal.security.SecurityPlanImpl;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.FakeClock;
import org.neo4j.driver.util.DatabaseExtension;
import org.neo4j.driver.util.ParallelizableIT;
import org.neo4j.driver.util.TestUtil;

@ParallelizableIT
class ConnectionPoolImplIT {
    @RegisterExtension
    static final DatabaseExtension neo4j = new DatabaseExtension();
    private ConnectionPoolImpl pool;

    ConnectionPoolImplIT() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.pool = this.newPool();
    }

    @AfterEach
    void tearDown() {
        this.pool.close();
    }

    @Test
    void shouldAcquireConnectionWhenPoolIsEmpty() {
        Connection connection = (Connection)TestUtil.await(this.pool.acquire(neo4j.address()));
        Assertions.assertNotNull((Object)connection);
    }

    @Test
    void shouldAcquireIdleConnection() {
        Connection connection1 = (Connection)TestUtil.await(this.pool.acquire(neo4j.address()));
        TestUtil.await(connection1.release());
        Connection connection2 = (Connection)TestUtil.await(this.pool.acquire(neo4j.address()));
        Assertions.assertNotNull((Object)connection2);
    }

    @Test
    void shouldBeAbleToClosePoolInIOWorkerThread() throws Throwable {
        CompletionStage<Void> future = this.pool.acquire(neo4j.address()).thenCompose(Connection::release).whenComplete((ignored, error) -> this.pool.retainAll(Collections.emptySet()));
        TestUtil.await(future);
    }

    @Test
    void shouldFailToAcquireConnectionToWrongAddress() {
        ServiceUnavailableException e = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> TestUtil.await(this.pool.acquire(new BoltServerAddress("wrong-localhost"))));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Unable to connect"));
    }

    @Test
    void shouldFailToAcquireWhenPoolClosed() {
        Connection connection = (Connection)TestUtil.await(this.pool.acquire(neo4j.address()));
        TestUtil.await(connection.release());
        TestUtil.await(this.pool.close());
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.pool.acquire(neo4j.address()));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.startsWith((String)"Pool closed"));
    }

    @Test
    void shouldNotCloseWhenClosed() {
        Assertions.assertNull(TestUtil.await(this.pool.close()));
        Assertions.assertTrue((boolean)this.pool.close().toCompletableFuture().isDone());
    }

    @Test
    void shouldFailToAcquireConnectionWhenPoolIsClosed() {
        TestUtil.await(this.pool.acquire(neo4j.address()));
        ExtendedChannelPool channelPool = this.pool.getPool(neo4j.address());
        TestUtil.await(channelPool.close());
        ServiceUnavailableException error = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> TestUtil.await(this.pool.acquire(neo4j.address())));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"closed while acquiring a connection"));
        MatcherAssert.assertThat((Object)error.getCause(), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)error.getCause().getMessage(), (Matcher)Matchers.containsString((String)"FixedChannelPool was closed"));
    }

    private ConnectionPoolImpl newPool() throws Exception {
        FakeClock clock = new FakeClock();
        ConnectionSettings connectionSettings = new ConnectionSettings(neo4j.authToken(), "test", 5000);
        ChannelConnectorImpl connector = new ChannelConnectorImpl(connectionSettings, SecurityPlanImpl.insecure(), DevNullLogging.DEV_NULL_LOGGING, (Clock)clock, RoutingContext.EMPTY, (DomainNameResolver)DefaultDomainNameResolver.getInstance());
        PoolSettings poolSettings = ConnectionPoolImplIT.newSettings();
        Bootstrap bootstrap = BootstrapFactory.newBootstrap((int)1);
        return new ConnectionPoolImpl((ChannelConnector)connector, bootstrap, poolSettings, (MetricsListener)DevNullMetricsListener.INSTANCE, DevNullLogging.DEV_NULL_LOGGING, (Clock)clock, true);
    }

    private static PoolSettings newSettings() {
        return new PoolSettings(10, 5000L, -1L, -1L);
    }
}

