/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.concurrent.Future;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.async.pool.NettyChannelHealthChecker;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.messaging.request.ResetMessage;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.util.TestUtil;

class NettyChannelHealthCheckerTest {
    private final EmbeddedChannel channel = new EmbeddedChannel();
    private final InboundMessageDispatcher dispatcher = new InboundMessageDispatcher((Channel)this.channel, DevNullLogging.DEV_NULL_LOGGING);

    NettyChannelHealthCheckerTest() {
    }

    @BeforeEach
    void setUp() {
        ChannelAttributes.setMessageDispatcher((Channel)this.channel, (InboundMessageDispatcher)this.dispatcher);
    }

    @AfterEach
    void tearDown() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    void shouldDropTooOldChannelsWhenMaxLifetimeEnabled() {
        int maxLifetime = 1000;
        PoolSettings settings = new PoolSettings(100, PoolSettings.DEFAULT_CONNECTION_ACQUISITION_TIMEOUT, (long)maxLifetime, -1L);
        Clock clock = Clock.SYSTEM;
        NettyChannelHealthChecker healthChecker = this.newHealthChecker(settings, clock);
        ChannelAttributes.setCreationTimestamp((Channel)this.channel, (long)(clock.millis() - (long)(maxLifetime * 2)));
        Future healthy = healthChecker.isHealthy((Channel)this.channel);
        MatcherAssert.assertThat((Object)((Boolean)TestUtil.await(healthy)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    void shouldAllowVeryOldChannelsWhenMaxLifetimeDisabled() {
        PoolSettings settings = new PoolSettings(100, PoolSettings.DEFAULT_CONNECTION_ACQUISITION_TIMEOUT, -1L, -1L);
        NettyChannelHealthChecker healthChecker = this.newHealthChecker(settings, Clock.SYSTEM);
        ChannelAttributes.setCreationTimestamp((Channel)this.channel, (long)0L);
        Future healthy = healthChecker.isHealthy((Channel)this.channel);
        MatcherAssert.assertThat((Object)((Boolean)TestUtil.await(healthy)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void shouldFailAllConnectionsCreatedOnOrBeforeExpirationTimestamp() {
        PoolSettings settings = new PoolSettings(100, PoolSettings.DEFAULT_CONNECTION_ACQUISITION_TIMEOUT, -1L, -1L);
        Clock clock = Clock.SYSTEM;
        NettyChannelHealthChecker healthChecker = this.newHealthChecker(settings, clock);
        long initialTimestamp = clock.millis();
        List channels = IntStream.range(0, 100).mapToObj(i -> {
            EmbeddedChannel channel = new EmbeddedChannel();
            ChannelAttributes.setCreationTimestamp((Channel)channel, (long)(initialTimestamp + (long)i));
            return channel;
        }).collect(Collectors.toList());
        int authorizationExpiredChannelIndex = channels.size() / 2 - 1;
        healthChecker.onExpired(new AuthorizationExpiredException("", ""), (Channel)channels.get(authorizationExpiredChannelIndex));
        for (int i2 = 0; i2 < channels.size(); ++i2) {
            Channel channel = (Channel)channels.get(i2);
            boolean health = Objects.requireNonNull((Boolean)TestUtil.await(healthChecker.isHealthy(channel)));
            boolean expectedHealth = i2 > authorizationExpiredChannelIndex;
            Assertions.assertEquals((Object)expectedHealth, (Object)health, (String)String.format("Channel %d has failed the check", i2));
        }
    }

    @Test
    void shouldUseGreatestExpirationTimestamp() {
        PoolSettings settings = new PoolSettings(100, PoolSettings.DEFAULT_CONNECTION_ACQUISITION_TIMEOUT, -1L, -1L);
        Clock clock = Clock.SYSTEM;
        NettyChannelHealthChecker healthChecker = this.newHealthChecker(settings, clock);
        long initialTimestamp = clock.millis();
        EmbeddedChannel channel1 = new EmbeddedChannel();
        EmbeddedChannel channel2 = new EmbeddedChannel();
        ChannelAttributes.setCreationTimestamp((Channel)channel1, (long)initialTimestamp);
        ChannelAttributes.setCreationTimestamp((Channel)channel2, (long)(initialTimestamp + 100L));
        healthChecker.onExpired(new AuthorizationExpiredException("", ""), (Channel)channel2);
        healthChecker.onExpired(new AuthorizationExpiredException("", ""), (Channel)channel1);
        Assertions.assertFalse((boolean)Objects.requireNonNull((Boolean)TestUtil.await(healthChecker.isHealthy((Channel)channel1))));
        Assertions.assertFalse((boolean)Objects.requireNonNull((Boolean)TestUtil.await(healthChecker.isHealthy((Channel)channel2))));
    }

    @Test
    void shouldKeepIdleConnectionWhenPingSucceeds() {
        this.testPing(true);
    }

    @Test
    void shouldDropIdleConnectionWhenPingFails() {
        this.testPing(false);
    }

    @Test
    void shouldKeepActiveConnections() {
        this.testActiveConnectionCheck(true);
    }

    @Test
    void shouldDropInactiveConnections() {
        this.testActiveConnectionCheck(false);
    }

    private void testPing(boolean resetMessageSuccessful) {
        int idleTimeBeforeConnectionTest = 1000;
        PoolSettings settings = new PoolSettings(100, PoolSettings.DEFAULT_CONNECTION_ACQUISITION_TIMEOUT, -1L, (long)idleTimeBeforeConnectionTest);
        Clock clock = Clock.SYSTEM;
        NettyChannelHealthChecker healthChecker = this.newHealthChecker(settings, clock);
        ChannelAttributes.setCreationTimestamp((Channel)this.channel, (long)clock.millis());
        ChannelAttributes.setLastUsedTimestamp((Channel)this.channel, (long)(clock.millis() - (long)(idleTimeBeforeConnectionTest * 2)));
        Future healthy = healthChecker.isHealthy((Channel)this.channel);
        Assertions.assertEquals((Object)ResetMessage.RESET, (Object)Iterables.single((Iterable)this.channel.outboundMessages()));
        Assertions.assertFalse((boolean)healthy.isDone());
        if (resetMessageSuccessful) {
            this.dispatcher.handleSuccessMessage(Collections.emptyMap());
            MatcherAssert.assertThat((Object)((Boolean)TestUtil.await(healthy)), (Matcher)Matchers.is((Object)true));
        } else {
            this.dispatcher.handleFailureMessage("Neo.ClientError.General.Unknown", "Error!");
            MatcherAssert.assertThat((Object)((Boolean)TestUtil.await(healthy)), (Matcher)Matchers.is((Object)false));
        }
    }

    private void testActiveConnectionCheck(boolean channelActive) {
        PoolSettings settings = new PoolSettings(100, PoolSettings.DEFAULT_CONNECTION_ACQUISITION_TIMEOUT, -1L, -1L);
        Clock clock = Clock.SYSTEM;
        NettyChannelHealthChecker healthChecker = this.newHealthChecker(settings, clock);
        ChannelAttributes.setCreationTimestamp((Channel)this.channel, (long)clock.millis());
        if (channelActive) {
            Future healthy = healthChecker.isHealthy((Channel)this.channel);
            MatcherAssert.assertThat((Object)((Boolean)TestUtil.await(healthy)), (Matcher)Matchers.is((Object)true));
        } else {
            this.channel.close().syncUninterruptibly();
            Future healthy = healthChecker.isHealthy((Channel)this.channel);
            MatcherAssert.assertThat((Object)((Boolean)TestUtil.await(healthy)), (Matcher)Matchers.is((Object)false));
        }
    }

    private NettyChannelHealthChecker newHealthChecker(PoolSettings settings, Clock clock) {
        return new NettyChannelHealthChecker(settings, clock, DevNullLogging.DEV_NULL_LOGGING);
    }
}

