/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.async.pool.PoolSettings;

class PoolSettingsTest {
    PoolSettingsTest() {
    }

    @Test
    void idleTimeBeforeConnectionTestWhenConfigured() {
        PoolSettings settings = new PoolSettings(5, -1L, 10L, 42L);
        Assertions.assertTrue((boolean)settings.idleTimeBeforeConnectionTestEnabled());
        Assertions.assertEquals((long)42L, (long)settings.idleTimeBeforeConnectionTest());
    }

    @Test
    void idleTimeBeforeConnectionTestWhenSetToZero() {
        PoolSettings settings = new PoolSettings(5, -1L, 10L, 0L);
        Assertions.assertTrue((boolean)settings.idleTimeBeforeConnectionTestEnabled());
        Assertions.assertEquals((long)0L, (long)settings.idleTimeBeforeConnectionTest());
    }

    @Test
    void idleTimeBeforeConnectionTestWhenSetToNegativeValue() {
        PoolSettingsTest.testIdleTimeBeforeConnectionTestWithIllegalValue(-1);
        PoolSettingsTest.testIdleTimeBeforeConnectionTestWithIllegalValue(-42);
        PoolSettingsTest.testIdleTimeBeforeConnectionTestWithIllegalValue(Integer.MIN_VALUE);
    }

    @Test
    void maxConnectionLifetimeWhenConfigured() {
        PoolSettings settings = new PoolSettings(5, -1L, 42L, 10L);
        Assertions.assertTrue((boolean)settings.maxConnectionLifetimeEnabled());
        Assertions.assertEquals((long)42L, (long)settings.maxConnectionLifetime());
    }

    @Test
    void maxConnectionLifetimeWhenSetToZeroOrNegativeValue() {
        PoolSettingsTest.testMaxConnectionLifetimeWithIllegalValue(0);
        PoolSettingsTest.testMaxConnectionLifetimeWithIllegalValue(-1);
        PoolSettingsTest.testMaxConnectionLifetimeWithIllegalValue(-42);
        PoolSettingsTest.testMaxConnectionLifetimeWithIllegalValue(Integer.MIN_VALUE);
    }

    private static void testIdleTimeBeforeConnectionTestWithIllegalValue(int value) {
        PoolSettings settings = new PoolSettings(5, -1L, 10L, (long)value);
        Assertions.assertFalse((boolean)settings.idleTimeBeforeConnectionTestEnabled());
    }

    private static void testMaxConnectionLifetimeWithIllegalValue(int value) {
        PoolSettings settings = new PoolSettings(5, -1L, (long)value, 10L);
        Assertions.assertFalse((boolean)settings.maxConnectionLifetimeEnabled());
    }
}

