/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster.loadbalancing;

import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.cluster.loadbalancing.LeastConnectedLoadBalancingStrategy;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.ClusterCompositionUtil;
import org.neo4j.driver.net.ServerAddress;

class LeastConnectedLoadBalancingStrategyTest {
    @Mock
    private ConnectionPool connectionPool;
    private LeastConnectedLoadBalancingStrategy strategy;

    LeastConnectedLoadBalancingStrategyTest() {
    }

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        this.strategy = new LeastConnectedLoadBalancingStrategy(this.connectionPool, DevNullLogging.DEV_NULL_LOGGING);
    }

    @Test
    void shouldHandleEmptyReaders() {
        Assertions.assertNull((Object)this.strategy.selectReader(Collections.emptyList()));
    }

    @Test
    void shouldHandleEmptyWriters() {
        Assertions.assertNull((Object)this.strategy.selectWriter(Collections.emptyList()));
    }

    @Test
    void shouldHandleSingleReaderWithoutActiveConnections() {
        BoltServerAddress address = new BoltServerAddress("reader", 9999);
        Assertions.assertEquals((Object)address, (Object)this.strategy.selectReader(Collections.singletonList(address)));
    }

    @Test
    void shouldHandleSingleWriterWithoutActiveConnections() {
        BoltServerAddress address = new BoltServerAddress("writer", 9999);
        Assertions.assertEquals((Object)address, (Object)this.strategy.selectWriter(Collections.singletonList(address)));
    }

    @Test
    void shouldHandleSingleReaderWithActiveConnections() {
        BoltServerAddress address = new BoltServerAddress("reader", 9999);
        Mockito.when((Object)this.connectionPool.inUseConnections((ServerAddress)address)).thenReturn((Object)42);
        Assertions.assertEquals((Object)address, (Object)this.strategy.selectReader(Collections.singletonList(address)));
    }

    @Test
    void shouldHandleSingleWriterWithActiveConnections() {
        BoltServerAddress address = new BoltServerAddress("writer", 9999);
        Mockito.when((Object)this.connectionPool.inUseConnections((ServerAddress)address)).thenReturn((Object)24);
        Assertions.assertEquals((Object)address, (Object)this.strategy.selectWriter(Collections.singletonList(address)));
    }

    @Test
    void shouldHandleMultipleReadersWithActiveConnections() {
        BoltServerAddress address1 = new BoltServerAddress("reader", 1);
        BoltServerAddress address2 = new BoltServerAddress("reader", 2);
        BoltServerAddress address3 = new BoltServerAddress("reader", 3);
        Mockito.when((Object)this.connectionPool.inUseConnections((ServerAddress)address1)).thenReturn((Object)3);
        Mockito.when((Object)this.connectionPool.inUseConnections((ServerAddress)address2)).thenReturn((Object)4);
        Mockito.when((Object)this.connectionPool.inUseConnections((ServerAddress)address3)).thenReturn((Object)1);
        Assertions.assertEquals((Object)address3, (Object)this.strategy.selectReader(Arrays.asList(address1, address2, address3)));
    }

    @Test
    void shouldHandleMultipleWritersWithActiveConnections() {
        BoltServerAddress address1 = new BoltServerAddress("writer", 1);
        BoltServerAddress address2 = new BoltServerAddress("writer", 2);
        BoltServerAddress address3 = new BoltServerAddress("writer", 3);
        BoltServerAddress address4 = new BoltServerAddress("writer", 4);
        Mockito.when((Object)this.connectionPool.inUseConnections((ServerAddress)address1)).thenReturn((Object)5);
        Mockito.when((Object)this.connectionPool.inUseConnections((ServerAddress)address2)).thenReturn((Object)6);
        Mockito.when((Object)this.connectionPool.inUseConnections((ServerAddress)address3)).thenReturn((Object)0);
        Mockito.when((Object)this.connectionPool.inUseConnections((ServerAddress)address4)).thenReturn((Object)1);
        Assertions.assertEquals((Object)address3, (Object)this.strategy.selectWriter(Arrays.asList(address1, address2, address3, address4)));
    }

    @Test
    void shouldReturnDifferentReaderOnEveryInvocationWhenNoActiveConnections() {
        BoltServerAddress address1 = new BoltServerAddress("reader", 1);
        BoltServerAddress address2 = new BoltServerAddress("reader", 2);
        BoltServerAddress address3 = new BoltServerAddress("reader", 3);
        Assertions.assertEquals((Object)address1, (Object)this.strategy.selectReader(Arrays.asList(address1, address2, address3)));
        Assertions.assertEquals((Object)address2, (Object)this.strategy.selectReader(Arrays.asList(address1, address2, address3)));
        Assertions.assertEquals((Object)address3, (Object)this.strategy.selectReader(Arrays.asList(address1, address2, address3)));
        Assertions.assertEquals((Object)address1, (Object)this.strategy.selectReader(Arrays.asList(address1, address2, address3)));
        Assertions.assertEquals((Object)address2, (Object)this.strategy.selectReader(Arrays.asList(address1, address2, address3)));
        Assertions.assertEquals((Object)address3, (Object)this.strategy.selectReader(Arrays.asList(address1, address2, address3)));
    }

    @Test
    void shouldReturnDifferentWriterOnEveryInvocationWhenNoActiveConnections() {
        BoltServerAddress address1 = new BoltServerAddress("writer", 1);
        BoltServerAddress address2 = new BoltServerAddress("writer", 2);
        Assertions.assertEquals((Object)address1, (Object)this.strategy.selectReader(Arrays.asList(address1, address2)));
        Assertions.assertEquals((Object)address2, (Object)this.strategy.selectReader(Arrays.asList(address1, address2)));
        Assertions.assertEquals((Object)address1, (Object)this.strategy.selectReader(Arrays.asList(address1, address2)));
        Assertions.assertEquals((Object)address2, (Object)this.strategy.selectReader(Arrays.asList(address1, address2)));
    }

    @Test
    void shouldTraceLogWhenNoAddressSelected() {
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        LeastConnectedLoadBalancingStrategy strategy = new LeastConnectedLoadBalancingStrategy(this.connectionPool, logging);
        strategy.selectReader(Collections.emptyList());
        strategy.selectWriter(Collections.emptyList());
        ((Logger)Mockito.verify((Object)logger)).trace(ArgumentMatchers.startsWith((String)"Unable to select"), new Object[]{ArgumentMatchers.eq((Object)"reader")});
        ((Logger)Mockito.verify((Object)logger)).trace(ArgumentMatchers.startsWith((String)"Unable to select"), new Object[]{ArgumentMatchers.eq((Object)"writer")});
    }

    @Test
    void shouldTraceLogSelectedAddress() {
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        Mockito.when((Object)this.connectionPool.inUseConnections((ServerAddress)ArgumentMatchers.any(BoltServerAddress.class))).thenReturn((Object)42);
        LeastConnectedLoadBalancingStrategy strategy = new LeastConnectedLoadBalancingStrategy(this.connectionPool, logging);
        strategy.selectReader(Collections.singletonList(ClusterCompositionUtil.A));
        strategy.selectWriter(Collections.singletonList(ClusterCompositionUtil.A));
        ((Logger)Mockito.verify((Object)logger)).trace(ArgumentMatchers.startsWith((String)"Selected"), new Object[]{ArgumentMatchers.eq((Object)"reader"), ArgumentMatchers.eq((Object)ClusterCompositionUtil.A), ArgumentMatchers.eq((int)42)});
        ((Logger)Mockito.verify((Object)logger)).trace(ArgumentMatchers.startsWith((String)"Selected"), new Object[]{ArgumentMatchers.eq((Object)"writer"), ArgumentMatchers.eq((Object)ClusterCompositionUtil.A), ArgumentMatchers.eq((int)42)});
    }
}

