/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.internal.cursor.AsyncResultCursor;
import org.neo4j.driver.internal.cursor.AsyncResultCursorOnlyFactory;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.AutoPullResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.util.TestUtil;

class AsyncResultCursorOnlyFactoryTest {
    AsyncResultCursorOnlyFactoryTest() {
    }

    @Test
    void shouldReturnAsyncResultWhenRunSucceeded() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        AsyncResultCursorOnlyFactory cursorFactory = this.newResultCursorFactory(connection, null);
        CompletionStage cursorFuture = cursorFactory.asyncResult();
        this.verifyRunCompleted(connection, cursorFuture);
    }

    @Test
    void shouldReturnAsyncResultWithRunErrorWhenRunFailed() {
        RuntimeException error = new RuntimeException("Hi there");
        AsyncResultCursorOnlyFactory cursorFactory = this.newResultCursorFactory(error);
        CompletionStage cursorFuture = cursorFactory.asyncResult();
        AsyncResultCursor cursor = (AsyncResultCursor)Futures.getNow((CompletionStage)cursorFuture);
        Throwable actual = Assertions.assertThrows(error.getClass(), () -> TestUtil.await(cursor.mapSuccessfulRunCompletionAsync()));
        Assertions.assertSame((Object)error, (Object)actual);
    }

    @Test
    void shouldPrePopulateRecords() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Message runMessage = (Message)Mockito.mock(Message.class);
        RunResponseHandler runHandler = (RunResponseHandler)Mockito.mock(RunResponseHandler.class);
        CompletableFuture runFuture = new CompletableFuture();
        PullAllResponseHandler pullAllHandler = (PullAllResponseHandler)Mockito.mock(PullAllResponseHandler.class);
        AsyncResultCursorOnlyFactory cursorFactory = new AsyncResultCursorOnlyFactory(connection, runMessage, runHandler, runFuture, pullAllHandler);
        cursorFactory.asyncResult();
        ((PullAllResponseHandler)Mockito.verify((Object)pullAllHandler)).prePopulateRecords();
    }

    @Test
    void shouldErrorForRxResult() {
        AsyncResultCursorOnlyFactory cursorFactory = this.newResultCursorFactory(null);
        CompletionStage rxCursorFuture = cursorFactory.rxResult();
        CompletionException error = (CompletionException)Assertions.assertThrows(CompletionException.class, () -> Futures.getNow((CompletionStage)rxCursorFuture));
        Assert.assertThat((Object)error.getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)"Driver is connected to the database that does not support driver reactive API"));
    }

    private AsyncResultCursorOnlyFactory newResultCursorFactory(Connection connection, Throwable runError) {
        Message runMessage = (Message)Mockito.mock(Message.class);
        RunResponseHandler runHandler = (RunResponseHandler)Mockito.mock(RunResponseHandler.class);
        CompletableFuture runFuture = new CompletableFuture();
        if (runError != null) {
            runFuture.completeExceptionally(runError);
        } else {
            runFuture.complete(null);
        }
        AutoPullResponseHandler pullHandler = (AutoPullResponseHandler)Mockito.mock(AutoPullResponseHandler.class);
        return new AsyncResultCursorOnlyFactory(connection, runMessage, runHandler, runFuture, (PullAllResponseHandler)pullHandler);
    }

    private AsyncResultCursorOnlyFactory newResultCursorFactory(Throwable runError) {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        return this.newResultCursorFactory(connection, runError);
    }

    private void verifyRunCompleted(Connection connection, CompletionStage<AsyncResultCursor> cursorFuture) {
        ((Connection)Mockito.verify((Object)connection)).write((Message)ArgumentMatchers.any(Message.class), (ResponseHandler)ArgumentMatchers.any(RunResponseHandler.class));
        Assert.assertThat((Object)((AsyncResultCursor)Futures.getNow(cursorFuture)), (Matcher)CoreMatchers.instanceOf(AsyncResultCursor.class));
    }
}

