/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.UntrustedServerException;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.ChannelErrorHandler;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.async.outbound.OutboundMessageHandler;
import org.neo4j.driver.internal.handlers.HelloResponseHandler;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v3.MessageFormatV3;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.messaging.v41.BoltProtocolV41;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.util.TestUtil;

class HelloResponseHandlerTest {
    private final EmbeddedChannel channel = new EmbeddedChannel();

    HelloResponseHandlerTest() {
    }

    @BeforeEach
    void setUp() {
        ChannelAttributes.setMessageDispatcher((Channel)this.channel, (InboundMessageDispatcher)new InboundMessageDispatcher((Channel)this.channel, DevNullLogging.DEV_NULL_LOGGING));
        ChannelPipeline pipeline = this.channel.pipeline();
        pipeline.addLast(OutboundMessageHandler.NAME, (ChannelHandler)new OutboundMessageHandler((MessageFormat)new MessageFormatV3(), DevNullLogging.DEV_NULL_LOGGING));
        pipeline.addLast(new ChannelHandler[]{new ChannelErrorHandler(DevNullLogging.DEV_NULL_LOGGING)});
    }

    @AfterEach
    void tearDown() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    void shouldSetServerVersionOnChannel() {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV3.VERSION);
        Map<String, Value> metadata = HelloResponseHandlerTest.metadata(TestUtil.anyServerVersion(), "bolt-1");
        handler.onSuccess(metadata);
        Assertions.assertTrue((boolean)channelPromise.isSuccess());
        Assertions.assertEquals((Object)TestUtil.anyServerVersion(), (Object)ChannelAttributes.serverVersion((Channel)this.channel));
    }

    @Test
    void shouldSetServerAgentOnChannel() {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV3.VERSION);
        String agent = "Neo4j/4.2.5";
        Map<String, Value> metadata = HelloResponseHandlerTest.metadata(agent, "bolt-1");
        handler.onSuccess(metadata);
        Assertions.assertTrue((boolean)channelPromise.isSuccess());
        Assertions.assertEquals((Object)agent, (Object)ChannelAttributes.serverAgent((Channel)this.channel));
    }

    @Test
    void shouldThrowWhenServerVersionNotReturned() {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV3.VERSION);
        Map<String, Value> metadata = HelloResponseHandlerTest.metadata(null, "bolt-1");
        Assertions.assertThrows(UntrustedServerException.class, () -> handler.onSuccess(metadata));
        Assertions.assertFalse((boolean)channelPromise.isSuccess());
        Assertions.assertTrue((boolean)this.channel.closeFuture().isDone());
    }

    @Test
    void shouldThrowWhenServerVersionIsNull() {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV3.VERSION);
        Map<String, Value> metadata = HelloResponseHandlerTest.metadata(Values.NULL, "bolt-x");
        Assertions.assertThrows(UntrustedServerException.class, () -> handler.onSuccess(metadata));
        Assertions.assertFalse((boolean)channelPromise.isSuccess());
        Assertions.assertTrue((boolean)this.channel.closeFuture().isDone());
    }

    @Test
    void shouldThrowWhenServerVersionCantBeParsed() {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV3.VERSION);
        Map<String, Value> metadata = HelloResponseHandlerTest.metadata("WrongServerVersion", "bolt-x");
        Assertions.assertThrows(IllegalArgumentException.class, () -> handler.onSuccess(metadata));
        Assertions.assertFalse((boolean)channelPromise.isSuccess());
        Assertions.assertTrue((boolean)this.channel.closeFuture().isDone());
    }

    @Test
    void shouldUseProtocolVersionForServerVersionWhenConnectedWithBoltV4() {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV4.VERSION);
        Map<String, Value> metadata = HelloResponseHandlerTest.metadata(ServerVersion.vInDev, "bolt-1");
        handler.onSuccess(metadata);
        Assertions.assertTrue((boolean)channelPromise.isSuccess());
        Assertions.assertEquals((Object)ServerVersion.v4_0_0, (Object)ChannelAttributes.serverVersion((Channel)this.channel));
    }

    @Test
    void shouldUseProtocolVersionForServerVersionWhenConnectedWithBoltV41() {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV41.VERSION);
        Map<String, Value> metadata = HelloResponseHandlerTest.metadata(ServerVersion.vInDev, "bolt-1");
        handler.onSuccess(metadata);
        Assertions.assertTrue((boolean)channelPromise.isSuccess());
        Assertions.assertEquals((Object)ServerVersion.v4_1_0, (Object)ChannelAttributes.serverVersion((Channel)this.channel));
    }

    @Test
    void shouldSetConnectionIdOnChannel() {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV3.VERSION);
        Map<String, Value> metadata = HelloResponseHandlerTest.metadata(TestUtil.anyServerVersion(), "bolt-42");
        handler.onSuccess(metadata);
        Assertions.assertTrue((boolean)channelPromise.isSuccess());
        Assertions.assertEquals((Object)"bolt-42", (Object)ChannelAttributes.connectionId((Channel)this.channel));
    }

    @Test
    void shouldThrowWhenConnectionIdNotReturned() {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV3.VERSION);
        Map<String, Value> metadata = HelloResponseHandlerTest.metadata(TestUtil.anyServerVersion(), null);
        Assertions.assertThrows(IllegalStateException.class, () -> handler.onSuccess(metadata));
        Assertions.assertFalse((boolean)channelPromise.isSuccess());
        Assertions.assertTrue((boolean)this.channel.closeFuture().isDone());
    }

    @Test
    void shouldThrowWhenConnectionIdIsNull() {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV3.VERSION);
        Map<String, Value> metadata = HelloResponseHandlerTest.metadata(TestUtil.anyServerVersion(), Values.NULL);
        Assertions.assertThrows(IllegalStateException.class, () -> handler.onSuccess(metadata));
        Assertions.assertFalse((boolean)channelPromise.isSuccess());
        Assertions.assertTrue((boolean)this.channel.closeFuture().isDone());
    }

    @Test
    void shouldCloseChannelOnFailure() throws Exception {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV3.VERSION);
        RuntimeException error = new RuntimeException("Hi!");
        handler.onFailure((Throwable)error);
        ChannelFuture channelCloseFuture = this.channel.closeFuture();
        channelCloseFuture.await(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)channelCloseFuture.isSuccess());
        Assertions.assertTrue((boolean)channelPromise.isDone());
        Assertions.assertEquals((Object)error, (Object)channelPromise.cause());
    }

    @Test
    void shouldNotThrowWhenConfigurationHintsAreAbsent() {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV41.VERSION);
        Map<String, Value> metadata = HelloResponseHandlerTest.metadata(TestUtil.anyServerVersion(), "bolt-x");
        handler.onSuccess(metadata);
        Assertions.assertTrue((boolean)channelPromise.isSuccess());
        Assertions.assertFalse((boolean)this.channel.closeFuture().isDone());
    }

    @Test
    void shouldNotThrowWhenConfigurationHintsAreEmpty() {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV41.VERSION);
        Map<String, Value> metadata = HelloResponseHandlerTest.metadata(TestUtil.anyServerVersion(), "bolt-x", Values.value(new HashMap()));
        handler.onSuccess(metadata);
        Assertions.assertTrue((boolean)channelPromise.isSuccess());
        Assertions.assertFalse((boolean)this.channel.closeFuture().isDone());
    }

    @Test
    void shouldNotThrowWhenConfigurationHintsAreNull() {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV41.VERSION);
        Map<String, Value> metadata = HelloResponseHandlerTest.metadata(TestUtil.anyServerVersion(), "bolt-x", Values.NULL);
        handler.onSuccess(metadata);
        Assertions.assertTrue((boolean)channelPromise.isSuccess());
        Assertions.assertFalse((boolean)this.channel.closeFuture().isDone());
    }

    @Test
    void shouldSetConnectionTimeoutHint() {
        ChannelPromise channelPromise = this.channel.newPromise();
        HelloResponseHandler handler = new HelloResponseHandler(channelPromise, BoltProtocolV41.VERSION);
        long timeout = 15L;
        HashMap<String, Value> hints = new HashMap<String, Value>();
        hints.put("connection.recv_timeout_seconds", Values.value((long)timeout));
        Map<String, Value> metadata = HelloResponseHandlerTest.metadata(TestUtil.anyServerVersion(), "bolt-x", Values.value(hints));
        handler.onSuccess(metadata);
        Assertions.assertEquals((long)timeout, (Long)ChannelAttributes.connectionReadTimeout((Channel)this.channel).orElse(null));
        Assertions.assertTrue((boolean)channelPromise.isSuccess());
        Assertions.assertFalse((boolean)this.channel.closeFuture().isDone());
    }

    private static Map<String, Value> metadata(Object version, Object connectionId) {
        return HelloResponseHandlerTest.metadata(version, connectionId, null);
    }

    private static Map<String, Value> metadata(Object version, Object connectionId, Value hints) {
        HashMap<String, Value> result = new HashMap<String, Value>();
        if (version == null) {
            result.put("server", null);
        } else if (version instanceof Value && ((Value)version).isNull()) {
            result.put("server", Values.NULL);
        } else {
            result.put("server", Values.value((String)version.toString()));
        }
        if (connectionId == null) {
            result.put("connection_id", null);
        } else {
            result.put("connection_id", Values.value((Object)connectionId));
        }
        result.put("hints", hints);
        return result;
    }
}

