/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import io.netty.channel.Channel;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.handlers.PingResponseHandler;
import org.neo4j.driver.internal.logging.DevNullLogging;

class PingResponseHandlerTest {
    PingResponseHandlerTest() {
    }

    @Test
    void shouldResolvePromiseOnSuccess() {
        Promise<Boolean> promise = PingResponseHandlerTest.newPromise();
        PingResponseHandler handler = PingResponseHandlerTest.newHandler(promise);
        handler.onSuccess(Collections.emptyMap());
        Assertions.assertTrue((boolean)promise.isSuccess());
        Assertions.assertTrue((boolean)((Boolean)promise.getNow()));
    }

    @Test
    void shouldResolvePromiseOnFailure() {
        Promise<Boolean> promise = PingResponseHandlerTest.newPromise();
        PingResponseHandler handler = PingResponseHandlerTest.newHandler(promise);
        handler.onFailure((Throwable)new RuntimeException());
        Assertions.assertTrue((boolean)promise.isSuccess());
        Assertions.assertFalse((boolean)((Boolean)promise.getNow()));
    }

    @Test
    void shouldNotSupportRecordMessages() {
        PingResponseHandler handler = PingResponseHandlerTest.newHandler(PingResponseHandlerTest.newPromise());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> handler.onRecord(new Value[0]));
    }

    private static Promise<Boolean> newPromise() {
        return ImmediateEventExecutor.INSTANCE.newPromise();
    }

    private static PingResponseHandler newHandler(Promise<Boolean> result) {
        return new PingResponseHandler(result, (Channel)Mockito.mock(Channel.class), DevNullLogging.DEV_NULL_LOGGING);
    }
}

