/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.handlers.RouteMessageResponseHandler;

class RouteMessageResponseHandlerTest {
    RouteMessageResponseHandlerTest() {
    }

    @Test
    void onSuccessShouldSuccessFullyCompleteFutureWithRoutingTable() throws Exception {
        CompletableFuture<Object> completableFuture = new CompletableFuture<Object>();
        RouteMessageResponseHandler responseHandler = new RouteMessageResponseHandler(completableFuture);
        Map<String, Value> routingTable = this.getRoutingTable();
        Map<String, Value> metadata = this.getMetadataWithRoutingTable(routingTable);
        responseHandler.onSuccess(metadata);
        Assertions.assertEquals(routingTable, completableFuture.getNow(null));
    }

    @Test
    void onSuccessShouldExceptionallyCompleteFutureWhenMetadataDoesNotHaveRoutingTable() throws Exception {
        CompletableFuture completableFuture = new CompletableFuture();
        RouteMessageResponseHandler responseHandler = new RouteMessageResponseHandler(completableFuture);
        HashMap metadata = new HashMap();
        responseHandler.onSuccess(metadata);
        Assertions.assertThrows(CompletionException.class, () -> completableFuture.getNow(null));
    }

    @Test
    void onFailureShouldCompleteExceptionallyWithTheOriginalException() {
        CompletableFuture completableFuture = new CompletableFuture();
        RouteMessageResponseHandler responseHandler = new RouteMessageResponseHandler(completableFuture);
        RuntimeException expectedException = new RuntimeException("Test exception");
        responseHandler.onFailure((Throwable)expectedException);
        Assertions.assertTrue((boolean)completableFuture.isCompletedExceptionally());
        completableFuture.handle((value, ex) -> {
            Assertions.assertNull((Object)value);
            Assertions.assertEquals((Object)expectedException, (Object)ex);
            return null;
        });
    }

    @Test
    void onRecordShouldThrowUnsupportedOperation() {
        CompletableFuture completableFuture = new CompletableFuture();
        RouteMessageResponseHandler responseHandler = new RouteMessageResponseHandler(completableFuture);
        responseHandler.onRecord(new Value[0]);
        Assertions.assertTrue((boolean)completableFuture.isCompletedExceptionally());
        completableFuture.handle((value, ex) -> {
            Assertions.assertNull((Object)value);
            Assertions.assertEquals(UnsupportedOperationException.class, ex.getClass());
            return null;
        });
    }

    private Map<String, Value> getMetadataWithRoutingTable(Map<String, Value> routingTable) {
        HashMap<String, Value> metadata = new HashMap<String, Value>();
        metadata.put("rt", Values.value(routingTable));
        return metadata;
    }

    private Map<String, Value> getRoutingTable() {
        HashMap<String, Value> routingTable = new HashMap<String, Value>();
        routingTable.put("ttl", Values.value((int)300));
        routingTable.put("addresses", Values.value(new ArrayList()));
        return routingTable;
    }
}

