/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.concurrent.CompletionException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.handlers.RoutingResponseHandler;
import org.neo4j.driver.internal.spi.ResponseHandler;

class RoutingResponseHandlerTest {
    RoutingResponseHandlerTest() {
    }

    @Test
    void shouldUnwrapCompletionException() {
        RuntimeException error = new RuntimeException("Hi");
        RoutingErrorHandler errorHandler = (RoutingErrorHandler)Mockito.mock(RoutingErrorHandler.class);
        Throwable handledError = RoutingResponseHandlerTest.handle(new CompletionException(error), errorHandler);
        Assertions.assertEquals((Object)error, (Object)handledError);
        Mockito.verifyNoInteractions((Object[])new Object[]{errorHandler});
    }

    @Test
    void shouldHandleServiceUnavailableException() {
        ServiceUnavailableException error = new ServiceUnavailableException("Hi");
        RoutingErrorHandler errorHandler = (RoutingErrorHandler)Mockito.mock(RoutingErrorHandler.class);
        Throwable handledError = RoutingResponseHandlerTest.handle(error, errorHandler);
        MatcherAssert.assertThat((Object)handledError, (Matcher)Matchers.instanceOf(SessionExpiredException.class));
        ((RoutingErrorHandler)Mockito.verify((Object)errorHandler)).onConnectionFailure(BoltServerAddress.LOCAL_DEFAULT);
    }

    @Test
    void shouldHandleDatabaseUnavailableError() {
        TransientException error = new TransientException("Neo.TransientError.General.DatabaseUnavailable", "Hi");
        RoutingErrorHandler errorHandler = (RoutingErrorHandler)Mockito.mock(RoutingErrorHandler.class);
        Throwable handledError = RoutingResponseHandlerTest.handle((Throwable)error, errorHandler);
        Assertions.assertEquals((Object)error, (Object)handledError);
        ((RoutingErrorHandler)Mockito.verify((Object)errorHandler)).onConnectionFailure(BoltServerAddress.LOCAL_DEFAULT);
    }

    @Test
    void shouldHandleTransientException() {
        TransientException error = new TransientException("Neo.TransientError.Transaction.DeadlockDetected", "Hi");
        RoutingErrorHandler errorHandler = (RoutingErrorHandler)Mockito.mock(RoutingErrorHandler.class);
        Throwable handledError = RoutingResponseHandlerTest.handle((Throwable)error, errorHandler);
        Assertions.assertEquals((Object)error, (Object)handledError);
        Mockito.verifyNoInteractions((Object[])new Object[]{errorHandler});
    }

    @Test
    void shouldHandleNotALeaderErrorWithReadAccessMode() {
        this.testWriteFailureWithReadAccessMode("Neo.ClientError.Cluster.NotALeader");
    }

    @Test
    void shouldHandleNotALeaderErrorWithWriteAccessMode() {
        this.testWriteFailureWithWriteAccessMode("Neo.ClientError.Cluster.NotALeader");
    }

    @Test
    void shouldHandleForbiddenOnReadOnlyDatabaseErrorWithReadAccessMode() {
        this.testWriteFailureWithReadAccessMode("Neo.ClientError.General.ForbiddenOnReadOnlyDatabase");
    }

    @Test
    void shouldHandleForbiddenOnReadOnlyDatabaseErrorWithWriteAccessMode() {
        this.testWriteFailureWithWriteAccessMode("Neo.ClientError.General.ForbiddenOnReadOnlyDatabase");
    }

    @Test
    void shouldHandleClientException() {
        ClientException error = new ClientException("Neo.ClientError.Request.Invalid", "Hi");
        RoutingErrorHandler errorHandler = (RoutingErrorHandler)Mockito.mock(RoutingErrorHandler.class);
        Throwable handledError = RoutingResponseHandlerTest.handle(error, errorHandler, AccessMode.READ);
        Assertions.assertEquals((Object)((Object)error), (Object)handledError);
        Mockito.verifyNoInteractions((Object[])new Object[]{errorHandler});
    }

    @Test
    public void shouldDelegateCanManageAutoRead() {
        ResponseHandler responseHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        RoutingResponseHandler routingResponseHandler = new RoutingResponseHandler(responseHandler, BoltServerAddress.LOCAL_DEFAULT, AccessMode.READ, null);
        routingResponseHandler.canManageAutoRead();
        ((ResponseHandler)Mockito.verify((Object)responseHandler)).canManageAutoRead();
    }

    @Test
    public void shouldDelegateDisableAutoReadManagement() {
        ResponseHandler responseHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        RoutingResponseHandler routingResponseHandler = new RoutingResponseHandler(responseHandler, BoltServerAddress.LOCAL_DEFAULT, AccessMode.READ, null);
        routingResponseHandler.disableAutoReadManagement();
        ((ResponseHandler)Mockito.verify((Object)responseHandler)).disableAutoReadManagement();
    }

    private void testWriteFailureWithReadAccessMode(String code) {
        ClientException error = new ClientException(code, "Hi");
        RoutingErrorHandler errorHandler = (RoutingErrorHandler)Mockito.mock(RoutingErrorHandler.class);
        Throwable handledError = RoutingResponseHandlerTest.handle(error, errorHandler, AccessMode.READ);
        MatcherAssert.assertThat((Object)handledError, (Matcher)Matchers.instanceOf(ClientException.class));
        Assertions.assertEquals((Object)"Write queries cannot be performed in READ access mode.", (Object)handledError.getMessage());
        Mockito.verifyNoInteractions((Object[])new Object[]{errorHandler});
    }

    private void testWriteFailureWithWriteAccessMode(String code) {
        ClientException error = new ClientException(code, "Hi");
        RoutingErrorHandler errorHandler = (RoutingErrorHandler)Mockito.mock(RoutingErrorHandler.class);
        Throwable handledError = RoutingResponseHandlerTest.handle(error, errorHandler, AccessMode.WRITE);
        MatcherAssert.assertThat((Object)handledError, (Matcher)Matchers.instanceOf(SessionExpiredException.class));
        Assertions.assertEquals((Object)("Server at " + BoltServerAddress.LOCAL_DEFAULT + " no longer accepts writes"), (Object)handledError.getMessage());
        ((RoutingErrorHandler)Mockito.verify((Object)errorHandler)).onWriteFailure(BoltServerAddress.LOCAL_DEFAULT);
    }

    private static Throwable handle(Throwable error, RoutingErrorHandler errorHandler) {
        return RoutingResponseHandlerTest.handle(error, errorHandler, AccessMode.READ);
    }

    private static Throwable handle(Throwable error, RoutingErrorHandler errorHandler, AccessMode accessMode) {
        ResponseHandler responseHandler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        RoutingResponseHandler routingResponseHandler = new RoutingResponseHandler(responseHandler, BoltServerAddress.LOCAL_DEFAULT, accessMode, errorHandler);
        routingResponseHandler.onFailure(error);
        ArgumentCaptor handledErrorCaptor = ArgumentCaptor.forClass(Throwable.class);
        ((ResponseHandler)Mockito.verify((Object)responseHandler)).onFailure((Throwable)handledErrorCaptor.capture());
        return (Throwable)handledErrorCaptor.getValue();
    }
}

