/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.Query;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.exceptions.ConnectionReadTimeoutException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.SessionPullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandler;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v43.BoltProtocolV43;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.util.TestUtil;

class SessionPullResponseCompletionListenerTest {
    SessionPullResponseCompletionListenerTest() {
    }

    @Test
    void shouldReleaseConnectionOnSuccess() {
        Connection connection = SessionPullResponseCompletionListenerTest.newConnectionMock();
        SessionPullResponseCompletionListener listener = new SessionPullResponseCompletionListener(connection, BookmarkHolder.NO_OP);
        ResponseHandler handler = SessionPullResponseCompletionListenerTest.newHandler(connection, (PullResponseCompletionListener)listener);
        handler.onSuccess(Collections.emptyMap());
        ((Connection)Mockito.verify((Object)connection)).release();
    }

    @Test
    void shouldReleaseConnectionOnFailure() {
        Connection connection = SessionPullResponseCompletionListenerTest.newConnectionMock();
        SessionPullResponseCompletionListener listener = new SessionPullResponseCompletionListener(connection, BookmarkHolder.NO_OP);
        ResponseHandler handler = SessionPullResponseCompletionListenerTest.newHandler(connection, (PullResponseCompletionListener)listener);
        handler.onFailure((Throwable)new RuntimeException());
        ((Connection)Mockito.verify((Object)connection)).release();
    }

    @Test
    void shouldUpdateBookmarksOnSuccess() {
        Connection connection = SessionPullResponseCompletionListenerTest.newConnectionMock();
        String bookmarkValue = "neo4j:bookmark:v1:tx42";
        BookmarkHolder bookmarkHolder = (BookmarkHolder)Mockito.mock(BookmarkHolder.class);
        SessionPullResponseCompletionListener listener = new SessionPullResponseCompletionListener(connection, bookmarkHolder);
        ResponseHandler handler = SessionPullResponseCompletionListenerTest.newHandler(connection, (PullResponseCompletionListener)listener);
        handler.onSuccess(Collections.singletonMap("bookmark", Values.value((String)bookmarkValue)));
        ((BookmarkHolder)Mockito.verify((Object)bookmarkHolder)).setBookmark(InternalBookmark.parse((String)bookmarkValue));
    }

    @Test
    void shouldReleaseConnectionImmediatelyOnAuthorizationExpiredExceptionFailure() {
        Connection connection = SessionPullResponseCompletionListenerTest.newConnectionMock();
        SessionPullResponseCompletionListener listener = new SessionPullResponseCompletionListener(connection, BookmarkHolder.NO_OP);
        ResponseHandler handler = SessionPullResponseCompletionListenerTest.newHandler(connection, (PullResponseCompletionListener)listener);
        AuthorizationExpiredException exception = new AuthorizationExpiredException("code", "message");
        handler.onFailure((Throwable)exception);
        ((Connection)Mockito.verify((Object)connection)).terminateAndRelease("Authorization information kept on the server has expired, this connection is no longer valid.");
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).release();
    }

    @Test
    void shouldReleaseConnectionImmediatelyOnConnectionReadTimeoutExceptionFailure() {
        Connection connection = SessionPullResponseCompletionListenerTest.newConnectionMock();
        SessionPullResponseCompletionListener listener = new SessionPullResponseCompletionListener(connection, BookmarkHolder.NO_OP);
        ResponseHandler handler = SessionPullResponseCompletionListenerTest.newHandler(connection, (PullResponseCompletionListener)listener);
        handler.onFailure((Throwable)ConnectionReadTimeoutException.INSTANCE);
        ((Connection)Mockito.verify((Object)connection)).terminateAndRelease(ConnectionReadTimeoutException.INSTANCE.getMessage());
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).release();
    }

    private static ResponseHandler newHandler(Connection connection, PullResponseCompletionListener listener) {
        RunResponseHandler runHandler = new RunResponseHandler(new CompletableFuture(), BoltProtocolV3.METADATA_EXTRACTOR, (Connection)Mockito.mock(Connection.class), null);
        BasicPullResponseHandler handler = new BasicPullResponseHandler(new Query("RETURN 1"), runHandler, connection, BoltProtocolV3.METADATA_EXTRACTOR, listener);
        handler.installRecordConsumer((record, throwable) -> {});
        handler.installSummaryConsumer((resultSummary, throwable) -> {});
        return handler;
    }

    private static Connection newConnectionMock() {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.serverAddress()).thenReturn((Object)BoltServerAddress.LOCAL_DEFAULT);
        Mockito.when((Object)connection.serverVersion()).thenReturn((Object)TestUtil.anyServerVersion());
        Mockito.when((Object)connection.protocol()).thenReturn((Object)BoltProtocolV43.INSTANCE);
        Mockito.when((Object)connection.serverAgent()).thenReturn((Object)"Neo4j/4.2.5");
        return connection;
    }
}

