/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.async.connection.BoltProtocolUtil;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.connection.ChannelPipelineBuilderImpl;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.async.outbound.ChunkAwareByteBufOutput;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.response.FailureMessage;
import org.neo4j.driver.internal.messaging.response.IgnoredMessage;
import org.neo4j.driver.internal.messaging.response.RecordMessage;
import org.neo4j.driver.internal.messaging.response.SuccessMessage;
import org.neo4j.driver.internal.messaging.v3.MessageFormatV3;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.internal.packstream.PackStream;
import org.neo4j.driver.internal.util.ValueFactory;
import org.neo4j.driver.internal.util.messaging.KnowledgeableMessageFormat;
import org.neo4j.driver.internal.util.messaging.MemorizingInboundMessageDispatcher;

class MessageFormatTest {
    public MessageFormat format = new MessageFormatV3();

    MessageFormatTest() {
    }

    @Test
    void shouldUnpackAllResponses() throws Throwable {
        this.assertSerializes((Message)new FailureMessage("Hello", "World!"));
        this.assertSerializes((Message)IgnoredMessage.IGNORED);
        this.assertSerializes((Message)new RecordMessage(new Value[]{Values.value((long)1337L)}));
        this.assertSerializes((Message)new SuccessMessage(new HashMap()));
    }

    @Test
    void shouldPackUnpackValidValues() throws Throwable {
        this.assertSerializesValue(Values.value((Object)Values.parameters((Object[])new Object[]{"cat", null, "dog", null})));
        this.assertSerializesValue(Values.value((Object)Values.parameters((Object[])new Object[]{"k", 12, "a", "banana"})));
        this.assertSerializesValue(Values.value(Arrays.asList("k", 12, "a", "banana")));
    }

    @Test
    void shouldUnpackNodeRelationshipAndPath() throws Throwable {
        this.assertOnlyDeserializesValue((Value)ValueFactory.emptyNodeValue());
        this.assertOnlyDeserializesValue((Value)ValueFactory.filledNodeValue());
        this.assertOnlyDeserializesValue((Value)ValueFactory.emptyRelationshipValue());
        this.assertOnlyDeserializesValue((Value)ValueFactory.filledRelationshipValue());
        this.assertOnlyDeserializesValue((Value)ValueFactory.emptyPathValue());
        this.assertOnlyDeserializesValue((Value)ValueFactory.filledPathValue());
    }

    @Test
    void shouldGiveHelpfulErrorOnMalformedNodeStruct() throws Throwable {
        ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput();
        ByteBuf buf = Unpooled.buffer();
        output.start(buf);
        PackStream.Packer packer = new PackStream.Packer((PackOutput)output);
        packer.packStructHeader(1, (byte)113);
        packer.packListHeader(1);
        packer.packStructHeader(0, (byte)78);
        output.stop();
        BoltProtocolUtil.writeMessageBoundary((ByteBuf)buf);
        ClientException error = (ClientException)Assertions.assertThrows(ClientException.class, () -> this.unpack(buf, this.newEmbeddedChannel()));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.startsWith((String)"Invalid message received, serialized NODE structures should have 3 fields, received NODE structure has 0 fields."));
    }

    private void assertSerializesValue(Value value) throws Throwable {
        this.assertSerializes((Message)new RecordMessage(new Value[]{value}));
    }

    private void assertSerializes(Message message) throws Throwable {
        EmbeddedChannel channel = this.newEmbeddedChannel((MessageFormat)new KnowledgeableMessageFormat());
        ByteBuf packed = this.pack(message, channel);
        Message unpackedMessage = this.unpack(packed, channel);
        Assertions.assertEquals((Object)message, (Object)unpackedMessage);
    }

    private EmbeddedChannel newEmbeddedChannel() {
        return this.newEmbeddedChannel(this.format);
    }

    private EmbeddedChannel newEmbeddedChannel(MessageFormat format) {
        EmbeddedChannel channel = new EmbeddedChannel();
        ChannelAttributes.setMessageDispatcher((Channel)channel, (InboundMessageDispatcher)new MemorizingInboundMessageDispatcher((Channel)channel, DevNullLogging.DEV_NULL_LOGGING));
        new ChannelPipelineBuilderImpl().build(format, channel.pipeline(), DevNullLogging.DEV_NULL_LOGGING);
        return channel;
    }

    private ByteBuf pack(Message message, EmbeddedChannel channel) {
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{message}));
        ByteBuf[] packedMessages = (ByteBuf[])channel.outboundMessages().stream().map(msg -> (ByteBuf)msg).toArray(ByteBuf[]::new);
        return Unpooled.wrappedBuffer((ByteBuf[])packedMessages);
    }

    private Message unpack(ByteBuf packed, EmbeddedChannel channel) throws Throwable {
        channel.writeInbound(new Object[]{packed});
        InboundMessageDispatcher dispatcher = ChannelAttributes.messageDispatcher((Channel)channel);
        MemorizingInboundMessageDispatcher memorizingDispatcher = (MemorizingInboundMessageDispatcher)dispatcher;
        Throwable error = memorizingDispatcher.currentError();
        if (error != null) {
            throw error;
        }
        List<Message> unpackedMessages = memorizingDispatcher.messages();
        Assertions.assertEquals((int)1, (int)unpackedMessages.size());
        return unpackedMessages.get(0);
    }

    private void assertOnlyDeserializesValue(Value value) throws Throwable {
        RecordMessage message = new RecordMessage(new Value[]{value});
        ByteBuf packed = this.knowledgeablePack((Message)message);
        EmbeddedChannel channel = this.newEmbeddedChannel();
        Message unpackedMessage = this.unpack(packed, channel);
        Assertions.assertEquals((Object)message, (Object)unpackedMessage);
    }

    private ByteBuf knowledgeablePack(Message message) throws IOException {
        EmbeddedChannel channel = this.newEmbeddedChannel((MessageFormat)new KnowledgeableMessageFormat());
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{message}));
        ByteBuf[] packedMessages = (ByteBuf[])channel.outboundMessages().stream().map(msg -> (ByteBuf)msg).toArray(ByteBuf[]::new);
        return Unpooled.wrappedBuffer((ByteBuf[])packedMessages);
    }
}

