/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.encode;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.messaging.encode.DiscardMessageEncoder;
import org.neo4j.driver.internal.messaging.request.DiscardAllMessage;
import org.neo4j.driver.internal.messaging.request.DiscardMessage;

class DiscardMessageEncoderTest {
    private final DiscardMessageEncoder encoder = new DiscardMessageEncoder();
    private final ValuePacker packer = (ValuePacker)Mockito.mock(ValuePacker.class);

    DiscardMessageEncoderTest() {
    }

    @Test
    void shouldDiscardAllCorrectly() throws Throwable {
        this.encoder.encode((Message)DiscardMessage.newDiscardAllMessage((long)-1L), this.packer);
        HashMap<String, Value> meta = new HashMap<String, Value>();
        meta.put("n", Values.value((int)-1));
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.packer});
        ((ValuePacker)order.verify((Object)this.packer)).packStructHeader(1, (byte)47);
        ((ValuePacker)order.verify((Object)this.packer)).pack(meta);
    }

    @Test
    void shouldEncodeDiscardMessage() throws Exception {
        this.encoder.encode((Message)new DiscardMessage(100L, 200L), this.packer);
        HashMap<String, Value> meta = new HashMap<String, Value>();
        meta.put("n", Values.value((int)100));
        meta.put("qid", Values.value((int)200));
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.packer});
        ((ValuePacker)order.verify((Object)this.packer)).packStructHeader(1, (byte)47);
        ((ValuePacker)order.verify((Object)this.packer)).pack(meta);
    }

    @Test
    void shouldAvoidQueryId() throws Throwable {
        this.encoder.encode((Message)new DiscardMessage(100L, -1L), this.packer);
        HashMap<String, Value> meta = new HashMap<String, Value>();
        meta.put("n", Values.value((int)100));
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.packer});
        ((ValuePacker)order.verify((Object)this.packer)).packStructHeader(1, (byte)47);
        ((ValuePacker)order.verify((Object)this.packer)).pack(meta);
    }

    @Test
    void shouldFailToEncodeWrongMessage() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.encoder.encode((Message)DiscardAllMessage.DISCARD_ALL, this.packer));
    }
}

