/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v44;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalPoint2D;
import org.neo4j.driver.internal.InternalPoint3D;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.request.DiscardAllMessage;
import org.neo4j.driver.internal.messaging.response.FailureMessage;
import org.neo4j.driver.internal.messaging.response.IgnoredMessage;
import org.neo4j.driver.internal.messaging.response.RecordMessage;
import org.neo4j.driver.internal.messaging.response.SuccessMessage;
import org.neo4j.driver.internal.messaging.v44.BoltProtocolV44;
import org.neo4j.driver.internal.packstream.PackInput;
import org.neo4j.driver.internal.util.ValueFactory;
import org.neo4j.driver.internal.util.messaging.AbstractMessageReaderTestBase;

public class MessageReaderV44Test
extends AbstractMessageReaderTestBase {
    @Override
    protected Stream<Message> supportedMessages() {
        return Stream.of(this.record(Values.value((Object)new InternalPoint2D(42, 120.65, -99.2))), this.record(Values.value((Object)new InternalPoint3D(42, 85.391, 98.8, 11.1))), this.record(Values.value((LocalDate)LocalDate.of(2012, 7, 3))), this.record(Values.value((OffsetTime)OffsetTime.of(23, 59, 59, 999, ZoneOffset.MAX))), this.record(Values.value((LocalTime)LocalTime.of(12, 25))), this.record(Values.value((LocalDateTime)LocalDateTime.of(1999, 3, 3, 19, 5, 5, 100200300))), this.record(Values.value((ZonedDateTime)ZonedDateTime.of(1823, 1, 12, 23, 59, 59, 999999999, ZoneOffset.ofHoursMinutes(-7, -15)))), this.record(Values.value((ZonedDateTime)ZonedDateTime.of(1823, 1, 12, 23, 59, 59, 999999999, ZoneId.of("Europe/Stockholm")))), this.record(Values.value((Object)Values.isoDuration((long)0x7FFFFFFFFFFFFFFEL, (long)0x7FFFFFFEL, (long)32766L, (int)126).asIsoDuration())), this.record(Values.value((Object)Values.isoDuration((long)17L, (long)22L, (long)99L, (int)15).asIsoDuration())), new FailureMessage("Hello", "World!"), IgnoredMessage.IGNORED, new SuccessMessage(new HashMap()), this.record(Values.value((long)1337L)), this.record(Values.value((Object)Values.parameters((Object[])new Object[]{"cat", null, "dog", null}))), this.record(Values.value((Object)Values.parameters((Object[])new Object[]{"k", 12, "a", "banana"}))), this.record(Values.value(Arrays.asList("k", 12, "a", "banana"))), this.record((Value)ValueFactory.emptyNodeValue()), this.record((Value)ValueFactory.filledNodeValue()), this.record((Value)ValueFactory.emptyRelationshipValue()), this.record((Value)ValueFactory.filledRelationshipValue()), this.record((Value)ValueFactory.filledPathValue()), this.record((Value)ValueFactory.emptyPathValue()));
    }

    @Override
    protected Stream<Message> unsupportedMessages() {
        return Stream.of(DiscardAllMessage.DISCARD_ALL);
    }

    @Override
    protected MessageFormat.Reader newReader(PackInput input) {
        return BoltProtocolV44.INSTANCE.createMessageFormat().newReader(input);
    }

    private Message record(Value value) {
        return new RecordMessage(new Value[]{value});
    }
}

