/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net;

import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.internal.BoltServerAddress;

class BoltServerAddressParsingTest {
    BoltServerAddressParsingTest() {
    }

    private static Stream<Arguments> addressesToParse() {
        return Stream.of(Arguments.of((Object[])new Object[]{"localhost", "localhost", 7687}), Arguments.of((Object[])new Object[]{"localhost:9193", "localhost", 9193}), Arguments.of((Object[])new Object[]{"neo4j.com", "neo4j.com", 7687}), Arguments.of((Object[])new Object[]{"royal-server.com.uk", "royal-server.com.uk", 7687}), Arguments.of((Object[])new Object[]{"royal-server.com.uk:4546", "royal-server.com.uk", 4546}), Arguments.of((Object[])new Object[]{"bolt://localhost", "localhost", 7687}), Arguments.of((Object[])new Object[]{"neo4j://localhost", "localhost", 7687}), Arguments.of((Object[])new Object[]{"bolt://localhost:9193", "localhost", 9193}), Arguments.of((Object[])new Object[]{"neo4j://localhost:9193", "localhost", 9193}), Arguments.of((Object[])new Object[]{"bolt://neo4j.com", "neo4j.com", 7687}), Arguments.of((Object[])new Object[]{"neo4j://neo4j.com", "neo4j.com", 7687}), Arguments.of((Object[])new Object[]{"bolt://royal-server.com.uk", "royal-server.com.uk", 7687}), Arguments.of((Object[])new Object[]{"neo4j://royal-server.com.uk", "royal-server.com.uk", 7687}), Arguments.of((Object[])new Object[]{"bolt://royal-server.com.uk:4546", "royal-server.com.uk", 4546}), Arguments.of((Object[])new Object[]{"neo4j://royal-server.com.uk:4546", "royal-server.com.uk", 4546}), Arguments.of((Object[])new Object[]{"127.0.0.1", "127.0.0.1", 7687}), Arguments.of((Object[])new Object[]{"8.8.8.8:8080", "8.8.8.8", 8080}), Arguments.of((Object[])new Object[]{"0.0.0.0", "0.0.0.0", 7687}), Arguments.of((Object[])new Object[]{"192.0.2.235:4329", "192.0.2.235", 4329}), Arguments.of((Object[])new Object[]{"172.31.255.255:255", "172.31.255.255", 255}), Arguments.of((Object[])new Object[]{"bolt://198.51.100.0", "198.51.100.0", 7687}), Arguments.of((Object[])new Object[]{"bolt://65.21.10.12:5656", "65.21.10.12", 5656}), Arguments.of((Object[])new Object[]{"neo4j://12.0.0.5", "12.0.0.5", 7687}), Arguments.of((Object[])new Object[]{"neo4j://155.55.20.6:9191", "155.55.20.6", 9191}), Arguments.of((Object[])new Object[]{"::1", "[::1]", 7687}), Arguments.of((Object[])new Object[]{"ff02::2:ff00:0", "[ff02::2:ff00:0]", 7687}), Arguments.of((Object[])new Object[]{"[1afc:0:a33:85a3::ff2f]", "[1afc:0:a33:85a3::ff2f]", 7687}), Arguments.of((Object[])new Object[]{"[::1]:1515", "[::1]", 1515}), Arguments.of((Object[])new Object[]{"[ff0a::101]:8989", "[ff0a::101]", 8989}), Arguments.of((Object[])new Object[]{"bolt://[::1]", "[::1]", 7687}), Arguments.of((Object[])new Object[]{"neo4j://[::1]", "[::1]", 7687}), Arguments.of((Object[])new Object[]{"bolt://[ff02::d]", "[ff02::d]", 7687}), Arguments.of((Object[])new Object[]{"neo4j://[fe80::b279:2f]", "[fe80::b279:2f]", 7687}), Arguments.of((Object[])new Object[]{"bolt://[::1]:8687", "[::1]", 8687}), Arguments.of((Object[])new Object[]{"neo4j://[::1]:1212", "[::1]", 1212}), Arguments.of((Object[])new Object[]{"bolt://[ff02::d]:9090", "[ff02::d]", 9090}), Arguments.of((Object[])new Object[]{"neo4j://[fe80::b279:2f]:7878", "[fe80::b279:2f]", 7878}), Arguments.of((Object[])new Object[]{"::1%eth0", "[::1%eth0]", 7687}), Arguments.of((Object[])new Object[]{"ff02::2:ff00:0%12", "[ff02::2:ff00:0%12]", 7687}), Arguments.of((Object[])new Object[]{"[1afc:0:a33:85a3::ff2f%eth1]", "[1afc:0:a33:85a3::ff2f%eth1]", 7687}), Arguments.of((Object[])new Object[]{"[::1%eth0]:3030", "[::1%eth0]", 3030}), Arguments.of((Object[])new Object[]{"[ff0a::101%8]:4040", "[ff0a::101%8]", 4040}), Arguments.of((Object[])new Object[]{"bolt://[::1%eth5]", "[::1%eth5]", 7687}), Arguments.of((Object[])new Object[]{"neo4j://[::1%12]", "[::1%12]", 7687}), Arguments.of((Object[])new Object[]{"bolt://[ff02::d%3]", "[ff02::d%3]", 7687}), Arguments.of((Object[])new Object[]{"neo4j://[fe80::b279:2f%eth0]", "[fe80::b279:2f%eth0]", 7687}), Arguments.of((Object[])new Object[]{"bolt://[::1%eth3]:8687", "[::1%eth3]", 8687}), Arguments.of((Object[])new Object[]{"neo4j://[::1%2]:1212", "[::1%2]", 1212}), Arguments.of((Object[])new Object[]{"bolt://[ff02::d%3]:9090", "[ff02::d%3]", 9090}), Arguments.of((Object[])new Object[]{"neo4j://[fe80::b279:2f%eth1]:7878", "[fe80::b279:2f%eth1]", 7878}));
    }

    @ParameterizedTest
    @MethodSource(value={"addressesToParse"})
    void shouldParseAddress(String address, String expectedHost, int expectedPort) {
        BoltServerAddress parsed = new BoltServerAddress(address);
        Assertions.assertEquals((Object)expectedHost, (Object)parsed.host());
        Assertions.assertEquals((int)expectedPort, (int)parsed.port());
    }
}

