/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net;

import java.net.URI;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.net.ServerAddress;

class BoltServerAddressTest {
    BoltServerAddressTest() {
    }

    @Test
    void defaultPortShouldBe7687() {
        MatcherAssert.assertThat((Object)7687, (Matcher)CoreMatchers.equalTo((Object)7687));
    }

    @Test
    void portShouldUseDefaultIfNotSupplied() {
        MatcherAssert.assertThat((Object)new BoltServerAddress("localhost").port(), (Matcher)CoreMatchers.equalTo((Object)7687));
    }

    @Test
    void shouldHaveCorrectToString() {
        Assertions.assertEquals((Object)"localhost:4242", (Object)new BoltServerAddress("localhost", 4242).toString());
        Assertions.assertEquals((Object)"127.0.0.1:8888", (Object)new BoltServerAddress("127.0.0.1", 8888).toString());
    }

    @Test
    void shouldVerifyHost() {
        Assertions.assertThrows(NullPointerException.class, () -> new BoltServerAddress(null, 0));
    }

    @Test
    void shouldVerifyPort() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BoltServerAddress("localhost", -1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BoltServerAddress("localhost", -42));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BoltServerAddress("localhost", 65536));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new BoltServerAddress("localhost", 99999));
    }

    @Test
    void shouldCreateBoltServerAddressFromServerAddress() {
        BoltServerAddress address1 = new BoltServerAddress("my.server.com", 8899);
        Assertions.assertSame((Object)address1, (Object)BoltServerAddress.from((ServerAddress)address1));
        BoltServerAddress address2 = new BoltServerAddress("db.neo4j.com");
        Assertions.assertSame((Object)address2, (Object)BoltServerAddress.from((ServerAddress)address2));
        ServerAddress address3 = (ServerAddress)Mockito.mock(ServerAddress.class);
        Mockito.when((Object)address3.host()).thenReturn((Object)"graph.database.com");
        Mockito.when((Object)address3.port()).thenReturn((Object)20600);
        Assertions.assertEquals((Object)new BoltServerAddress("graph.database.com", 20600), (Object)BoltServerAddress.from((ServerAddress)address3));
    }

    @Test
    void shouldFailToCreateBoltServerAddressFromInvalidServerAddress() {
        ServerAddress address1 = (ServerAddress)Mockito.mock(ServerAddress.class);
        Mockito.when((Object)address1.host()).thenReturn(null);
        Mockito.when((Object)address1.port()).thenReturn((Object)8888);
        Assertions.assertThrows(NullPointerException.class, () -> BoltServerAddress.from((ServerAddress)address1));
        ServerAddress address2 = (ServerAddress)Mockito.mock(ServerAddress.class);
        Mockito.when((Object)address2.host()).thenReturn((Object)"neo4j.host.com");
        Mockito.when((Object)address2.port()).thenReturn((Object)-1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> BoltServerAddress.from((ServerAddress)address2));
        ServerAddress address3 = (ServerAddress)Mockito.mock(ServerAddress.class);
        Mockito.when((Object)address3.host()).thenReturn((Object)"my.database.org");
        Mockito.when((Object)address3.port()).thenReturn((Object)99000);
        Assertions.assertThrows(IllegalArgumentException.class, () -> BoltServerAddress.from((ServerAddress)address3));
    }

    @Test
    void shouldUseUriWithHostButWithoutPort() {
        URI uri = URI.create("bolt://neo4j.com");
        BoltServerAddress address = new BoltServerAddress(uri);
        Assertions.assertEquals((Object)"neo4j.com", (Object)address.host());
        Assertions.assertEquals((int)7687, (int)address.port());
    }

    @Test
    void shouldUseUriWithHostAndPort() {
        URI uri = URI.create("bolt://neo4j.com:12345");
        BoltServerAddress address = new BoltServerAddress(uri);
        Assertions.assertEquals((Object)"neo4j.com", (Object)address.host());
        Assertions.assertEquals((int)12345, (int)address.port());
    }

    @Test
    void shouldIncludeHostAndPortInToString() {
        BoltServerAddress address = new BoltServerAddress("localhost", 8081);
        MatcherAssert.assertThat((Object)address.toString(), (Matcher)CoreMatchers.equalTo((Object)"localhost:8081"));
    }
}

