/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.cursor.RxResultCursorImpl;
import org.neo4j.driver.internal.reactive.InternalRxResult;
import org.neo4j.driver.internal.reactive.InternalRxTransaction;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxTransaction;
import org.reactivestreams.Publisher;
import reactor.test.StepVerifier;

class InternalRxTransactionTest {
    InternalRxTransactionTest() {
    }

    @Test
    void commitShouldDelegate() {
        UnmanagedTransaction tx = (UnmanagedTransaction)Mockito.mock(UnmanagedTransaction.class);
        Mockito.when((Object)tx.commitAsync()).thenReturn((Object)Futures.completedWithNull());
        InternalRxTransaction rxTx = new InternalRxTransaction(tx);
        Publisher publisher = rxTx.commit();
        StepVerifier.create((Publisher)publisher).verifyComplete();
        ((UnmanagedTransaction)Mockito.verify((Object)tx)).commitAsync();
    }

    @Test
    void rollbackShouldDelegate() {
        UnmanagedTransaction tx = (UnmanagedTransaction)Mockito.mock(UnmanagedTransaction.class);
        Mockito.when((Object)tx.rollbackAsync()).thenReturn((Object)Futures.completedWithNull());
        InternalRxTransaction rxTx = new InternalRxTransaction(tx);
        Publisher publisher = rxTx.rollback();
        StepVerifier.create((Publisher)publisher).verifyComplete();
        ((UnmanagedTransaction)Mockito.verify((Object)tx)).rollbackAsync();
    }

    private static Stream<Function<RxTransaction, RxResult>> allTxRunMethods() {
        return Stream.of(rxSession -> rxSession.run("RETURN 1"), rxSession -> rxSession.run("RETURN $x", Values.parameters((Object[])new Object[]{"x", 1})), rxSession -> rxSession.run("RETURN $x", Collections.singletonMap("x", 1)), rxSession -> rxSession.run("RETURN $x", (Record)new InternalRecord(Collections.singletonList("x"), new Value[]{new IntegerValue(1L)})), rxSession -> rxSession.run(new Query("RETURN $x", Values.parameters((Object[])new Object[]{"x", 1}))));
    }

    @ParameterizedTest
    @MethodSource(value={"allTxRunMethods"})
    void shouldDelegateRun(Function<RxTransaction, RxResult> runReturnOne) throws Throwable {
        UnmanagedTransaction tx = (UnmanagedTransaction)Mockito.mock(UnmanagedTransaction.class);
        RxResultCursor cursor = (RxResultCursor)Mockito.mock(RxResultCursorImpl.class);
        Mockito.when((Object)tx.runRx((Query)ArgumentMatchers.any(Query.class))).thenReturn(CompletableFuture.completedFuture(cursor));
        InternalRxTransaction rxTx = new InternalRxTransaction(tx);
        RxResult result = runReturnOne.apply((RxTransaction)rxTx);
        CompletionStage cursorFuture = (CompletionStage)((InternalRxResult)result).cursorFutureSupplier().get();
        ((UnmanagedTransaction)Mockito.verify((Object)tx)).runRx((Query)ArgumentMatchers.any(Query.class));
        Assert.assertThat((Object)((RxResultCursor)Futures.getNow((CompletionStage)cursorFuture)), (Matcher)CoreMatchers.equalTo((Object)cursor));
    }

    @ParameterizedTest
    @MethodSource(value={"allTxRunMethods"})
    void shouldMarkTxIfFailedToRun(Function<RxTransaction, RxResult> runReturnOne) throws Throwable {
        RuntimeException error = new RuntimeException("Hi there");
        UnmanagedTransaction tx = (UnmanagedTransaction)Mockito.mock(UnmanagedTransaction.class);
        Mockito.when((Object)tx.runRx((Query)ArgumentMatchers.any(Query.class))).thenReturn((Object)Futures.failedFuture((Throwable)error));
        InternalRxTransaction rxTx = new InternalRxTransaction(tx);
        RxResult result = runReturnOne.apply((RxTransaction)rxTx);
        CompletionStage cursorFuture = (CompletionStage)((InternalRxResult)result).cursorFutureSupplier().get();
        ((UnmanagedTransaction)Mockito.verify((Object)tx)).runRx((Query)ArgumentMatchers.any(Query.class));
        RuntimeException t = (RuntimeException)Assertions.assertThrows(CompletionException.class, () -> Futures.getNow((CompletionStage)cursorFuture));
        Assert.assertThat((Object)t.getCause(), (Matcher)CoreMatchers.equalTo((Object)error));
        ((UnmanagedTransaction)Mockito.verify((Object)tx)).markTerminated((Throwable)error);
    }

    @Test
    void shouldDelegateConditionalClose() {
        UnmanagedTransaction tx = (UnmanagedTransaction)Mockito.mock(UnmanagedTransaction.class);
        Mockito.when((Object)tx.closeAsync(true)).thenReturn((Object)Futures.completedWithNull());
        InternalRxTransaction rxTx = new InternalRxTransaction(tx);
        Publisher publisher = rxTx.close(true);
        StepVerifier.create((Publisher)publisher).verifyComplete();
        ((UnmanagedTransaction)Mockito.verify((Object)tx)).closeAsync(true);
    }

    @Test
    void shouldDelegateClose() {
        UnmanagedTransaction tx = (UnmanagedTransaction)Mockito.mock(UnmanagedTransaction.class);
        Mockito.when((Object)tx.closeAsync(false)).thenReturn((Object)Futures.completedWithNull());
        InternalRxTransaction rxTx = new InternalRxTransaction(tx);
        Publisher publisher = rxTx.close();
        StepVerifier.create((Publisher)publisher).verifyComplete();
        ((UnmanagedTransaction)Mockito.verify((Object)tx)).closeAsync(false);
    }
}

