/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.retry;

import io.netty.util.concurrent.EventExecutorGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.ConnectionReadTimeoutException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.internal.logging.DevNullLogging;
import org.neo4j.driver.internal.retry.ExponentialBackoffRetryLogic;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.ImmediateSchedulingEventExecutor;
import org.neo4j.driver.util.TestUtil;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

class ExponentialBackoffRetryLogicTest {
    private final ImmediateSchedulingEventExecutor eventExecutor = new ImmediateSchedulingEventExecutor();

    ExponentialBackoffRetryLogicTest() {
    }

    @Test
    void throwsForIllegalMaxRetryTime() {
        IllegalArgumentException error = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.newRetryLogic(-100L, 1L, 1.0, 1.0, Clock.SYSTEM));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"Max retry time"));
    }

    @Test
    void throwsForIllegalInitialRetryDelay() {
        IllegalArgumentException error = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.newRetryLogic(1L, -100L, 1.0, 1.0, Clock.SYSTEM));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"Initial retry delay"));
    }

    @Test
    void throwsForIllegalMultiplier() {
        IllegalArgumentException error = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.newRetryLogic(1L, 1L, 0.42, 1.0, Clock.SYSTEM));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"Multiplier"));
    }

    @Test
    void throwsForIllegalJitterFactor() {
        IllegalArgumentException error1 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.newRetryLogic(1L, 1L, 1.0, -0.42, Clock.SYSTEM));
        MatcherAssert.assertThat((Object)error1.getMessage(), (Matcher)Matchers.containsString((String)"Jitter"));
        IllegalArgumentException error2 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.newRetryLogic(1L, 1L, 1.0, 1.42, Clock.SYSTEM));
        MatcherAssert.assertThat((Object)error2.getMessage(), (Matcher)Matchers.containsString((String)"Jitter"));
    }

    @Test
    void throwsForIllegalClock() {
        IllegalArgumentException error = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.newRetryLogic(1L, 1L, 1.0, 1.0, null));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"Clock"));
    }

    @Test
    void nextDelayCalculatedAccordingToMultiplier() throws Exception {
        int retries = 27;
        int initialDelay = 1;
        int multiplier = 3;
        boolean noJitter = false;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic logic = this.newRetryLogic(Long.MAX_VALUE, initialDelay, multiplier, (double)noJitter, clock);
        ExponentialBackoffRetryLogicTest.retry(logic, retries);
        Assertions.assertEquals(ExponentialBackoffRetryLogicTest.delaysWithoutJitter(initialDelay, multiplier, retries), ExponentialBackoffRetryLogicTest.sleepValues(clock, retries));
    }

    @Test
    void nextDelayCalculatedAccordingToMultiplierAsync() {
        String result = "The Result";
        int retries = 14;
        int initialDelay = 1;
        int multiplier = 2;
        boolean noJitter = false;
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(Long.MAX_VALUE, initialDelay, multiplier, (double)noJitter, Clock.SYSTEM);
        CompletionStage<Object> future = this.retryAsync(retryLogic, retries, result);
        Assertions.assertEquals((Object)result, TestUtil.await(future));
        Assertions.assertEquals(ExponentialBackoffRetryLogicTest.delaysWithoutJitter(initialDelay, multiplier, retries), this.eventExecutor.scheduleDelays());
    }

    @Test
    void nextDelayCalculatedAccordingToMultiplierRx() {
        String result = "The Result";
        int retries = 14;
        int initialDelay = 1;
        int multiplier = 2;
        boolean noJitter = false;
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(Long.MAX_VALUE, initialDelay, multiplier, (double)noJitter, Clock.SYSTEM);
        Mono single = Flux.from(this.retryRx(retryLogic, retries, result)).single();
        Assertions.assertEquals((Object)result, TestUtil.await(single));
        Assertions.assertEquals(ExponentialBackoffRetryLogicTest.delaysWithoutJitter(initialDelay, multiplier, retries), this.eventExecutor.scheduleDelays());
    }

    @Test
    void nextDelayCalculatedAccordingToJitter() throws Exception {
        int retries = 32;
        double jitterFactor = 0.2;
        int initialDelay = 1;
        int multiplier = 2;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic logic = this.newRetryLogic(Long.MAX_VALUE, initialDelay, multiplier, jitterFactor, clock);
        ExponentialBackoffRetryLogicTest.retry(logic, retries);
        List<Long> sleepValues = ExponentialBackoffRetryLogicTest.sleepValues(clock, retries);
        List<Long> delaysWithoutJitter = ExponentialBackoffRetryLogicTest.delaysWithoutJitter(initialDelay, multiplier, retries);
        ExponentialBackoffRetryLogicTest.assertDelaysApproximatelyEqual(delaysWithoutJitter, sleepValues, jitterFactor);
    }

    @Test
    void nextDelayCalculatedAccordingToJitterAsync() {
        String result = "The Result";
        int retries = 24;
        double jitterFactor = 0.2;
        int initialDelay = 1;
        int multiplier = 2;
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(Long.MAX_VALUE, initialDelay, multiplier, jitterFactor, (Clock)Mockito.mock(Clock.class));
        CompletionStage<Object> future = this.retryAsync(retryLogic, retries, result);
        Assertions.assertEquals((Object)result, TestUtil.await(future));
        List<Long> scheduleDelays = this.eventExecutor.scheduleDelays();
        List<Long> delaysWithoutJitter = ExponentialBackoffRetryLogicTest.delaysWithoutJitter(initialDelay, multiplier, retries);
        ExponentialBackoffRetryLogicTest.assertDelaysApproximatelyEqual(delaysWithoutJitter, scheduleDelays, jitterFactor);
    }

    @Test
    void nextDelayCalculatedAccordingToJitterRx() {
        String result = "The Result";
        int retries = 24;
        double jitterFactor = 0.2;
        int initialDelay = 1;
        int multiplier = 2;
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(Long.MAX_VALUE, initialDelay, multiplier, jitterFactor, (Clock)Mockito.mock(Clock.class));
        Mono single = Flux.from(this.retryRx(retryLogic, retries, result)).single();
        Assertions.assertEquals((Object)result, TestUtil.await(single));
        List<Long> scheduleDelays = this.eventExecutor.scheduleDelays();
        List<Long> delaysWithoutJitter = ExponentialBackoffRetryLogicTest.delaysWithoutJitter(initialDelay, multiplier, retries);
        ExponentialBackoffRetryLogicTest.assertDelaysApproximatelyEqual(delaysWithoutJitter, scheduleDelays, jitterFactor);
    }

    @Test
    void doesNotRetryWhenMaxRetryTimeExceeded() throws Exception {
        long retryStart = Clock.SYSTEM.millis();
        int initialDelay = 100;
        int multiplier = 2;
        long maxRetryTimeMs = 45L;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).thenReturn((Object)retryStart).thenReturn((Object)(retryStart + maxRetryTimeMs - 5L)).thenReturn((Object)(retryStart + maxRetryTimeMs + 7L));
        ExponentialBackoffRetryLogic logic = this.newRetryLogic(maxRetryTimeMs, initialDelay, multiplier, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        SessionExpiredException error = ExponentialBackoffRetryLogicTest.sessionExpired();
        Mockito.when((Object)((Void)workMock.get())).thenThrow(new Throwable[]{error});
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> logic.retry(workMock));
        Assertions.assertEquals((Object)error, (Object)e);
        ((Clock)Mockito.verify((Object)clock)).sleep((long)initialDelay);
        ((Clock)Mockito.verify((Object)clock)).sleep((long)(initialDelay * multiplier));
        ((Supplier)Mockito.verify(workMock, (VerificationMode)Mockito.times((int)3))).get();
    }

    @Test
    void doesNotRetryWhenMaxRetryTimeExceededAsync() {
        long retryStart = Clock.SYSTEM.millis();
        int initialDelay = 100;
        int multiplier = 2;
        long maxRetryTimeMs = 45L;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).thenReturn((Object)retryStart).thenReturn((Object)(retryStart + maxRetryTimeMs - 5L)).thenReturn((Object)(retryStart + maxRetryTimeMs + 7L));
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(maxRetryTimeMs, initialDelay, multiplier, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        SessionExpiredException error = ExponentialBackoffRetryLogicTest.sessionExpired();
        Mockito.when((Object)((CompletionStage)workMock.get())).thenReturn((Object)Futures.failedFuture((Throwable)error));
        CompletionStage future = retryLogic.retryAsync(workMock);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> TestUtil.await(future));
        Assertions.assertEquals((Object)error, (Object)e);
        List<Long> scheduleDelays = this.eventExecutor.scheduleDelays();
        Assertions.assertEquals((int)2, (int)scheduleDelays.size());
        Assertions.assertEquals((int)initialDelay, (int)scheduleDelays.get(0).intValue());
        Assertions.assertEquals((int)(initialDelay * multiplier), (int)scheduleDelays.get(1).intValue());
        ((Supplier)Mockito.verify(workMock, (VerificationMode)Mockito.times((int)3))).get();
    }

    @Test
    void doesNotRetryWhenMaxRetryTimeExceededRx() {
        long retryStart = Clock.SYSTEM.millis();
        int initialDelay = 100;
        int multiplier = 2;
        long maxRetryTimeMs = 45L;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).thenReturn((Object)retryStart).thenReturn((Object)(retryStart + maxRetryTimeMs - 5L)).thenReturn((Object)(retryStart + maxRetryTimeMs + 7L));
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(maxRetryTimeMs, initialDelay, multiplier, 0.0, clock);
        SessionExpiredException error = ExponentialBackoffRetryLogicTest.sessionExpired();
        AtomicInteger executionCount = new AtomicInteger();
        Publisher publisher = retryLogic.retryRx((Publisher)Mono.error((Throwable)error).doOnTerminate(executionCount::getAndIncrement));
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> TestUtil.await(publisher));
        Assertions.assertEquals((Object)error, (Object)e);
        List<Long> scheduleDelays = this.eventExecutor.scheduleDelays();
        Assertions.assertEquals((int)2, (int)scheduleDelays.size());
        Assertions.assertEquals((int)initialDelay, (int)scheduleDelays.get(0).intValue());
        Assertions.assertEquals((int)(initialDelay * multiplier), (int)scheduleDelays.get(1).intValue());
        MatcherAssert.assertThat((Object)executionCount.get(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    void sleepsOnServiceUnavailableException() throws Exception {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic logic = this.newRetryLogic(1L, 42L, 1.0, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        ServiceUnavailableException error = ExponentialBackoffRetryLogicTest.serviceUnavailable();
        Mockito.when((Object)((Void)workMock.get())).thenThrow(new Throwable[]{error}).thenReturn(null);
        Assertions.assertNull((Object)logic.retry(workMock));
        ((Supplier)Mockito.verify(workMock, (VerificationMode)Mockito.times((int)2))).get();
        ((Clock)Mockito.verify((Object)clock)).sleep(42L);
    }

    @Test
    void schedulesRetryOnServiceUnavailableExceptionAsync() {
        String result = "The Result";
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(1L, 42L, 1.0, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        ServiceUnavailableException error = ExponentialBackoffRetryLogicTest.serviceUnavailable();
        Mockito.when((Object)((CompletionStage)workMock.get())).thenReturn((Object)Futures.failedFuture((Throwable)error)).thenReturn(CompletableFuture.completedFuture(result));
        Assertions.assertEquals((Object)result, TestUtil.await(retryLogic.retryAsync(workMock)));
        ((Supplier)Mockito.verify(workMock, (VerificationMode)Mockito.times((int)2))).get();
        List<Long> scheduleDelays = this.eventExecutor.scheduleDelays();
        Assertions.assertEquals((int)1, (int)scheduleDelays.size());
        Assertions.assertEquals((int)42, (int)scheduleDelays.get(0).intValue());
    }

    @Test
    void sleepsOnSessionExpiredException() throws Exception {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic logic = this.newRetryLogic(1L, 4242L, 1.0, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        SessionExpiredException error = ExponentialBackoffRetryLogicTest.sessionExpired();
        Mockito.when((Object)((Void)workMock.get())).thenThrow(new Throwable[]{error}).thenReturn(null);
        Assertions.assertNull((Object)logic.retry(workMock));
        ((Supplier)Mockito.verify(workMock, (VerificationMode)Mockito.times((int)2))).get();
        ((Clock)Mockito.verify((Object)clock)).sleep(4242L);
    }

    @Test
    void schedulesRetryOnSessionExpiredExceptionAsync() {
        String result = "The Result";
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(1L, 4242L, 1.0, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        SessionExpiredException error = ExponentialBackoffRetryLogicTest.sessionExpired();
        Mockito.when((Object)((CompletionStage)workMock.get())).thenReturn((Object)Futures.failedFuture((Throwable)error)).thenReturn(CompletableFuture.completedFuture(result));
        Assertions.assertEquals((Object)result, TestUtil.await(retryLogic.retryAsync(workMock)));
        ((Supplier)Mockito.verify(workMock, (VerificationMode)Mockito.times((int)2))).get();
        List<Long> scheduleDelays = this.eventExecutor.scheduleDelays();
        Assertions.assertEquals((int)1, (int)scheduleDelays.size());
        Assertions.assertEquals((int)4242, (int)scheduleDelays.get(0).intValue());
    }

    @Test
    void sleepsOnTransientException() throws Exception {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic logic = this.newRetryLogic(1L, 23L, 1.0, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        TransientException error = ExponentialBackoffRetryLogicTest.transientException();
        Mockito.when((Object)((Void)workMock.get())).thenThrow(new Throwable[]{error}).thenReturn(null);
        Assertions.assertNull((Object)logic.retry(workMock));
        ((Supplier)Mockito.verify(workMock, (VerificationMode)Mockito.times((int)2))).get();
        ((Clock)Mockito.verify((Object)clock)).sleep(23L);
    }

    @Test
    void schedulesRetryOnTransientExceptionAsync() {
        String result = "The Result";
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(1L, 23L, 1.0, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        TransientException error = ExponentialBackoffRetryLogicTest.transientException();
        Mockito.when((Object)((CompletionStage)workMock.get())).thenReturn((Object)Futures.failedFuture((Throwable)error)).thenReturn(CompletableFuture.completedFuture(result));
        Assertions.assertEquals((Object)result, TestUtil.await(retryLogic.retryAsync(workMock)));
        ((Supplier)Mockito.verify(workMock, (VerificationMode)Mockito.times((int)2))).get();
        List<Long> scheduleDelays = this.eventExecutor.scheduleDelays();
        Assertions.assertEquals((int)1, (int)scheduleDelays.size());
        Assertions.assertEquals((int)23, (int)scheduleDelays.get(0).intValue());
    }

    @Test
    void throwsWhenUnknownError() throws Exception {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic logic = this.newRetryLogic(1L, 1L, 1.0, 1.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        IllegalStateException error = new IllegalStateException();
        Mockito.when((Object)((Void)workMock.get())).thenThrow(new Throwable[]{error});
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> logic.retry(workMock));
        Assertions.assertEquals((Object)error, (Object)e);
        ((Supplier)Mockito.verify(workMock)).get();
        ((Clock)Mockito.verify((Object)clock, (VerificationMode)Mockito.never())).sleep(ArgumentMatchers.anyLong());
    }

    @Test
    void doesNotRetryOnUnknownErrorAsync() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(1L, 1L, 1.0, 1.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        IllegalStateException error = new IllegalStateException();
        Mockito.when((Object)((CompletionStage)workMock.get())).thenReturn((Object)Futures.failedFuture((Throwable)error));
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> TestUtil.await(retryLogic.retryAsync(workMock)));
        Assertions.assertEquals((Object)error, (Object)e);
        ((Supplier)Mockito.verify(workMock)).get();
        Assertions.assertEquals((int)0, (int)this.eventExecutor.scheduleDelays().size());
    }

    @Test
    void throwsWhenTransactionTerminatedError() throws Exception {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic logic = this.newRetryLogic(1L, 13L, 1.0, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        TransientException error = new TransientException("Neo.TransientError.Transaction.Terminated", "");
        Mockito.when((Object)((Void)workMock.get())).thenThrow(new Throwable[]{error}).thenReturn(null);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> logic.retry(workMock));
        Assertions.assertEquals((Object)error, (Object)e);
        ((Supplier)Mockito.verify(workMock)).get();
        ((Clock)Mockito.verify((Object)clock, (VerificationMode)Mockito.never())).sleep(13L);
    }

    @Test
    void doesNotRetryOnTransactionTerminatedErrorAsync() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(1L, 13L, 1.0, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        TransientException error = new TransientException("Neo.TransientError.Transaction.Terminated", "");
        Mockito.when((Object)((CompletionStage)workMock.get())).thenReturn((Object)Futures.failedFuture((Throwable)error));
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> TestUtil.await(retryLogic.retryAsync(workMock)));
        Assertions.assertEquals((Object)error, (Object)e);
        ((Supplier)Mockito.verify(workMock)).get();
        Assertions.assertEquals((int)0, (int)this.eventExecutor.scheduleDelays().size());
    }

    @Test
    void throwsWhenTransactionLockClientStoppedError() throws Exception {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic logic = this.newRetryLogic(1L, 13L, 1.0, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        TransientException error = new TransientException("Neo.TransientError.Transaction.LockClientStopped", "");
        Mockito.when((Object)((Void)workMock.get())).thenThrow(new Throwable[]{error}).thenReturn(null);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> logic.retry(workMock));
        Assertions.assertEquals((Object)error, (Object)e);
        ((Supplier)Mockito.verify(workMock)).get();
        ((Clock)Mockito.verify((Object)clock, (VerificationMode)Mockito.never())).sleep(13L);
    }

    @Test
    void doesNotRetryOnTransactionLockClientStoppedErrorAsync() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(1L, 15L, 1.0, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        TransientException error = new TransientException("Neo.TransientError.Transaction.LockClientStopped", "");
        Mockito.when((Object)((CompletionStage)workMock.get())).thenReturn((Object)Futures.failedFuture((Throwable)error));
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> TestUtil.await(retryLogic.retryAsync(workMock)));
        Assertions.assertEquals((Object)error, (Object)e);
        ((Supplier)Mockito.verify(workMock)).get();
        Assertions.assertEquals((int)0, (int)this.eventExecutor.scheduleDelays().size());
    }

    @ParameterizedTest
    @MethodSource(value={"canBeRetriedErrors"})
    void schedulesRetryOnErrorRx(Exception error) {
        String result = "The Result";
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(1L, 4242L, 1.0, 0.0, clock);
        Mono<String> publisher = this.createMono(result, error);
        Mono single = Flux.from((Publisher)retryLogic.retryRx(publisher)).single();
        Assertions.assertEquals((Object)result, TestUtil.await(single));
        List<Long> scheduleDelays = this.eventExecutor.scheduleDelays();
        Assertions.assertEquals((int)1, (int)scheduleDelays.size());
        Assertions.assertEquals((int)4242, (int)scheduleDelays.get(0).intValue());
    }

    @ParameterizedTest
    @MethodSource(value={"cannotBeRetriedErrors"})
    void scheduleNoRetryOnErrorRx(Exception error) {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(1L, 10L, 1.0, 1.0, clock);
        Mono single = Flux.from((Publisher)retryLogic.retryRx((Publisher)Mono.error((Throwable)error))).single();
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> TestUtil.await(single));
        Assertions.assertEquals((Object)error, (Object)e);
        Assertions.assertEquals((int)0, (int)this.eventExecutor.scheduleDelays().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void throwsWhenSleepInterrupted() throws Exception {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        ((Clock)Mockito.doThrow((Throwable[])new Throwable[]{new InterruptedException()}).when((Object)clock)).sleep(1L);
        ExponentialBackoffRetryLogic logic = this.newRetryLogic(1L, 1L, 1.0, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        Mockito.when((Object)((Void)workMock.get())).thenThrow(new Throwable[]{ExponentialBackoffRetryLogicTest.serviceUnavailable()});
        try {
            IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> logic.retry(workMock));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(InterruptedException.class));
        }
        finally {
            Thread.interrupted();
        }
    }

    @Test
    void collectsSuppressedErrors() throws Exception {
        long maxRetryTime = 20L;
        int initialDelay = 15;
        int multiplier = 2;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).thenReturn((Object)0L).thenReturn((Object)10L).thenReturn((Object)15L).thenReturn((Object)25L);
        ExponentialBackoffRetryLogic logic = this.newRetryLogic(maxRetryTime, initialDelay, multiplier, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        SessionExpiredException error1 = ExponentialBackoffRetryLogicTest.sessionExpired();
        SessionExpiredException error2 = ExponentialBackoffRetryLogicTest.sessionExpired();
        ServiceUnavailableException error3 = ExponentialBackoffRetryLogicTest.serviceUnavailable();
        TransientException error4 = ExponentialBackoffRetryLogicTest.transientException();
        Mockito.when((Object)((Void)workMock.get())).thenThrow(new Throwable[]{error1, error2, error3, error4}).thenReturn(null);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> logic.retry(workMock));
        Assertions.assertEquals((Object)error4, (Object)e);
        Throwable[] suppressed = e.getSuppressed();
        Assertions.assertEquals((int)3, (int)suppressed.length);
        Assertions.assertEquals((Object)error1, (Object)suppressed[0]);
        Assertions.assertEquals((Object)error2, (Object)suppressed[1]);
        Assertions.assertEquals((Object)((Object)error3), (Object)suppressed[2]);
        ((Supplier)Mockito.verify(workMock, (VerificationMode)Mockito.times((int)4))).get();
        ((Clock)Mockito.verify((Object)clock, (VerificationMode)Mockito.times((int)3))).sleep(ArgumentMatchers.anyLong());
        ((Clock)Mockito.verify((Object)clock)).sleep((long)initialDelay);
        ((Clock)Mockito.verify((Object)clock)).sleep((long)(initialDelay * multiplier));
        ((Clock)Mockito.verify((Object)clock)).sleep((long)(initialDelay * multiplier * multiplier));
    }

    @Test
    void collectsSuppressedErrorsAsync() {
        String result = "The Result";
        long maxRetryTime = 20L;
        int initialDelay = 15;
        int multiplier = 2;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).thenReturn((Object)0L).thenReturn((Object)10L).thenReturn((Object)15L).thenReturn((Object)25L);
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(maxRetryTime, initialDelay, multiplier, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        SessionExpiredException error1 = ExponentialBackoffRetryLogicTest.sessionExpired();
        SessionExpiredException error2 = ExponentialBackoffRetryLogicTest.sessionExpired();
        ServiceUnavailableException error3 = ExponentialBackoffRetryLogicTest.serviceUnavailable();
        TransientException error4 = ExponentialBackoffRetryLogicTest.transientException();
        Mockito.when((Object)((CompletionStage)workMock.get())).thenReturn((Object)Futures.failedFuture((Throwable)error1)).thenReturn((Object)Futures.failedFuture((Throwable)error2)).thenReturn((Object)Futures.failedFuture((Throwable)error3)).thenReturn((Object)Futures.failedFuture((Throwable)error4)).thenReturn(CompletableFuture.completedFuture(result));
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> TestUtil.await(retryLogic.retryAsync(workMock)));
        Assertions.assertEquals((Object)error4, (Object)e);
        Throwable[] suppressed = e.getSuppressed();
        Assertions.assertEquals((int)3, (int)suppressed.length);
        Assertions.assertEquals((Object)error1, (Object)suppressed[0]);
        Assertions.assertEquals((Object)error2, (Object)suppressed[1]);
        Assertions.assertEquals((Object)((Object)error3), (Object)suppressed[2]);
        ((Supplier)Mockito.verify(workMock, (VerificationMode)Mockito.times((int)4))).get();
        List<Long> scheduleDelays = this.eventExecutor.scheduleDelays();
        Assertions.assertEquals((int)3, (int)scheduleDelays.size());
        Assertions.assertEquals((int)initialDelay, (int)scheduleDelays.get(0).intValue());
        Assertions.assertEquals((int)(initialDelay * multiplier), (int)scheduleDelays.get(1).intValue());
        Assertions.assertEquals((int)(initialDelay * multiplier * multiplier), (int)scheduleDelays.get(2).intValue());
    }

    @Test
    void collectsSuppressedErrorsRx() throws Exception {
        long maxRetryTime = 20L;
        int initialDelay = 15;
        int multiplier = 2;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).thenReturn((Object)0L).thenReturn((Object)10L).thenReturn((Object)15L).thenReturn((Object)25L);
        ExponentialBackoffRetryLogic logic = this.newRetryLogic(maxRetryTime, initialDelay, multiplier, 0.0, clock);
        SessionExpiredException error1 = ExponentialBackoffRetryLogicTest.sessionExpired();
        SessionExpiredException error2 = ExponentialBackoffRetryLogicTest.sessionExpired();
        ServiceUnavailableException error3 = ExponentialBackoffRetryLogicTest.serviceUnavailable();
        TransientException error4 = ExponentialBackoffRetryLogicTest.transientException();
        Mono<String> mono = this.createMono("A result", new Exception[]{error1, error2, error3, error4});
        StepVerifier.create((Publisher)logic.retryRx(mono)).expectErrorSatisfies(e -> {
            Assertions.assertEquals((Object)error4, (Object)e);
            Throwable[] suppressed = e.getSuppressed();
            Assertions.assertEquals((int)3, (int)suppressed.length);
            Assertions.assertEquals((Object)error1, (Object)suppressed[0]);
            Assertions.assertEquals((Object)error2, (Object)suppressed[1]);
            Assertions.assertEquals((Object)((Object)error3), (Object)suppressed[2]);
        }).verify();
        List<Long> scheduleDelays = this.eventExecutor.scheduleDelays();
        Assertions.assertEquals((int)3, (int)scheduleDelays.size());
        Assertions.assertEquals((int)initialDelay, (int)scheduleDelays.get(0).intValue());
        Assertions.assertEquals((int)(initialDelay * multiplier), (int)scheduleDelays.get(1).intValue());
        Assertions.assertEquals((int)(initialDelay * multiplier * multiplier), (int)scheduleDelays.get(2).intValue());
    }

    @Test
    void doesNotCollectSuppressedErrorsWhenSameErrorIsThrown() throws Exception {
        long maxRetryTime = 20L;
        int initialDelay = 15;
        int multiplier = 2;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).thenReturn((Object)0L).thenReturn((Object)10L).thenReturn((Object)25L);
        ExponentialBackoffRetryLogic logic = this.newRetryLogic(maxRetryTime, initialDelay, multiplier, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        SessionExpiredException error = ExponentialBackoffRetryLogicTest.sessionExpired();
        Mockito.when((Object)((Void)workMock.get())).thenThrow(new Throwable[]{error});
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> logic.retry(workMock));
        Assertions.assertEquals((Object)error, (Object)e);
        Assertions.assertEquals((int)0, (int)e.getSuppressed().length);
        ((Supplier)Mockito.verify(workMock, (VerificationMode)Mockito.times((int)3))).get();
        ((Clock)Mockito.verify((Object)clock, (VerificationMode)Mockito.times((int)2))).sleep(ArgumentMatchers.anyLong());
        ((Clock)Mockito.verify((Object)clock)).sleep((long)initialDelay);
        ((Clock)Mockito.verify((Object)clock)).sleep((long)(initialDelay * multiplier));
    }

    @Test
    void doesNotCollectSuppressedErrorsWhenSameErrorIsThrownAsync() {
        long maxRetryTime = 20L;
        int initialDelay = 15;
        int multiplier = 2;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).thenReturn((Object)0L).thenReturn((Object)10L).thenReturn((Object)25L);
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(maxRetryTime, initialDelay, multiplier, 0.0, clock);
        Supplier workMock = ExponentialBackoffRetryLogicTest.newWorkMock();
        SessionExpiredException error = ExponentialBackoffRetryLogicTest.sessionExpired();
        Mockito.when((Object)((CompletionStage)workMock.get())).thenReturn((Object)Futures.failedFuture((Throwable)error));
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> TestUtil.await(retryLogic.retryAsync(workMock)));
        Assertions.assertEquals((Object)error, (Object)e);
        Assertions.assertEquals((int)0, (int)e.getSuppressed().length);
        ((Supplier)Mockito.verify(workMock, (VerificationMode)Mockito.times((int)3))).get();
        List<Long> scheduleDelays = this.eventExecutor.scheduleDelays();
        Assertions.assertEquals((int)2, (int)scheduleDelays.size());
        Assertions.assertEquals((int)initialDelay, (int)scheduleDelays.get(0).intValue());
        Assertions.assertEquals((int)(initialDelay * multiplier), (int)scheduleDelays.get(1).intValue());
    }

    @Test
    void doesNotCollectSuppressedErrorsWhenSameErrorIsThrownRx() {
        long maxRetryTime = 20L;
        int initialDelay = 15;
        int multiplier = 2;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).thenReturn((Object)0L).thenReturn((Object)10L).thenReturn((Object)25L);
        ExponentialBackoffRetryLogic retryLogic = this.newRetryLogic(maxRetryTime, initialDelay, multiplier, 0.0, clock);
        SessionExpiredException error = ExponentialBackoffRetryLogicTest.sessionExpired();
        StepVerifier.create((Publisher)retryLogic.retryRx((Publisher)Mono.error((Throwable)error))).expectErrorSatisfies(e -> Assertions.assertEquals((Object)error, (Object)e)).verify();
        List<Long> scheduleDelays = this.eventExecutor.scheduleDelays();
        Assertions.assertEquals((int)2, (int)scheduleDelays.size());
        Assertions.assertEquals((int)initialDelay, (int)scheduleDelays.get(0).intValue());
        Assertions.assertEquals((int)(initialDelay * multiplier), (int)scheduleDelays.get(1).intValue());
    }

    @Test
    void doesRetryOnClientExceptionWithRetryableCause() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, clock, logging);
        AtomicBoolean exceptionThrown = new AtomicBoolean(false);
        String result = (String)logic.retry(() -> {
            if (exceptionThrown.compareAndSet(false, true)) {
                throw ExponentialBackoffRetryLogicTest.clientExceptionWithValidTerminationCause();
            }
            return "Done";
        });
        Assertions.assertEquals((Object)"Done", (Object)result);
    }

    @Test
    void doesRetryOnAuthorizationExpiredException() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, clock, logging);
        AtomicBoolean exceptionThrown = new AtomicBoolean(false);
        String result = (String)logic.retry(() -> {
            if (exceptionThrown.compareAndSet(false, true)) {
                throw ExponentialBackoffRetryLogicTest.authorizationExpiredException();
            }
            return "Done";
        });
        Assertions.assertEquals((Object)"Done", (Object)result);
    }

    @Test
    void doesRetryOnConnectionReadTimeoutException() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, clock, logging);
        AtomicBoolean exceptionThrown = new AtomicBoolean(false);
        String result = (String)logic.retry(() -> {
            if (exceptionThrown.compareAndSet(false, true)) {
                throw ConnectionReadTimeoutException.INSTANCE;
            }
            return "Done";
        });
        Assertions.assertEquals((Object)"Done", (Object)result);
    }

    @Test
    void doesNotRetryOnRandomClientException() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog(ArgumentMatchers.anyString())).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, clock, logging);
        AtomicBoolean exceptionThrown = new AtomicBoolean(false);
        ClientException exception = (ClientException)Assertions.assertThrows(ClientException.class, () -> logic.retry(() -> {
            if (exceptionThrown.compareAndSet(false, true)) {
                throw ExponentialBackoffRetryLogicTest.randomClientException();
            }
            return "Done";
        }));
        Assertions.assertEquals((Object)"Meeh", (Object)exception.getMessage());
    }

    @Test
    void eachRetryIsLogged() {
        int retries = 9;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, clock, logging);
        ExponentialBackoffRetryLogicTest.retry(logic, retries);
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)retries))).warn(ArgumentMatchers.startsWith((String)"Transaction failed and will be retried"), (Throwable)ArgumentMatchers.any(ServiceUnavailableException.class));
    }

    @Test
    void doesRetryOnClientExceptionWithRetryableCauseAsync() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, clock, logging);
        AtomicBoolean exceptionThrown = new AtomicBoolean(false);
        String result = (String)TestUtil.await(logic.retryAsync(() -> {
            if (exceptionThrown.compareAndSet(false, true)) {
                throw ExponentialBackoffRetryLogicTest.clientExceptionWithValidTerminationCause();
            }
            return CompletableFuture.completedFuture("Done");
        }));
        Assertions.assertEquals((Object)"Done", (Object)result);
    }

    @Test
    void doesRetryOnAuthorizationExpiredExceptionAsync() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, clock, logging);
        AtomicBoolean exceptionThrown = new AtomicBoolean(false);
        String result = (String)TestUtil.await(logic.retryAsync(() -> {
            if (exceptionThrown.compareAndSet(false, true)) {
                throw ExponentialBackoffRetryLogicTest.authorizationExpiredException();
            }
            return CompletableFuture.completedFuture("Done");
        }));
        Assertions.assertEquals((Object)"Done", (Object)result);
    }

    @Test
    void doesNotRetryOnRandomClientExceptionAsync() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog(ArgumentMatchers.anyString())).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, clock, logging);
        AtomicBoolean exceptionThrown = new AtomicBoolean(false);
        ClientException exception = (ClientException)Assertions.assertThrows(ClientException.class, () -> TestUtil.await(logic.retryAsync(() -> {
            if (exceptionThrown.compareAndSet(false, true)) {
                throw ExponentialBackoffRetryLogicTest.randomClientException();
            }
            return CompletableFuture.completedFuture("Done");
        })));
        Assertions.assertEquals((Object)"Meeh", (Object)exception.getMessage());
    }

    @Test
    void eachRetryIsLoggedAsync() {
        String result = "The Result";
        int retries = 9;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, clock, logging);
        Assertions.assertEquals((Object)result, TestUtil.await(this.retryAsync(logic, retries, result)));
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)retries))).warn(ArgumentMatchers.startsWith((String)"Async transaction failed and is scheduled to retry"), (Throwable)ArgumentMatchers.any(ServiceUnavailableException.class));
    }

    @Test
    void doesRetryOnClientExceptionWithRetryableCauseRx() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, clock, logging);
        AtomicBoolean exceptionThrown = new AtomicBoolean(false);
        String result = (String)TestUtil.await(Mono.from((Publisher)logic.retryRx((Publisher)Mono.fromSupplier(() -> {
            if (exceptionThrown.compareAndSet(false, true)) {
                throw ExponentialBackoffRetryLogicTest.clientExceptionWithValidTerminationCause();
            }
            return "Done";
        }))));
        Assertions.assertEquals((Object)"Done", (Object)result);
    }

    @Test
    void doesRetryOnAuthorizationExpiredExceptionRx() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, clock, logging);
        AtomicBoolean exceptionThrown = new AtomicBoolean(false);
        String result = (String)TestUtil.await(Mono.from((Publisher)logic.retryRx((Publisher)Mono.fromSupplier(() -> {
            if (exceptionThrown.compareAndSet(false, true)) {
                throw ExponentialBackoffRetryLogicTest.authorizationExpiredException();
            }
            return "Done";
        }))));
        Assertions.assertEquals((Object)"Done", (Object)result);
    }

    @Test
    void doesRetryOnAsyncResourceCleanupRuntimeExceptionRx() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, clock, logging);
        AtomicBoolean exceptionThrown = new AtomicBoolean(false);
        String result = (String)TestUtil.await(Mono.from((Publisher)logic.retryRx((Publisher)Mono.fromSupplier(() -> {
            if (exceptionThrown.compareAndSet(false, true)) {
                throw new RuntimeException("Async resource cleanup failed after", (Throwable)ExponentialBackoffRetryLogicTest.authorizationExpiredException());
            }
            return "Done";
        }))));
        Assertions.assertEquals((Object)"Done", (Object)result);
    }

    @Test
    void doesNotRetryOnRandomClientExceptionRx() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog(ArgumentMatchers.anyString())).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, clock, logging);
        AtomicBoolean exceptionThrown = new AtomicBoolean(false);
        ClientException exception = (ClientException)Assertions.assertThrows(ClientException.class, () -> TestUtil.await(Mono.from((Publisher)logic.retryRx((Publisher)Mono.fromSupplier(() -> {
            if (exceptionThrown.compareAndSet(false, true)) {
                throw ExponentialBackoffRetryLogicTest.randomClientException();
            }
            return "Done";
        })))));
        Assertions.assertEquals((Object)"Meeh", (Object)exception.getMessage());
    }

    @Test
    void eachRetryIsLoggedRx() {
        String result = "The Result";
        int retries = 9;
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, clock, logging);
        Assertions.assertEquals((Object)result, TestUtil.await(Flux.from(this.retryRx(logic, retries, result)).single()));
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)retries))).warn(ArgumentMatchers.startsWith((String)"Reactive transaction failed and is scheduled to retry"), (Throwable)ArgumentMatchers.any(ServiceUnavailableException.class));
    }

    @Test
    void nothingIsLoggedOnFatalFailure() {
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog(ArgumentMatchers.anyString())).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, (Clock)Mockito.mock(Clock.class), logging);
        RuntimeException error = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> logic.retry(() -> {
            throw new RuntimeException("Fatal blocking");
        }));
        Assertions.assertEquals((Object)"Fatal blocking", (Object)error.getMessage());
        Mockito.verifyNoInteractions((Object[])new Object[]{logger});
    }

    @Test
    void nothingIsLoggedOnFatalFailureAsync() {
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog(ArgumentMatchers.anyString())).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, (Clock)Mockito.mock(Clock.class), logging);
        RuntimeException error = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(logic.retryAsync(() -> Futures.failedFuture((Throwable)new RuntimeException("Fatal async")))));
        Assertions.assertEquals((Object)"Fatal async", (Object)error.getMessage());
        Mockito.verifyNoInteractions((Object[])new Object[]{logger});
    }

    @Test
    void nothingIsLoggedOnFatalFailureRx() {
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog(ArgumentMatchers.anyString())).thenReturn((Object)logger);
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(RetrySettings.DEFAULT, (EventExecutorGroup)this.eventExecutor, (Clock)Mockito.mock(Clock.class), logging);
        Publisher retryRx = logic.retryRx((Publisher)Mono.error((Throwable)new RuntimeException("Fatal rx")));
        RuntimeException error = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> TestUtil.await(retryRx));
        Assertions.assertEquals((Object)"Fatal rx", (Object)error.getMessage());
        Mockito.verifyNoInteractions((Object[])new Object[]{logger});
    }

    @Test
    void correctNumberOfRetiesAreLoggedOnFailure() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        RetrySettings settings = RetrySettings.DEFAULT;
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(settings, (EventExecutorGroup)this.eventExecutor, clock, logging);
        ServiceUnavailableException error = (ServiceUnavailableException)Assertions.assertThrows(ServiceUnavailableException.class, () -> this.lambda$correctNumberOfRetiesAreLoggedOnFailure$42((RetryLogic)logic, clock, settings));
        Assertions.assertEquals((Object)"Error", (Object)error.getMessage());
        ((Logger)Mockito.verify((Object)logger)).warn(ArgumentMatchers.startsWith((String)"Transaction failed and will be retried"), (Throwable)ArgumentMatchers.any(ServiceUnavailableException.class));
    }

    @Test
    void correctNumberOfRetiesAreLoggedOnFailureAsync() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        RetrySettings settings = RetrySettings.DEFAULT;
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(settings, (EventExecutorGroup)this.eventExecutor, clock, logging);
        SessionExpiredException error = (SessionExpiredException)Assertions.assertThrows(SessionExpiredException.class, () -> this.lambda$correctNumberOfRetiesAreLoggedOnFailureAsync$43((RetryLogic)logic, clock, settings));
        Assertions.assertEquals((Object)"Session no longer valid", (Object)error.getMessage());
        ((Logger)Mockito.verify((Object)logger)).warn(ArgumentMatchers.startsWith((String)"Async transaction failed and is scheduled to retry"), (Throwable)ArgumentMatchers.any(SessionExpiredException.class));
    }

    @Test
    void correctNumberOfRetiesAreLoggedOnFailureRx() {
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logging.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)logger);
        RetrySettings settings = RetrySettings.DEFAULT;
        ExponentialBackoffRetryLogic logic = new ExponentialBackoffRetryLogic(settings, (EventExecutorGroup)this.eventExecutor, clock, logging);
        AtomicBoolean invoked = new AtomicBoolean(false);
        SessionExpiredException error = (SessionExpiredException)Assertions.assertThrows(SessionExpiredException.class, () -> ExponentialBackoffRetryLogicTest.lambda$correctNumberOfRetiesAreLoggedOnFailureRx$45((RetryLogic)logic, invoked, clock, settings));
        Assertions.assertEquals((Object)"Session no longer valid", (Object)error.getMessage());
        ((Logger)Mockito.verify((Object)logger)).warn(ArgumentMatchers.startsWith((String)"Reactive transaction failed and is scheduled to retry"), (Throwable)ArgumentMatchers.any(SessionExpiredException.class));
    }

    @Test
    void shouldRetryWithBackOffRx() {
        TransientException exception = new TransientException("Unknown", "Retry this error.");
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).thenReturn((Object)0L, (Object[])new Long[]{100L, 200L, 400L, 800L});
        ExponentialBackoffRetryLogic retryLogic = new ExponentialBackoffRetryLogic(500L, 100L, 2.0, 0.0, (EventExecutorGroup)this.eventExecutor, clock, DevNullLogging.DEV_NULL_LOGGING);
        Flux source = Flux.concat((Publisher[])new Publisher[]{Flux.range((int)0, (int)2), Flux.error((Throwable)exception)});
        Flux retriedSource = Flux.from((Publisher)retryLogic.retryRx((Publisher)source));
        StepVerifier.create((Publisher)retriedSource).expectNext((Object)0, (Object)1).expectNext((Object[])new Integer[]{0, 1, 0, 1, 0, 1, 0, 1}).verifyErrorSatisfies(arg_0 -> ExponentialBackoffRetryLogicTest.lambda$shouldRetryWithBackOffRx$46((Exception)exception, arg_0));
        List<Long> delays = this.eventExecutor.scheduleDelays();
        MatcherAssert.assertThat((Object)delays.size(), (Matcher)Matchers.equalTo((Object)4));
        MatcherAssert.assertThat(delays, (Matcher)Matchers.contains((Object[])new Long[]{100L, 200L, 400L, 800L}));
    }

    @Test
    void shouldRetryWithRandomBackOffRx() {
        TransientException exception = new TransientException("Unknown", "Retry this error.");
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.millis()).thenReturn((Object)0L, (Object[])new Long[]{100L, 200L, 400L, 800L});
        ExponentialBackoffRetryLogic retryLogic = new ExponentialBackoffRetryLogic(500L, 100L, 2.0, 0.1, (EventExecutorGroup)this.eventExecutor, clock, DevNullLogging.DEV_NULL_LOGGING);
        Flux source = Flux.concat((Publisher[])new Publisher[]{Flux.range((int)0, (int)2), Flux.error((Throwable)exception)});
        Flux retriedSource = Flux.from((Publisher)retryLogic.retryRx((Publisher)source));
        StepVerifier.create((Publisher)retriedSource).expectNext((Object)0, (Object)1).expectNext((Object[])new Integer[]{0, 1, 0, 1, 0, 1, 0, 1}).verifyErrorSatisfies(arg_0 -> ExponentialBackoffRetryLogicTest.lambda$shouldRetryWithRandomBackOffRx$47((Exception)exception, arg_0));
        List<Long> delays = this.eventExecutor.scheduleDelays();
        MatcherAssert.assertThat((Object)delays.size(), (Matcher)Matchers.equalTo((Object)4));
        MatcherAssert.assertThat((Object)delays.get(0), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(90L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(110L))));
        MatcherAssert.assertThat((Object)delays.get(1), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(180L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(220L))));
        MatcherAssert.assertThat((Object)delays.get(2), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(260L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(440L))));
        MatcherAssert.assertThat((Object)delays.get(3), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(720L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(880L))));
    }

    private static void retry(ExponentialBackoffRetryLogic retryLogic, final int times) {
        retryLogic.retry((Supplier)new Supplier<Void>(){
            int invoked;

            @Override
            public Void get() {
                if (this.invoked < times) {
                    ++this.invoked;
                    throw ExponentialBackoffRetryLogicTest.serviceUnavailable();
                }
                return null;
            }
        });
    }

    private CompletionStage<Object> retryAsync(ExponentialBackoffRetryLogic retryLogic, final int times, final Object result) {
        return retryLogic.retryAsync((Supplier)new Supplier<CompletionStage<Object>>(){
            int invoked;

            @Override
            public CompletionStage<Object> get() {
                if (this.invoked < times) {
                    ++this.invoked;
                    return Futures.failedFuture((Throwable)ExponentialBackoffRetryLogicTest.serviceUnavailable());
                }
                return CompletableFuture.completedFuture(result);
            }
        });
    }

    private Publisher<Object> retryRx(ExponentialBackoffRetryLogic retryLogic, int times, Object result) {
        AtomicInteger invoked = new AtomicInteger();
        return retryLogic.retryRx((Publisher)Mono.create(e -> {
            if (invoked.get() < times) {
                invoked.getAndIncrement();
                e.error((Throwable)ExponentialBackoffRetryLogicTest.serviceUnavailable());
            } else {
                e.success(result);
            }
        }));
    }

    private static List<Long> delaysWithoutJitter(long initialDelay, double multiplier, int count) {
        ArrayList<Long> values = new ArrayList<Long>();
        long delay = initialDelay;
        do {
            values.add(delay);
            delay = (long)((double)delay * multiplier);
        } while (--count > 0);
        return values;
    }

    private static List<Long> sleepValues(Clock clockMock, int expectedCount) throws InterruptedException {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Long.TYPE);
        ((Clock)Mockito.verify((Object)clockMock, (VerificationMode)Mockito.times((int)expectedCount))).sleep(((Long)captor.capture()).longValue());
        return captor.getAllValues();
    }

    private ExponentialBackoffRetryLogic newRetryLogic(long maxRetryTimeMs, long initialRetryDelayMs, double multiplier, double jitterFactor, Clock clock) {
        return new ExponentialBackoffRetryLogic(maxRetryTimeMs, initialRetryDelayMs, multiplier, jitterFactor, (EventExecutorGroup)this.eventExecutor, clock, DevNullLogging.DEV_NULL_LOGGING);
    }

    private static ServiceUnavailableException serviceUnavailable() {
        return new ServiceUnavailableException("");
    }

    private static RuntimeException clientExceptionWithValidTerminationCause() {
        return new ClientException("\u00af\\_(\u30c4)_/\u00af", (Throwable)ExponentialBackoffRetryLogicTest.serviceUnavailable());
    }

    private static RuntimeException randomClientException() {
        return new ClientException("Meeh");
    }

    private static SessionExpiredException sessionExpired() {
        return new SessionExpiredException("");
    }

    private static TransientException transientException() {
        return new TransientException("", "");
    }

    private static AuthorizationExpiredException authorizationExpiredException() {
        return new AuthorizationExpiredException("", "");
    }

    private static <T> Supplier<T> newWorkMock() {
        return (Supplier)Mockito.mock(Supplier.class);
    }

    private static void assertDelaysApproximatelyEqual(List<Long> expectedDelays, List<Long> actualDelays, double delta) {
        Assertions.assertEquals((int)expectedDelays.size(), (int)actualDelays.size());
        for (int i = 0; i < actualDelays.size(); ++i) {
            double actualValue = actualDelays.get(i).doubleValue();
            long expectedValue = expectedDelays.get(i);
            MatcherAssert.assertThat((Object)actualValue, (Matcher)Matchers.closeTo((double)expectedValue, (double)((double)expectedValue * delta)));
        }
    }

    private <T> Mono<T> createMono(T result, Exception ... errors) {
        AtomicInteger executionCount = new AtomicInteger();
        Iterator<Exception> iterator = Arrays.asList(errors).iterator();
        return Mono.create(e -> {
            if (iterator.hasNext()) {
                e.error((Throwable)iterator.next());
            } else {
                e.success(result);
            }
        }).doOnTerminate(executionCount::getAndIncrement);
    }

    private static Stream<Exception> canBeRetriedErrors() {
        return Stream.of(new Exception[]{ExponentialBackoffRetryLogicTest.transientException(), ExponentialBackoffRetryLogicTest.sessionExpired(), ExponentialBackoffRetryLogicTest.serviceUnavailable()});
    }

    private static Stream<Exception> cannotBeRetriedErrors() {
        return Stream.of(new IllegalStateException(), new TransientException("Neo.TransientError.Transaction.Terminated", ""), new TransientException("Neo.TransientError.Transaction.LockClientStopped", ""));
    }

    private static /* synthetic */ void lambda$shouldRetryWithRandomBackOffRx$47(Exception exception, Throwable e) {
        MatcherAssert.assertThat((Object)e, (Matcher)Matchers.equalTo((Object)exception));
    }

    private static /* synthetic */ void lambda$shouldRetryWithBackOffRx$46(Exception exception, Throwable e) {
        MatcherAssert.assertThat((Object)e, (Matcher)Matchers.equalTo((Object)exception));
    }

    private static /* synthetic */ void lambda$correctNumberOfRetiesAreLoggedOnFailureRx$45(RetryLogic logic, AtomicBoolean invoked, Clock clock, RetrySettings settings) throws Throwable {
        TestUtil.await(logic.retryRx((Publisher)Mono.create(e -> {
            if (invoked.get()) {
                Mockito.when((Object)clock.millis()).thenReturn((Object)(settings.maxRetryTimeMs() + 42L));
            } else {
                invoked.set(true);
            }
            e.error((Throwable)new SessionExpiredException("Session no longer valid"));
        })));
    }

    private /* synthetic */ void lambda$correctNumberOfRetiesAreLoggedOnFailureAsync$43(RetryLogic logic, final Clock clock, final RetrySettings settings) throws Throwable {
        TestUtil.await(logic.retryAsync((Supplier)new Supplier<CompletionStage<Void>>(){
            volatile boolean invoked;

            @Override
            public CompletionStage<Void> get() {
                if (this.invoked) {
                    Mockito.when((Object)clock.millis()).thenReturn((Object)(settings.maxRetryTimeMs() + 42L));
                } else {
                    this.invoked = true;
                }
                return Futures.failedFuture((Throwable)new SessionExpiredException("Session no longer valid"));
            }
        }));
    }

    private /* synthetic */ void lambda$correctNumberOfRetiesAreLoggedOnFailure$42(RetryLogic logic, final Clock clock, final RetrySettings settings) throws Throwable {
        logic.retry((Supplier)new Supplier<Long>(){
            boolean invoked;

            @Override
            public Long get() {
                if (this.invoked) {
                    Mockito.when((Object)clock.millis()).thenReturn((Object)(settings.maxRetryTimeMs() + 42L));
                } else {
                    this.invoked = true;
                }
                throw new ServiceUnavailableException("Error");
            }
        });
    }
}

