/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.junit.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.exceptions.AuthenticationException;
import org.neo4j.driver.exceptions.AuthorizationExpiredException;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.DatabaseException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.TokenExpiredException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.internal.util.ErrorUtil;

class ErrorUtilTest {
    ErrorUtilTest() {
    }

    @Test
    void shouldCreateAuthenticationException() {
        String code = "Neo.ClientError.Security.Unauthorized";
        String message = "Wrong credentials";
        Neo4jException error = ErrorUtil.newNeo4jError((String)code, (String)message);
        MatcherAssert.assertThat((Object)error, (Matcher)Matchers.instanceOf(AuthenticationException.class));
        Assertions.assertEquals((Object)code, (Object)error.code());
        Assertions.assertEquals((Object)message, (Object)error.getMessage());
    }

    @Test
    void shouldCreateClientException() {
        String code = "Neo.ClientError.Transaction.InvalidBookmark";
        String message = "Wrong bookmark";
        Neo4jException error = ErrorUtil.newNeo4jError((String)code, (String)message);
        MatcherAssert.assertThat((Object)error, (Matcher)Matchers.instanceOf(ClientException.class));
        Assertions.assertEquals((Object)code, (Object)error.code());
        Assertions.assertEquals((Object)message, (Object)error.getMessage());
    }

    @Test
    void shouldCreateTransientException() {
        String code = "Neo.TransientError.Transaction.DeadlockDetected";
        String message = "Deadlock occurred";
        Neo4jException error = ErrorUtil.newNeo4jError((String)code, (String)message);
        MatcherAssert.assertThat((Object)error, (Matcher)Matchers.instanceOf(TransientException.class));
        Assertions.assertEquals((Object)code, (Object)error.code());
        Assertions.assertEquals((Object)message, (Object)error.getMessage());
    }

    @Test
    void shouldCreateDatabaseException() {
        String code = "Neo.DatabaseError.Transaction.TransactionLogError";
        String message = "Failed to write the transaction log";
        Neo4jException error = ErrorUtil.newNeo4jError((String)code, (String)message);
        MatcherAssert.assertThat((Object)error, (Matcher)Matchers.instanceOf(DatabaseException.class));
        Assertions.assertEquals((Object)code, (Object)error.code());
        Assertions.assertEquals((Object)message, (Object)error.getMessage());
    }

    @Test
    void shouldCreateDatabaseExceptionWhenErrorCodeIsWrong() {
        String code = "WrongErrorCode";
        String message = "Some really strange error";
        Neo4jException error = ErrorUtil.newNeo4jError((String)code, (String)message);
        MatcherAssert.assertThat((Object)error, (Matcher)Matchers.instanceOf(DatabaseException.class));
        Assertions.assertEquals((Object)code, (Object)error.code());
        Assertions.assertEquals((Object)message, (Object)error.getMessage());
    }

    @Test
    void shouldTreatNotNeo4jExceptionAsFatal() {
        Assertions.assertTrue((boolean)ErrorUtil.isFatal((Throwable)new IOException("IO failed!")));
    }

    @Test
    void shouldTreatProtocolErrorAsFatal() {
        Assertions.assertTrue((boolean)ErrorUtil.isFatal((Throwable)new ClientException("Neo.ClientError.Request.Invalid", "Illegal request")));
        Assertions.assertTrue((boolean)ErrorUtil.isFatal((Throwable)new ClientException("Neo.ClientError.Request.InvalidFormat", "Wrong format")));
        Assertions.assertTrue((boolean)ErrorUtil.isFatal((Throwable)new ClientException("Neo.ClientError.Request.TransactionRequired", "No tx!")));
    }

    @Test
    void shouldTreatAuthenticationExceptionAsNonFatal() {
        Assertions.assertFalse((boolean)ErrorUtil.isFatal((Throwable)new AuthenticationException("Neo.ClientError.Security.Unauthorized", "")));
    }

    @Test
    void shouldTreatClientExceptionAsNonFatal() {
        Assertions.assertFalse((boolean)ErrorUtil.isFatal((Throwable)new ClientException("Neo.ClientError.Transaction.ConstraintsChanged", "")));
    }

    @Test
    void shouldTreatDatabaseExceptionAsFatal() {
        Assertions.assertTrue((boolean)ErrorUtil.isFatal((Throwable)new ClientException("Neo.DatabaseError.Schema.ConstraintCreationFailed", "")));
    }

    @Test
    void shouldCreateConnectionTerminatedError() {
        ServiceUnavailableException error = ErrorUtil.newConnectionTerminatedError();
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.startsWith((String)"Connection to the database terminated"));
    }

    @Test
    void shouldCreateConnectionTerminatedErrorWithNullReason() {
        ServiceUnavailableException error = ErrorUtil.newConnectionTerminatedError(null);
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.startsWith((String)"Connection to the database terminated"));
    }

    @Test
    void shouldCreateConnectionTerminatedErrorWithReason() {
        String reason = "Thread interrupted";
        ServiceUnavailableException error = ErrorUtil.newConnectionTerminatedError((String)reason);
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.startsWith((String)"Connection to the database terminated"));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)reason));
    }

    @Test
    void shouldCreateAuthorizationExpiredException() {
        String code = "Neo.ClientError.Security.AuthorizationExpired";
        String message = "Expired authorization info";
        Neo4jException error = ErrorUtil.newNeo4jError((String)code, (String)message);
        MatcherAssert.assertThat((Object)error, (Matcher)Matchers.instanceOf(AuthorizationExpiredException.class));
        Assertions.assertEquals((Object)code, (Object)error.code());
        Assertions.assertEquals((Object)message, (Object)error.getMessage());
    }

    @Test
    void shouldCreateTokenExpiredException() {
        String code = "Neo.ClientError.Security.TokenExpired";
        String message = "message";
        Neo4jException error = ErrorUtil.newNeo4jError((String)code, (String)message);
        MatcherAssert.assertThat((Object)error, (Matcher)Matchers.instanceOf(TokenExpiredException.class));
        Assertions.assertEquals((Object)code, (Object)error.code());
        Assertions.assertEquals((Object)message, (Object)error.getMessage());
    }
}

