/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import io.netty.bootstrap.Bootstrap;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.net.ServerAddress;

public class FailingConnectionDriverFactory
extends DriverFactory {
    private final AtomicReference<Throwable> nextRunFailure = new AtomicReference();

    protected ConnectionPool createConnectionPool(AuthToken authToken, SecurityPlan securityPlan, Bootstrap bootstrap, MetricsProvider metricsProvider, Config config, boolean ownsEventLoopGroup, RoutingContext routingContext) {
        ConnectionPool pool = super.createConnectionPool(authToken, securityPlan, bootstrap, metricsProvider, config, ownsEventLoopGroup, routingContext);
        return new ConnectionPoolWithFailingConnections(pool, this.nextRunFailure);
    }

    public void setNextRunFailure(Throwable failure) {
        this.nextRunFailure.set(failure);
    }

    private static class FailingConnection
    implements Connection {
        final Connection delegate;
        final AtomicReference<Throwable> nextRunFailure;
        final AtomicInteger count = new AtomicInteger(2);

        FailingConnection(Connection delegate, AtomicReference<Throwable> nextRunFailure) {
            this.delegate = delegate;
            this.nextRunFailure = nextRunFailure;
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        public void enableAutoRead() {
            this.delegate.enableAutoRead();
        }

        public void disableAutoRead() {
            this.delegate.disableAutoRead();
        }

        public void write(Message message, ResponseHandler handler) {
            if (this.tryFail(handler, null)) {
                return;
            }
            this.delegate.write(message, handler);
        }

        public void write(Message message1, ResponseHandler handler1, Message message2, ResponseHandler handler2) {
            if (this.tryFail(handler1, handler2)) {
                return;
            }
            this.delegate.write(message1, handler1, message2, handler2);
        }

        public void writeAndFlush(Message message, ResponseHandler handler) {
            if (this.tryFail(handler, null)) {
                return;
            }
            this.delegate.writeAndFlush(message, handler);
        }

        public void writeAndFlush(Message message1, ResponseHandler handler1, Message message2, ResponseHandler handler2) {
            if (this.tryFail(handler1, handler2)) {
                return;
            }
            this.delegate.writeAndFlush(message1, handler1, message2, handler2);
        }

        public CompletionStage<Void> reset() {
            return this.delegate.reset();
        }

        public CompletionStage<Void> release() {
            return this.delegate.release();
        }

        public void terminateAndRelease(String reason) {
            this.delegate.terminateAndRelease(reason);
        }

        public String serverAgent() {
            return this.delegate.serverAgent();
        }

        public BoltServerAddress serverAddress() {
            return this.delegate.serverAddress();
        }

        public ServerVersion serverVersion() {
            return this.delegate.serverVersion();
        }

        public BoltProtocol protocol() {
            return this.delegate.protocol();
        }

        public void flush() {
            if (this.tryFail(null, null)) {
                return;
            }
            this.delegate.flush();
        }

        private boolean tryFail(ResponseHandler handler1, ResponseHandler handler2) {
            Throwable failure = this.nextRunFailure.getAndSet(null);
            if (failure != null) {
                int reportCount = this.count.get();
                if (handler1 != null) {
                    handler1.onFailure(failure);
                    reportCount = this.count.decrementAndGet();
                }
                if (handler2 != null) {
                    handler2.onFailure(failure);
                    reportCount = this.count.decrementAndGet();
                }
                if (reportCount > 0) {
                    this.nextRunFailure.compareAndSet(null, failure);
                }
                return true;
            }
            return false;
        }
    }

    private static class ConnectionPoolWithFailingConnections
    implements ConnectionPool {
        final ConnectionPool delegate;
        final AtomicReference<Throwable> nextRunFailure;

        ConnectionPoolWithFailingConnections(ConnectionPool delegate, AtomicReference<Throwable> nextRunFailure) {
            this.delegate = delegate;
            this.nextRunFailure = nextRunFailure;
        }

        public CompletionStage<Connection> acquire(BoltServerAddress address) {
            return this.delegate.acquire(address).thenApply(connection -> new FailingConnection((Connection)connection, this.nextRunFailure));
        }

        public void retainAll(Set<BoltServerAddress> addressesToRetain) {
            this.delegate.retainAll(addressesToRetain);
        }

        public int inUseConnections(ServerAddress address) {
            return this.delegate.inUseConnections(address);
        }

        public int idleConnections(ServerAddress address) {
            return this.delegate.idleConnections(address);
        }

        public CompletionStage<Void> close() {
            return this.delegate.close();
        }

        public boolean isOpen(BoltServerAddress address) {
            return this.delegate.isOpen(address);
        }
    }
}

